<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Admin extends CI_Controller {

    public function __construct() {
        parent::__construct();
        //$this->load->library('excel'); 
        $this->load->library('session');
        $this->load->helper('comman');
        $this->load->library('form_validation');
        $this->load->model('Adminmodel');
        $this->load->model('Commanmodel');
        $this->load->model('Developermodel');
        $this->load->model('Usersmodel');
        $this->load->model('Praposalmodel');
        $this->load->model('Enquirymodel');
        $this->load->model('Contactenquirymodel');
        
        $this->load->model('Reviewmodel');
        $this->load->model('Areareviewmodel');
        $this->load->model('Areaenquirymodel');
        
        $this->load->model('Activeenquirymodel');
        $this->load->model('Salesremindermodel');
        $this->load->model('Inventorymodel');
        $this->load->model('Salesteammodel');
        $this->load->model('Paymentmodel');
    }

    // Default call to login page
    public function index()
    {
        $data = array(
        'title' => "Admin Login - Online Service", 
        'keyword' => "Online Service | Online Portal",
        'description' => "Online Service Portal", 
        );
        $this->load->view('admin/login',$data);
    }

    public function admin_login() {
            $email = $this->input->post('email');
            $password = md5($this->input->post('password'));
            $login_id = $this->Adminmodel->login_valid($email, $password);
            if ($login_id) {
                $this->session->set_userdata('admin_id', $login_id);
                redirect(base_url('admin/dashboard'));
            } 
            else 
            {
                $this->session->set_flashdata('login_failed', 'Invalid Email-Id and Password');
                redirect(base_url('admin/'));
            }
    }
    
  
public function address_manage()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['addressView'] = $this->Commanmodel->get_single_query('address',array('id' => 1));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/manage-address',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }





 public function address_manage_process()
    {
        if($this->session->userdata('admin_id'))
        {
        if($this->input->post('pageUpdated'))
        {
    $post_data = array(
    'email' => $this->input->post('email'),
    'phone_one' => $this->input->post('phone_one'),
    'phone_two' => $this->input->post('phone_two'),
    'phone_two' => $this->input->post('phone_two'),
    'address' => $this->input->post('address'),
    'copyright' => $this->input->post('copyright'),
    'facebook' => $this->input->post('facebook'),
    'twitter' => $this->input->post('twitter'),
    'linkedin' => $this->input->post('linkedin'),
    'instagram' => $this->input->post('instagram')
    );
                   $inserted = $this->Commanmodel->update_query('address',$post_data,array('id' => 1)); 
                   if($inserted)
                   {
                    $this->session->set_flashdata('created', 'This address has been updated.');
                    redirect(base_url('admin/address_manage'));
                   }
                   else
                   {
            $this->session->set_flashdata('failed', 'Sorry, This address has not been updated. Please try again?');    
        $data['addressView'] = $this->Commanmodel->get_single_query('address',array('id' => 1));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/manage-address',$data);
        $this->load->view('admin/footer');
                   }


                
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
        $data['addressView'] = $this->Commanmodel->get_single_query('address',array('id' => 1));     
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/manage-address',$data);
        $this->load->view('admin/footer');
        }



        }
        else
        {
            redirect(base_url('admin/'));
        }
    }



    public function pramotion_banner()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['pramotionView'] = $this->Commanmodel->get_single_query('pramotion',array('id' => 1));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/pramotion-banner',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }



    

 public function pramotion_banner_process()
    {
        if($this->session->userdata('admin_id'))
        {
        if($this->input->post('pageUpdated'))
        {

          if($_FILES['banner']['name']!=""){
          $config['upload_path']          = 'assets/upload/';
          $config['allowed_types']        = '*';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('banner')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $banner=$upload_data['file_name'];
          }
          }
          else{
          $banner = $this->input->post('banner_old');
          }


    $post_data = array(
    'banner' => $banner,
    'tag_content' => $this->input->post('tag_content'),
    'url_redirect' => $this->input->post('url_redirect')
    );
                   $inserted = $this->Commanmodel->update_query('pramotion',$post_data,array('id' => 1)); 
                   if($inserted)
                   {
                    $this->session->set_flashdata('created', 'This Pramotion Banner has been updated.');
                    redirect(base_url('admin/pramotion_banner'));
                   }
                   else
                   {
            $this->session->set_flashdata('failed', 'Sorry, This Pramotion Banner has not been updated. Please try again?');    
        $data['pramotionView'] = $this->Commanmodel->get_single_query('pramotion',array('id' => 1));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/pramotion-banner',$data);
        $this->load->view('admin/footer');
                   }


                
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
        $data['pramotionView'] = $this->Commanmodel->get_single_query('pramotion',array('id' => 1));     
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/pramotion-banner',$data);
        $this->load->view('admin/footer');
        }



        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    
    
        // Default call to send reset link page
    public function forgetpassword()
    {
        $data = array(
        'title' => "Forget Password", 
        'keyword' => "Forget Password",
        'description' => "Forget Password", 
        );
        $this->load->view('admin/forget-password',$data);
    }
    
    
    
    public function forget_password_process() {
            $email = $this->input->post('email');
            $checkCount = $this->Adminmodel->checkCountAdmin($email);
            if($checkCount) {
               
               $createCode = $this->Commanmodel->generate_email_otp($email);
               
               
                
         $to = $email;
         $subject = "Reset password link";
         $message = '<html><body style="background-color:#e2e1e0;font-family: Open Sans, sans-serif;font-size:100%;font-weight:400;line-height:1.4;color:#000;">
  <table style="width: 746px;
    margin: 1px auto 1px;
    background-color: #fff;
    padding: 50px;
    border-radius: 3px;
    border-top: solid 2px #ececec;
    border-bottom: solid 2px #eceaea;">
    <thead>
      <tr>
        <th style="text-align:left;"><img style="max-width: 150px;" src="'.base_url('assets/front/images/logo.png').'" alt="investodeck.com"></th>
        <th style="text-align:right;font-weight:400;">'.date('d-M, Y').'</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td style="height:35px;"></td>
      </tr>
      <tr>
        <td style="width:100%;padding:20px;vertical-align:top">
          <p style="margin:0 0 10px 0;padding:0;font-size:14px;"><span style="display:block;font-weight:bold;font-size:13px">Name</span>Reset password link</p>
          <p style="margin:0 0 10px 0;padding:0;font-size:14px;"><span style="display:block;font-weight:bold;font-size:13px;"></span><a href="'.base_url('reset-password-link/'.$createCode.'').'">Click here</a></p>
        </td>
      </tr>
      
    </tbody>
    <tfooter>
      <tr>
        <td colspan="2" style="font-size:14px;padding:50px 15px 0 15px;">
          <strong style="display:block;margin:0 0 10px 0;">Regards</strong> House Mitra<br> 
           INDIA<br><br>
          <b>Mobile:</b> +91-xxx xxx xxxx<br>
          <b>Email:</b> info@housemitra.com
        </td>
      </tr>
    </tfooter>
  </table>
</body>
</html>';
         $header = "From:Admin Reset Password<info@housemitra.com> \r\n";
         $header .= "Cc:info@housemitra.com \r\n";
         $header .= "MIME-Version: 1.0\r\n";
         $header .= "Content-type: text/html\r\n";
         $retval = mail($to,$subject,$message,$header);
            if( $retval == true ) {
            $this->session->set_flashdata('created', 'Success! We have send mail your email address in Inbox, Spam and All mail');    
            redirect(base_url('admin/forgetpassword'));
            }else {
            $this->session->set_flashdata('created', 'Success! We have send mail your email address in Inbox, Spam and All mail');
            redirect(base_url('admin/forgetpassword'));
            }
                
            } 
            else 
            {
                $this->session->set_flashdata('failed', 'Invalid email address');
                redirect(base_url('admin/forgetpassword'));
            }
    }
    
    
    public function reset_password_link($validCode)
    {
        if($_SESSION['email']['email_otp']==$validCode)
        {
            $data = array('validCode' => $validCode);
        $this->load->view('admin/reset-password',$data); // index.php
        }
        else
        {
            redirect(base_url(''));
        }
    }
    
    
    
    
    
    
    
    
 
    public function logout() {
        $this->session->unset_userdata('admin_id');
        $this->session->set_flashdata('login_failed', 'Successfully logged out!');
        redirect(base_url('admin/'));
    }

    public function dashboard()
    {
        if($this->session->userdata('admin_id'))
        {
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/index'); // index.php
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }




      
   


    public function create_employee()
    {
        if($this->session->userdata('admin_id'))
        {    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/create-employee');
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }
    public function create_employee_process()
    {
        if($this->session->userdata('admin_id'))
        {
        if($this->input->post('CreateNewEmployee'))
        {
        $this->form_validation->set_rules('user_type', 'Type', 'required',
            array('required'  =>  'Please select type!'));

        $this->form_validation->set_rules('user_empId', 'Employee Id', 'required|is_unique[user_account.user_empId]',array(
          'required'  =>  'Please enter employee id',
          'is_unique'  =>  'This Employee id is already exists!'
        ));

        $this->form_validation->set_rules('user_name', 'User name', 'required',
            array('required'  =>  'Please enter name'));

        $this->form_validation->set_rules('user_mobile', 'User mobile', 'required|is_unique[user_account.user_phone]',array(
          'required'  =>  'Please enter mobile',
          'is_unique'  =>  'This mobile is already exists!'
        ));

        $this->form_validation->set_rules('user_email', 'Email Address', 'valid_email|is_unique[user_account.user_email]',
            array(
                'valid_email'  =>  'Please enter valid email!',
                'is_unique'  =>  'This email-Id is already exists!' 
             )
             );
        $this->form_validation->set_rules('user_password', 'Password', 'required|min_length[5]|max_length[15]',
            array(
                'required'  =>  'Please enter password!',
                'min_length'  =>  'Password min length 5!',
             )
             );
        $this->form_validation->set_rules('user_address', 'User Address', 'required',
            array('required'  =>  'Please enter address'));

        $this->form_validation->set_rules('user_status', 'User status', 'required',array('required'  =>  'Please select status'));

        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/create-employee');
            $this->load->view('admin/footer');
                }
                else
                {
    $status = $this->input->post('user_status');
    if($status=='Active')
    {
      $status_color = 'success';
    }
    if($status=='Inactive')
    {
      $status_color = 'danger';
    }
    $post_data = array(
    'user_type' => $this->input->post('user_type'),
    'user_empId' => $this->input->post('user_empId'),    
    'user_name' => $this->input->post('user_name'),
    'user_phone' => $this->input->post('user_mobile'),
    'user_email' => $this->input->post('user_email'),
    'user_password' => md5($this->input->post('user_password')),
    'user_password_show' => $this->input->post('user_password'),
    'user_address' => $this->input->post('user_address'),
    'user_status' => $this->input->post('user_status'),
    'user_status_color' => $status_color,
    'user_detail' => $this->input->post('user_detail'),
    'register_date' => date('Y-m-d')
    );
    $inserted = $this->Commanmodel->insert_query('user_account',$post_data); 
    if($inserted)
    {
        
         $user_type = $this->input->post('user_type');
         $userName = $this->input->post('user_name');
         $userMobile = $this->input->post('user_mobile');
         $userEmail = $this->input->post('user_email');
         $userPassword = $this->input->post('user_password');
         $userStatus = $this->input->post('user_status');
         $userAddress = $this->input->post('user_address');

         if($user_type=='Sales Head')
         {
           $accountLink = 'saleshead';
         }
         if($user_type=='Booking')
         {
           $accountLink = 'booking';
         }
         $to = $userEmail;
         $subject = "$user_type Account - $userName";
         $message = '<html><body style="background-color:#e2e1e0;font-family: Open Sans, sans-serif;font-size:100%;font-weight:400;line-height:1.4;color:#000;">
  <table style="width: 746px;
    margin: 1px auto 1px;
    background-color: #fff;
    padding: 50px;
    border-radius: 3px;
    border-top: solid 2px #ececec;
    border-bottom: solid 2px #eceaea;">
    <thead>
      <tr>
        <th style="text-align:left;"><img style="max-width: 150px;" src="https://investodeck.com/crm/assets/investodeck-logo.png" alt="investodeck.com"></th>
        <th style="text-align:right;font-weight:400;">'.date('d-M, Y').'</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td style="height:35px;"></td>
      </tr>
      <tr>
        <td style="width:50%;padding:20px;vertical-align:top">
          <p style="margin:0 0 10px 0;padding:0;font-size:14px;"><span style="display:block;font-weight:bold;font-size:13px">Name</span> '.$userName.'</p>
          <p style="margin:0 0 10px 0;padding:0;font-size:14px;"><span style="display:block;font-weight:bold;font-size:13px;">Phone</span> '.$userMobile.'</p>
          <p style="margin:0 0 10px 0;padding:0;font-size:14px;"><span style="display:block;font-weight:bold;font-size:13px;">Email</span> '.$userEmail.'</p>
          <p style="margin:0 0 10px 0;padding:0;font-size:14px;"><span style="display:block;font-weight:bold;font-size:13px;">Password</span> '.$userPassword.'</p>
        </td>
        <td style="width:50%;padding:20px;vertical-align:top">
          <p style="margin:0 0 10px 0;padding:0;font-size:14px;"><span style="display:block;font-weight:bold;font-size:13px;">Address</span> '.$userAddress.'</p>
          <p style="margin:0 0 10px 0;padding:0;font-size:14px;"><span style="display:block;font-weight:bold;font-size:13px;">Status</span> '.$userStatus.'</p>
          <p style="margin:0 0 10px 0;padding:0;font-size:14px;">
            <a href="https://investodeck.com/crm/'.$accountLink.'/" style="background-color: #00a6dd;border: none;color: white;padding: 7px 11px;text-align: center;text-decoration: none;display: inline-block;">Login Account Link</a>
          </p>
        </td>
      </tr>
      
    </tbody>
    <tfooter>
      <tr>
        <td colspan="2" style="font-size:14px;padding:50px 15px 0 15px;">
          <strong style="display:block;margin:0 0 10px 0;">Regards</strong> Investodeck<br> 
           INDIA<br><br>
          <b>Mobile:</b> +91-xxx xxx xxxx<br>
          <b>Email:</b> info@investodeck.com
        </td>
      </tr>
    </tfooter>
  </table>
</body>
</html>';
         $header = "From:Investodeck <info@investodeck.com> \r\n";
         $header .= "Cc:info@investodeck.com \r\n";
         $header .= "MIME-Version: 1.0\r\n";
         $header .= "Content-type: text/html\r\n";
         $retval = mail($to,$subject,$message,$header);
            if( $retval == true ) {
            $this->session->set_flashdata('created', 'This account has been created.');
            redirect(base_url('admin/create_employee'));
            }else {
            $this->session->set_flashdata('created', 'This account has been created.');
            redirect(base_url('admin/create_employee'));
            }
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This account has not been created. Please try again?');    
    $this->load->view('admin/head');
    $this->load->view('admin/sidebar');
    $this->load->view('admin/create-employee');
    $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/create-employee');
            $this->load->view('admin/footer');
        }



        }
        else
        {
            redirect(base_url('admin/'));
        }
    }
    
    public function edit_employee($employee_id)
    {
        $singleUser = $this->Commanmodel->get_single_query('user_account',array('account_id' =>  $employee_id));
        $data = array('singleUser' => $singleUser);  
        if($this->session->userdata('admin_id'))
        {    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-employee',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function edit_employee_process($employee_id)
    {
        $singleUser = $this->Commanmodel->get_single_query('user_account',array('account_id' =>  $employee_id));
        $data = array('singleUser' => $singleUser);
        if($this->session->userdata('admin_id'))
        {
        if($this->input->post('EditEmployee'))
        {
        $this->form_validation->set_rules('user_type', 'Type', 'required',
            array('required'  =>  'Please select type'));

        $this->form_validation->set_rules('user_empId', 'Employee Id', 'required',
            array('required'  =>  'Please enter employee id'));

        $this->form_validation->set_rules('user_name', 'User name', 'required',
            array('required'  =>  'Please enter name'));

        $this->form_validation->set_rules('user_mobile', 'User mobile', 'required',array(
          'required'  =>  'Please enter mobile'
        ));
        $this->form_validation->set_rules('user_email', 'Email Address', 'valid_email',
            array(
                'valid_email'  =>  'Please enter valid email!'
             )
             );
        $this->form_validation->set_rules('user_password', 'Password', 'required|min_length[5]|max_length[15]',
            array(
                'required'  =>  'Please enter password!',
                'min_length'  =>  'Password min length 5!',
             )
             );
        $this->form_validation->set_rules('user_address', 'User Address', 'required',
            array('required'  =>  'Please enter address'));
        $this->form_validation->set_rules('user_status', 'User status', 'required',array('required'  =>  'Please select status'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-employee',$data);
            $this->load->view('admin/footer');
                }
                else
                {
    $status = $this->input->post('user_status');
    if($status=='Active')
    {
      $status_color = 'success';
    }
    if($status=='Inactive')
    {
      $status_color = 'danger';
    }
    $post_data = array(
    'user_type' => $this->input->post('user_type'),
    'user_empId' => $this->input->post('user_empId'),
    'user_name' => $this->input->post('user_name'),
    'user_phone' => $this->input->post('user_mobile'),
    'user_email' => $this->input->post('user_email'),
    'user_password' => md5($this->input->post('user_password')),
    'user_password_show' => $this->input->post('user_password'),
    'user_address' => $this->input->post('user_address'),
    'user_status' => $this->input->post('user_status'),
    'user_status_color' => $status_color,
    'user_detail' => $this->input->post('user_detail')
    );
    $inserted = $this->Commanmodel->update_query('user_account',$post_data,array('account_id' => $employee_id)); 
    if($inserted)
    {
    $this->session->set_flashdata('created', 'This account has been updated.');
    redirect(base_url('admin/edit_employee/'.$employee_id.''));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This account has not been updated. Please try again?');    
    $this->load->view('admin/head');
    $this->load->view('admin/sidebar');
    $this->load->view('admin/edit-employee',$data);
    $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-employee',$data);
            $this->load->view('admin/footer');
        }



        }
        else
        {
            redirect(base_url('admin/'));
        }
    }   





    

    public function agent_builder()
    {
        if($this->session->userdata('admin_id'))
        {    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/agent-builder');
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


  //  user_list page Load After Login Account
  public function list_salesteam_ajax()
  {
        if($this->session->userdata('admin_id'))
        {
        $allcourses=$this->Salesteammodel->get_datatables();
        $data = array();
        $no = $_POST['start'];
        $ia=1;
        foreach ($allcourses as $users_view) {
           $status = '<a href="javascript:void(0);" class="btn btn-'.$users_view->user_status_color.' btn-xs">'.$users_view->user_status.'</a> | ';
           $action = '<a href="'.base_url('admin/edit_sales/'.$users_view->id.'').'" class="btn btn-primary btn-xs">Edit</a>';
          $userDate = date('d M, Y',strtotime($users_view->register_date));
            
            $no++;
            $row = array();
            $row[] = $ia;
            $row[] = '<a href="javascript:void(0);" class="btn btn-'.$users_view->user_status_color.' btn-xs">'.$userDate.'</a>';
            $row[] = $users_view->name.'<br>'.$users_view->mobile;
            $row[] = $users_view->email.'<br>';
            $row[] = $status.$action;
            $data[] = $row;
        $ia++;    
        }
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->Salesteammodel->count_all(),
                        "recordsFiltered" => $this->Salesteammodel->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);

    }
    else
    {
    redirect(base_url('admin/'));
    }
  }


public function edit_sales($employee_id)
    {
        $singleUser = $this->Commanmodel->get_single_query('users',array('id' =>  $employee_id));
        $data = array('singleUser' => $singleUser);  
        if($this->session->userdata('admin_id'))
        {    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-sales-team',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function edit_sales_process($employee_id)
    {
        $singleUser = $this->Commanmodel->get_single_query('users',array('id' =>  $employee_id));
        $data = array('singleUser' => $singleUser);
        if($this->session->userdata('admin_id'))
        {
        if($this->input->post('EditSales'))
        {
        $this->form_validation->set_rules('user_name', 'name', 'required',
            array('required'  =>  'Please enter name'));
        $this->form_validation->set_rules('user_mobile', 'mobile', 'required',array(
          'required'  =>  'Please enter mobile'
        ));
        $this->form_validation->set_rules('user_email', 'Email Address', 'valid_email',
            array(
                'valid_email'  =>  'Please enter valid email!'
             )
             );
        $this->form_validation->set_rules('user_status', 'User status', 'required',array('required'  =>  'Please select status'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-sales-team',$data);
            $this->load->view('admin/footer');
                }
                else
                {
    $status = $this->input->post('user_status');
    if($status=='Active')
    {
      $status_color = 'success';
    }
    if($status=='Inactive')
    {
      $status_color = 'danger';
    }
    $post_data = array(
    'name' => $this->input->post('user_name'),
    'mobile' => $this->input->post('user_mobile'),
    'email' => $this->input->post('user_email'),
    'address' => $this->input->post('user_address'),
    'user_status' => $this->input->post('user_status'),
    'user_status_color' => $status_color
    );
    $inserted = $this->Commanmodel->update_query('users',$post_data,array('id' => $employee_id)); 
    if($inserted)
    {
    $this->session->set_flashdata('created', 'This account has been updated.');
    redirect(base_url('admin/edit_sales/'.$employee_id.''));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This account has not been updated. Please try again?');    
    $this->load->view('admin/head');
    $this->load->view('admin/sidebar');
    $this->load->view('admin/edit-sales-team',$data);
    $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-sales-team',$data);
            $this->load->view('admin/footer');
        }



        }
        else
        {
            redirect(base_url('admin/'));
        }
    }






    public function registred_users()
    {
        if($this->session->userdata('admin_id'))
        {    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/registred-users');
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


  //  user_list page Load After Login Account
  public function list_users_ajax()
  {
        if($this->session->userdata('admin_id'))
        {
        $allcourses=$this->Usersmodel->get_datatables();
        $data = array();
        $no = $_POST['start'];
        $ia=1;
        foreach ($allcourses as $users_view) {
           $status = '<a href="javascript:void(0);" class="btn btn-'.$users_view->user_status_color.' btn-xs">'.$users_view->user_status.'</a><br>';

           $action = '<a href="'.base_url('admin/edit_employee/'.$users_view->account_id.'').'" class="btn btn-primary btn-xs">Edit</a>';

            if($users_view->user_type==1)
            {
               $userType = 'Marketing';
            }
            elseif($users_view->user_type==2)
            {
               $userType = 'Marketing';
            }
            elseif($users_view->user_type==3)
            {
               $userType = 'Marketing';
            }
            else
            {
              $userType = 'NULL';
            }

            $no++;
            $row = array();
            $row[] = $ia;
            $row[] = '<a href="javascript:void(0);" class="btn btn-'.$users_view->user_status_color.' btn-xs">'.$userType.'</a><br>'.$users_view->user_empId;
            $row[] = $users_view->user_name.'<br>'.$users_view->user_phone;
            $row[] = $users_view->user_email.'<br>'.$users_view->user_password_show;
            $row[] = $users_view->user_address;
            $row[] = $status.$action;
            $data[] = $row;
        $ia++;    
        }
 
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->Usersmodel->count_all(),
                        "recordsFiltered" => $this->Usersmodel->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);

    }
    else
    {
    redirect(base_url('admin/'));
    }
  }


  public function our_team()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['teamView'] = $this->Commanmodel->get_multiple_query_order_by('partners','client_id','DESC');    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/our-team',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function our_team_process()
    {
      $ourTeam = $this->Commanmodel->get_multiple_query_order_by('partners','client_id','DESC');
      $data = array('teamView' => $ourTeam);  
        if($this->session->userdata('admin_id'))
        {

        if($this->input->post('CreateTeam'))
        {

            if($_FILES['people_photo']['name']!=""){
                $config['upload_path']          = 'assets/upload/client/';
                $config['allowed_types']        = 'gif|jpg|png|jpeg';
                $config['max_size']             = 0;
                $config['remove_spaces'] = TRUE;
                $config['encrypt_name'] = TRUE;
                $this->load->library('upload',$config);
                $this->load->initialize('upload', $config);
                if(!$this->upload->do_upload('people_photo')){
                    $error = array('error' => $this->upload->display_errors());
                }
                else{
                    $upload_data=$this->upload->data();
                    $people_photo=$upload_data['file_name'];
                }
            }
            else{
            $this->session->set_flashdata('failed', 'Please choose Image');    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/our-team',$data);
        $this->load->view('admin/footer');
            }
         $status = $this->input->post('people_status'); 
         if($status=='Active')
         {
           $status_color = 'success';
         }
         if($status=='Inactive')
         {
           $status_color = 'danger';
         }
        $post_data = array(
        'name' => $this->input->post('people_name'),
        'designation' => $this->input->post('people_designation'),
        'image' => $people_photo,
        'status' => $this->input->post('people_status'),
        'status_color' => $status_color,
        'facebook' => $this->input->post('facebook'),
        'twitter' => $this->input->post('twitter'),
        'instagram' => $this->input->post('instagram'),
        'linkedin' => $this->input->post('linkedin')
        );
        $inserted = $this->Commanmodel->insert_query('partners',$post_data); 
                   if($inserted)
                   {
                    $this->session->set_flashdata('created', 'This Team member has been saved.');
                    redirect(base_url('admin/our_team'));
                   }
                   else
                   {
            $this->session->set_flashdata('failed', 'Sorry, This Team member has not been saved.');  
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/our-team',$data);
        $this->load->view('admin/footer');
                   }


            }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/our-team',$data);
        $this->load->view('admin/footer');
        }  

        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function edit_our_team($client_id)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['teamView'] = $this->Commanmodel->get_single_query('partners',array('client_id' => $client_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-our-team',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

public function edit_our_team_process($client_id)
    {
      $data['teamView'] = $this->Commanmodel->get_single_query('partners',array('client_id' => $client_id)); 
        if($this->session->userdata('admin_id'))
        {
        if($this->input->post('EditTeam'))
        {

            if($_FILES['people_photo']['name']!=""){
                $config['upload_path']          = 'assets/upload/client/';
                $config['allowed_types']        = 'gif|jpg|png|jpeg';
                $config['max_size']             = 0;
                $config['remove_spaces'] = TRUE;
                $config['encrypt_name'] = TRUE;
                $this->load->library('upload',$config);
                $this->load->initialize('upload', $config);
                if(!$this->upload->do_upload('people_photo')){
                    $error = array('error' => $this->upload->display_errors());
                }
                else{
                    $upload_data=$this->upload->data();
                    $people_photo=$upload_data['file_name'];
                }
            }
            else{
            $people_photo = $this->input->post('people_photo_old');
            }
         $status = $this->input->post('people_status'); 
         if($status=='Active')
         {
           $status_color = 'success';
         }
         if($status=='Inactive')
         {
           $status_color = 'danger';
         }
        $post_data = array(
        'name' => $this->input->post('people_name'),
        'designation' => $this->input->post('people_designation'),
        'image' => $people_photo,
        'status' => $this->input->post('people_status'),
        'status_color' => $status_color,
        'facebook' => $this->input->post('facebook'),
        'twitter' => $this->input->post('twitter'),
        'instagram' => $this->input->post('instagram'),
        'linkedin' => $this->input->post('linkedin')
        );
        $inserted = $this->Commanmodel->update_query('partners',$post_data,array('client_id' => $client_id)); 
                   if($inserted)
                   {
                    $this->session->set_flashdata('created', 'This Team member has been updated.');
                    redirect(base_url('admin/our_team'));
                   }
                   else
                   {
            $this->session->set_flashdata('failed', 'Sorry, This Team member has not been saved.');  
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-our-team',$data);
        $this->load->view('admin/footer');
                   }


            }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-our-team',$data);
        $this->load->view('admin/footer');
        }  

        }
        else
        {
            redirect(base_url('admin/'));
        }
    }



    public function delete_our_team($client_id)
    {
     $deleteClient = $this->Commanmodel->delete_query('partners',array('client_id' =>$client_id));
     if($deleteClient)
     {
      $this->session->set_flashdata('created', 'This Team Member is delete.');
      redirect(base_url('admin/our_team'));
     }
     else
     {
      $this->session->set_flashdata('failed', 'This Team Member is not delete!');
      redirect(base_url('admin/our_team')); 
     }
    }



    public function people_say()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['peopleSayView'] = $this->Commanmodel->get_multiple_query_order_by('people_say','people_id','DESC');    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/people-say',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

     public function people_say_process()
    {
        if($this->session->userdata('admin_id'))
        {

        if($this->input->post('CreatePeopleSay'))
        {

            if($_FILES['people_photo']['name']!=""){
                $config['upload_path']          = 'assets/upload/client/';
                $config['allowed_types']        = 'gif|jpg|png|jpeg';
                $config['max_size']             = 0;
                $this->load->library('upload',$config);
                if(!$this->upload->do_upload('people_photo')){
                    $error = array('error' => $this->upload->display_errors());
                }
                else{
                    $upload_data=$this->upload->data();
                    $people_photo=$upload_data['file_name'];
                }
            }
            else{
            $this->session->set_flashdata('failed', 'Please choose Image');
        $data['peopleSayView'] = $this->Commanmodel->get_multiple_query_order_by('people_say','people_id','DESC');    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/people-say',$data);
        $this->load->view('admin/footer');
            }
         $status = $this->input->post('people_status'); 
         if($status=='Active')
         {
           $status_color = 'success';
         }
         if($status=='Inactive')
         {
           $status_color = 'danger';
         }

        $post_data = array(
        'people_name' => $this->input->post('people_name'),
        'people_designation' => $this->input->post('people_designation'),
        'people_image' => $people_photo,
        'people_status' => $this->input->post('people_status'),
        'people_status_color' => $status_color,
        'people_description' => $this->input->post('people_description')
        );
        $inserted = $this->Commanmodel->insert_query('people_say',$post_data); 
                   if($inserted)
                   {
                    $this->session->set_flashdata('created', 'This people say has been saved.');
                    redirect(base_url('admin/people_say'));
                   }
                   else
                   {
            $this->session->set_flashdata('failed', 'Sorry, This people say has not been saved.');
        $data['peopleSayView'] = $this->Commanmodel->get_multiple_query_order_by('people_say','people_id','DESC');    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/people-say',$data);
        $this->load->view('admin/footer');
                   }


            }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');
        $data['peopleSayView'] = $this->Commanmodel->get_multiple_query_order_by('people_say','people_id','DESC');    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/people-say',$data);
        $this->load->view('admin/footer');
        }  

        }
        else
        {
            redirect(base_url('admin/'));
        }
    }



    public function delete_people_say($people_id)
    {
     $deleteClient = $this->Commanmodel->delete_query('people_say',array('people_id' =>$people_id));
     if($deleteClient)
     {
      $this->session->set_flashdata('created', 'This People Say is delete.');
      redirect(base_url('admin/people_say'));
     }
     else
     {
      $this->session->set_flashdata('failed', 'This is not delete!');
      redirect(base_url('admin/people_say')); 
     }
    }


    public function edit_people_say($people_id)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['peopleSayView'] = $this->Commanmodel->get_single_query('people_say',array('people_id' => $people_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-people-say',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function edit_people_say_process($people_id)
    {
        if($this->session->userdata('admin_id'))
        {

        if($this->input->post('EditPeopleSay'))
        {

            if($_FILES['people_photo']['name']!=""){
                $config['upload_path']          = 'assets/upload/client/';
                $config['allowed_types']        = 'gif|jpg|png|jpeg';
                $config['max_size']             = 0;
                $this->load->library('upload',$config);
                if(!$this->upload->do_upload('people_photo')){
                    $error = array('error' => $this->upload->display_errors());
                }
                else{
                    $upload_data=$this->upload->data();
                    $people_photo=$upload_data['file_name'];
                }
            }
            else{
              $people_photo = $this->input->post('people_photo_old');
            }
         $status = $this->input->post('people_status'); 
         if($status=='Active')
         {
           $status_color = 'success';
         }
         if($status=='Inactive')
         {
           $status_color = 'danger';
         }

        $post_data = array(
        'people_name' => $this->input->post('people_name'),
        'people_designation' => $this->input->post('people_designation'),
        'people_image' => $people_photo,
        'people_status' => $this->input->post('people_status'),
        'people_status_color' => $status_color,
        'people_description' => $this->input->post('people_description')
        );
        $inserted = $this->Commanmodel->update_query('people_say',$post_data,array('people_id' => $people_id)); 
                   if($inserted)
                   {
                    $this->session->set_flashdata('created', 'This people say has been Updated.');
                    redirect(base_url('admin/people_say'));
                   }
                   else
                   {
            $this->session->set_flashdata('failed', 'Sorry, This people say has not been updated.');
        $data['peopleSayView'] = $this->Commanmodel->get_single_query('people_say',array('people_id' => $people_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-people-say',$data);
        $this->load->view('admin/footer');
                   }


            }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');
        $data['peopleSayView'] = $this->Commanmodel->get_single_query('people_say',array('people_id' => $people_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-people-say',$data);
        $this->load->view('admin/footer');
        }  

        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


  public function change_password()
    {
        if($this->session->userdata('admin_id'))
        {    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/change-password');
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function change_password_process()
    {
        if($this->session->userdata('admin_id'))
        {
        if($this->input->post('ResetPassword'))
        {
        $this->form_validation->set_rules('current_password', 'Password', 'trim|required',array('required'=>'Enter current password'));
        $this->form_validation->set_rules('new_password', 'New Password', 'required|matches[confirm_password]',array('matches'=>'Password not match with confirm password','required'=>'Enter new password'));
        $this->form_validation->set_rules('confirm_password', 'Retype Password', 'required',array('required'=>'Enter confirm password'));

        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/change-password');
            $this->load->view('admin/footer');
                }
                else
                {
            $oldPassword = md5($this->input->post('current_password'));
            $UserId = $this->session->userdata('admin_id');
            $query = $this->Commanmodel->checkOldPass($oldPassword,$UserId);
            if($query)
            {
                $NewPassword = md5($this->input->post('new_password'));
                $query = $this->Commanmodel->saveNewPass($NewPassword,$UserId);
                if($query)
                {
                $this->session->set_flashdata('created', 'Password has been successfully changed.');
                redirect(base_url('admin/change_password'));
                }
                else
                {
                $this->session->set_flashdata('failed', 'Password has not been successfully changed.');
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/change-password');
            $this->load->view('admin/footer');
                }
            }
            else
            {
            $this->session->set_flashdata('failed', 'Current password is not match');
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/change-password');
            $this->load->view('admin/footer');
            }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/change-password');
            $this->load->view('admin/footer');
        }



        }
        else
        {
            redirect(base_url('admin/'));
        }
    }   




    function update_detail_process()
    {
        if($this->session->userdata('admin_id'))
        {
        $column_name = $this->input->post('column_name');
        $value = $this->input->post('value');
        $where = $this->input->post('id');
        $updated = $this->Commanmodel->update_query_custome('contact_us',$column_name,$value,$where);
        if($updated)
        {
            echo "Detail inserted";
        }
        else
        {
            echo "Sorry, This is not update!";
        }

        }
        else
        {
            redirect(base_url('admin/'));
        }   
    }

  


    public function reset_password_process($validCode)
    {
        $data = array('validCode' => $validCode);
        if($this->input->post('SubmitPassword'))
        {
        $this->form_validation->set_rules('new_password', 'New Password', 'required|matches[confirm_password]',array('matches'=>'Password not match with confirm password','required'=>'Enter new password'));
        $this->form_validation->set_rules('confirm_password', 'Retype Password', 'required',array('required'=>'Enter confirm password'));

        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/reset-password',$data);
                }
                else
                {
            
            if($_SESSION['email']['email_otp']==$validCode)
            {
                $NewPassword = md5($this->input->post('new_password'));
                $query = $this->Commanmodel->update_query('admin',array('password' => $NewPassword),array('id' => '1000'));
                if($query)
                {
                    unset($_SESSION['email']);
                $this->session->set_flashdata('created', 'Password has been successfully changed. Please login now');
                redirect(base_url(''));
                }
                else
                {
                $this->session->set_flashdata('failed', 'Password has not been created.');
                $this->load->view('admin/reset-password',$data);
                }
            }
            else
            {
            $this->session->set_flashdata('failed', 'Expire OTP Time');
            $this->load->view('admin/reset-password',$data);
            }


            }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/reset-password',$data);
        }

    }   
    
    
        
    

    
    public function property(){
        if($this->session->userdata('admin_id'))
        {    
        //$data = array('status' => '2','message' => 'Under Approvel'); 
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/property');
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function property_pending(){
        if($this->session->userdata('admin_id'))
        {    
        $data = array('status' => '4','message' => 'Pending'); 
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/property',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function property_approved(){
        if($this->session->userdata('admin_id'))
        {    
        $data = array('status' => '3','message' => 'Approved'); 
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/property',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }
    

    //  property list page Load After Login Account
    public function list_property_ajax()
    {
        if($this->session->userdata('admin_id'))
        {
        $allProperty=$this->Inventorymodel->get_datatables();
        $data = array();
        $no = $_POST['start'];
        $ia=1;
        foreach ($allProperty as $allPropertyview) {
           $catNameShow = '';
           if($allPropertyview->category!='')
           {
               $categorySelected = explode(',',$allPropertyview->category);
               for($i = 0; $i < count($categorySelected); $i++)
               {
                $category = $this->Commanmodel->get_single_query('category',array('categoryToken' => $categorySelected[$i]));
                $catNameShow .= '<span><i class="fa fa-circle" style="font-size: 10px;" aria-hidden="true"></i> <strong>'.$category->category.'</strong></span><br>';
               }
           }
           else
           {
               $catNameShow = '';
           }
           $categoryName = $catNameShow;

           $childcatNameShow = '';
           if($allPropertyview->childcategory!='')
           {
               $categorySelected = explode(',',$allPropertyview->childcategory);
               for($i = 0; $i < count($categorySelected); $i++)
               {
                $childcategory = $this->Commanmodel->get_single_query('category',array('categoryToken' => $categorySelected[$i]));
                $childcatNameShow .= '<span><i class="fa fa-circle" style="font-size: 7px;" aria-hidden="true"></i> '.$childcategory->category.'</span><br>';
               }
           }
           else
           {
               $childcatNameShow = '';
           }
           $childcatName = $childcatNameShow;
         
           $locality = $this->Commanmodel->get_single_query('city',array('city_id' => $allPropertyview->locality));
           
           $area = $this->Commanmodel->get_single_query('city',array('city_id' => $allPropertyview->area));


           $localityShow = '<span><strong>'.$locality->city_name.'</strong></span>';
           $areaShow = '<span>'.$area->city_name.'</span>';


           if($allPropertyview->post_by!='Admin')
           {
              $postBy = 'User';
           }
           else
           {
              $postBy = 'Admin';
           }
           
           
            if($allPropertyview->featured_post=='Yes')
             {
                $featured = 'checked';
             }
             else
             {
                $featured = '';
             }

            if($allPropertyview->new_launch=='Yes')
             {
                $newLaunch = 'checked';
             }
             else
             {
                $newLaunch = '';
             }

            if($allPropertyview->assured_return=='Yes')
             {
                $assuredReturn = 'checked';
             }
             else
             {
                $assuredReturn = '';
             }

            if($allPropertyview->pre_launched=='Yes')
             {
                $preLeased = 'checked';
             }
             else
             {
                $preLeased = '';
             }
           
           if($allPropertyview->property_status=='Fresh')
           {
            $checkedPost = '<br>
            <input type="checkbox" value="'.$allPropertyview->propertyToken.'" class="featured" '.$featured.'> Featured<br>
            <input type="checkbox" value="'.$allPropertyview->propertyToken.'" class="newLaunched" '.$newLaunch.'> New Launched <br>
            <input type="checkbox" value="'.$allPropertyview->propertyToken.'" class="assuredReturn" '.$assuredReturn.'> Assured Return <br>
            <input type="checkbox" value="'.$allPropertyview->propertyToken.'" class="preLeased" '.$preLeased.'> Pre Leased';  
           }
           elseif($allPropertyview->property_status=='Resell')
           {
            $checkedPost = '<br>
            <input type="checkbox" value="'.$allPropertyview->propertyToken.'" class="featured" '.$featured.'> Featured<br>
            <input type="checkbox" value="'.$allPropertyview->propertyToken.'" class="newLaunched" '.$newLaunch.'> New Launched <br>
            <input type="checkbox" value="'.$allPropertyview->propertyToken.'" class="assuredReturn" '.$assuredReturn.'> Assured Return';  
           }
           elseif($allPropertyview->property_status=='Lease')
           {
           $checkedPost = '<br>
            <input type="checkbox" value="'.$allPropertyview->propertyToken.'" class="featured" '.$featured.'> Featured';
           }
           else
           {
           $checkedPost = '';  
           }
           

           $propertyStatus = '<span class="btn btn-'.$allPropertyview->status_color.' btn-xs">'.$allPropertyview->status.'</span>';
           if($allPropertyview->property_status=='Fresh')
           {
            $action = '<a href="'.base_url('admin/edit_property/'.$allPropertyview->propertyToken.'').'" class="btn btn-primary btn-xs">Edit</a>';  
           }
           elseif($allPropertyview->property_status=='Resell' OR $allPropertyview->property_status=='Lease')
           {
            $action = '<a href="'.base_url('admin/edit_resell_property/'.$allPropertyview->propertyToken.'').'" class="btn btn-primary btn-xs">Edit</a>';  
           }
           else
           {
           $action = '';  
           }

            if($allPropertyview->property_status=='Resell')
            {
               $showStatus = 'For Sale'; 
            }
            elseif($allPropertyview->property_status=='Lease')
            {
               $showStatus = 'For Rent';  
            }
            else
            {
               $showStatus = '';  
            }


            
            $no++;
            $row = array();
            $row[] = $ia.'<br><input type="checkbox" class="deleteProperty" value="'.$allPropertyview->propertyToken.'">';
            $row[] = $postBy;
            $row[] = $propertyStatus.' | '.$action;
            $row[] = $allPropertyview->title.$checkedPost;
            $row[] = '<a href="javascript:void(0);" class="btn btn-primary btn-xs">'.$showStatus.'</a></br></br> 
            <a href="javascript:void(0);" class="btn btn-primary btn-xs">'.$allPropertyview->construction_status.'</a><br>';
            $row[] = $categoryName.'</br>'.$childcatName;
            $row[] = $localityShow.'</br>'.$areaShow;
            $data[] = $row;
        $ia++;    
        }
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->Inventorymodel->count_all(),
                        "recordsFiltered" => $this->Inventorymodel->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }
    else
    {
    redirect(base_url('admin/'));
    }
  }
        public function property_feature_action()
        {
        $propertyToken = $this->input->post('propertyToken');
        $featured = $this->input->post('featured');  
        $data=$this->Commanmodel->update_query('property',array('featured_post'=> $featured),array('propertyToken'=> $propertyToken));
        echo json_encode($data);
        }
        public function property_newLaunch_action()
        {
        $propertyToken = $this->input->post('propertyToken');
        $newLaunched = $this->input->post('newLaunched');  
        $data=$this->Commanmodel->update_query('property',array('new_launch'=> $newLaunched),array('propertyToken'=> $propertyToken));
        echo json_encode($data);
        }
        public function property_assuredReturn_action()
        {
        $propertyToken = $this->input->post('propertyToken');
        $assuredReturn = $this->input->post('assuredReturn');  
        $data=$this->Commanmodel->update_query('property',array('assured_return'=> $assuredReturn),array('propertyToken'=> $propertyToken));
        echo json_encode($data);
        }
        public function property_preLeased_action()
        {
        $propertyToken = $this->input->post('propertyToken');
        $preLeased = $this->input->post('preLeased');  
        $data=$this->Commanmodel->update_query('property',array('pre_launched'=> $preLeased),array('propertyToken'=> $propertyToken));
        echo json_encode($data);
        }


        public function delete_property_multiple(){
        if($this->session->userdata('admin_id'))
        {

            if($this->input->post('checkbox_value'))
            {
            $id = $this->input->post('checkbox_value');
            for($count = 0; $count < count($id); $count++)
            {
                
            $propertyValue = $this->Commanmodel->get_single_query('property',array('propertyToken' => $id[$count]));
            $this->Commanmodel->delete_query('property',array('propertyToken' => $id[$count]));
            $this->Commanmodel->delete_query('property_construction',array('propertyToken' => $id[$count]));
            $this->Commanmodel->delete_query('property_detail',array('propertyToken' => $id[$count]));
            $this->Commanmodel->delete_query('property_faq',array('propertyToken' => $id[$count]));
            $this->Commanmodel->delete_query('property_floor',array('propertyToken' => $id[$count]));
            $this->Commanmodel->delete_query('property_floordetail',array('propertyToken' => $id[$count]));
            $this->Commanmodel->delete_query('property_images',array('propertyToken' => $id[$count]));
            $this->Commanmodel->delete_query('property_location',array('propertyToken' => $id[$count]));
            $this->Commanmodel->delete_query('property_paymentdetail',array('propertyToken' => $id[$count]));
            $this->Commanmodel->delete_query('property_planimage',array('propertyToken' => $id[$count]));
            $this->Commanmodel->delete_query('property_planname',array('propertyToken' => $id[$count]));
            $this->Commanmodel->delete_query('property_review',array('author_property_id' => $propertyValue->id));
            $this->Commanmodel->delete_query('property_enquiry',array('property_id' => $propertyValue->id));
           
            }
            }

        }
        else{
            return redirect('admin/');
        }
        }


  
    public function viewproperty($propertyID)
    {
        if($this->session->userdata('admin_id'))
        {
        $property = $this->Commanmodel->get_single_query('property',array('propertyToken' => $propertyID));
        $data = array('property' => $property);    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/single-property',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }
    
  
    
    
    
    public function property_status_process($propertyID)
    {
        $property = $this->Commanmodel->get_single_query('property',array('propertyToken' =>  $propertyID));
        $data = array('property' => $property);
        if($this->session->userdata('admin_id'))
        {
        if($this->input->post('SubmitConversationInventory'))
        {
        $this->form_validation->set_rules('property_status', 'status', 'required',array('required'  =>  'Please select status'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/single-property',$data);
            $this->load->view('admin/footer');
                }
                else
                {
    $post_data = array(  
    'status' => $this->input->post('property_status'),
    'remark' => $this->input->post('contact_client_conversation')
    );
    $updated = $this->Commanmodel->update_query('property',$post_data,array('propertyToken' => $propertyID));  
    if($updated)
    {
    $this->session->set_flashdata('created', 'This property status has been saved.');
    redirect(base_url('admin/property'));
    }
    else
    {
            $this->session->set_flashdata('failed', 'Sorry, This property status has not been saved. Please try again?');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/single-property',$data);
            $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/single-property',$data);
            $this->load->view('admin/footer');
        }



        }
        else
        {
            redirect(base_url('admin/'));
        }
    }   
    
    public function category()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['category'] = $this->Commanmodel->all_multiple_query_order_by('category',array('parent_id' => '0'),'id','DESC');    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/category',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function category_process()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['category'] = $this->Commanmodel->get_multiple_query_order_by('category','id','DESC');  
        if($this->input->post('saveCategory'))
        {
        $this->form_validation->set_rules('category', 'category', 'required|trim|is_unique[category.category]',
          array(
            'required'  =>  'Please enter category name',
            'is_unique'  =>  'This category already exists'
          )
        );
        $this->form_validation->set_rules('category_status', 'Status', 'required',
          array(
            'required'  =>  'Please select status'
          )
        );
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/category',$data);
            $this->load->view('admin/footer');
                }
                else
                {
          if($_FILES['category_icon']['name']!=""){
          $config['upload_path']          = 'assets/upload/category/';
          $config['allowed_types']        = 'gif|jpg|png|jpeg';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('category_icon')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $category_icon=$upload_data['file_name'];
          }
          }
          else{
          $category_icon = '';
          }

          if($_FILES['category_image']['name']!=""){
          $config['upload_path']          = 'assets/upload/category/';
          $config['allowed_types']        = 'gif|jpg|png|jpeg';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('category_image')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $category_image=$upload_data['file_name'];
          }
          }
          else{
          $category_image = '';
          }

          if($_FILES['page_banner']['name']!=""){
          $config['upload_path']          = 'assets/upload/category/';
          $config['allowed_types']        = '*';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('page_banner')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $page_banner=$upload_data['file_name'];
          }
          }
          else{
          $page_banner = '';
          }


     $status = $this->input->post('category_status');
     if($status=='Active')
     {
       $statusColor = 'success';
     }
     elseif($status=='Inactive')
     {
       $statusColor = 'danger';
     }
     else
     {
       $statusColor = '';
     }

    $title = strip_tags($this->input->post('category'));
    $titleURL = strtolower(url_title($title));
    if(isUrlExists('category',$titleURL)){
    $titleURL = $titleURL.'-'.time(); 
    }   
    $token = $this->Commanmodel->generate_category_token();
    $post_data = array(
    'categoryToken' => $token,
    'category_position' => $this->input->post('category_position'),
    'category' => $this->input->post('category'),
    'url_slug' => $titleURL,
    'category_icon' => $category_icon,
    'category_image' => $category_image,
    'page_banner' => $page_banner,
    'page_content' => $this->input->post('page_content'),
    'meta_title' => $this->input->post('meta_title'),
    'meta_keyword' => $this->input->post('meta_keyword'),
    'meta_description' => $this->input->post('meta_description'),
    'status' => $status,
    'status_color' => $statusColor
    ); 
    $inserted = $this->Commanmodel->insert_query('category',$post_data); 
    if($inserted)
    {
    $this->session->set_flashdata('created', 'This category has been saved.');
    redirect(base_url('admin/category'));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This category has not been saved. Please try again?');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/category',$data);
            $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/category',$data);
            $this->load->view('admin/footer');
        }
             

        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function edit_category($categoryID)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['category'] = $this->Commanmodel->get_single_query('category',array('id' => $categoryID));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-category',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


        public function edit_category_process($categoryID)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['category'] = $this->Commanmodel->get_single_query('category',array('id' => $categoryID));  
        if($this->input->post('saveCategory'))
        {
        $this->form_validation->set_rules('category', 'Category', 'required',
          array(
            'required'  =>  'Please enter category name'
          )
        );
        $this->form_validation->set_rules('category_status', 'Status', 'required',
          array(
            'required'  =>  'Please select status'
          )
        );
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-category',$data);
            $this->load->view('admin/footer');
                }
                else
                {
          if($_FILES['category_icon']['name']!=""){
          $config['upload_path']          = 'assets/upload/category/';
          $config['allowed_types']        = 'gif|jpg|png|jpeg';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('category_icon')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $category_icon=$upload_data['file_name'];
          }
          }
          else{
          $category_icon = $this->input->post('category_icon_old');
          }

          if($_FILES['category_image']['name']!=""){
          $config['upload_path']          = 'assets/upload/category/';
          $config['allowed_types']        = 'gif|jpg|png|jpeg';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('category_image')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $category_image=$upload_data['file_name'];
          }
          }
          else{
          $category_image = $this->input->post('category_image_old');
          }

          if($_FILES['page_banner']['name']!=""){
          $config['upload_path']          = 'assets/upload/category/';
          $config['allowed_types']        = '*';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('page_banner')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $page_banner=$upload_data['file_name'];
          }
          }
          else{
          $page_banner = $this->input->post('page_banner_old');
          }
     $status = $this->input->post('category_status');
     if($status=='Active')
     {
       $statusColor = 'success';
     }
     elseif($status=='Inactive')
     {
       $statusColor = 'danger';
     }
     else
     {
       $statusColor = '';
     }

    $title = strip_tags($this->input->post('category'));
    $titleURL = strtolower(url_title($title));
    if(isUrlExistsCategoryUpdate('category',$titleURL,$categoryID)){
    $titleURL = $titleURL.'-'.time(); 
    } 
    $post_data = array(
    'category_position' => $this->input->post('category_position'),    
    'category' => $this->input->post('category'),
    'url_slug' => $titleURL,
    'category_icon' => $category_icon,
    'category_image' => $category_image,
    'page_banner' => $page_banner,
    'page_content' => $this->input->post('page_content'),
    'status' => $status,
    'status_color' => $statusColor,
    'meta_title' => $this->input->post('meta_title'),
    'meta_keyword' => $this->input->post('meta_keyword'),
    'meta_description' => $this->input->post('meta_description'),
    ); 
    $updated = $this->Commanmodel->update_query('category',$post_data,array('id' => $categoryID)); 
    if($updated)
    {
    $this->session->set_flashdata('created', 'This category has been updated.');
    redirect(base_url('admin/category'));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This category has not been saved. Please try again?');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-category',$data);
            $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-category',$data);
            $this->load->view('admin/footer');
        }
             

        }
        else
        {
            redirect(base_url('admin/'));
        }
    }



    public function subcategory()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['subcategory'] = $this->Commanmodel->multiple_query_notvalue('category','id','DESC');    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/subcategory',$data);
        $this->load->view('admin/footer'); 
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function subcategory_process()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['subcategory'] = $this->Commanmodel->multiple_query_notvalue('category','id','DESC');  
        if($this->input->post('saveSubCategory'))
        {
        $this->form_validation->set_rules('category', 'category', 'required',
          array(
            'required'  =>  'Please select category'
          )
        );
        $this->form_validation->set_rules('subcategory', 'subcategory', 'required',
          array(
            'required'  =>  'Please enter child category'
          )
        );
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/subcategory',$data);
            $this->load->view('admin/footer');
                }
                else
                {
    $token = $this->Commanmodel->generate_category_token();                
    $post_data = array(
    'categoryToken' => $token,    
    'parent_id' => $this->input->post('category'),
    'category' => $this->input->post('subcategory')
    ); 
    $inserted = $this->Commanmodel->insert_query('category',$post_data); 
    if($inserted)
    {
    $this->session->set_flashdata('created', 'This Child Category has been saved.');
    redirect(base_url('admin/subcategory'));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This Child Category has not been saved. Please try again?');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/subcategory',$data);
            $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/subcategory',$data);
            $this->load->view('admin/footer');
        }
             

        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function edit_subcategory($categoryID)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['subcategory'] = $this->Commanmodel->get_single_query('category',array('id' => $categoryID));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-subcategory',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


        public function edit_subcategory_process($categoryID)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['subcategory'] = $this->Commanmodel->get_single_query('category',array('id' => $categoryID));  
        if($this->input->post('saveSubCategory'))
        {
        $this->form_validation->set_rules('category', 'category', 'required',
          array(
            'required'  =>  'Please select category'
          )
        );
                $this->form_validation->set_rules('subcategory', 'subcategory', 'required',
          array(
            'required'  =>  'Please enter subcategory name'
          )
        );
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-subcategory',$data);
            $this->load->view('admin/footer');
                }
                else
                {

    $categoryStatus = $this->input->post('status'); 
    if($categoryStatus=='Active')
    {
       $status = 'Active';
       $statusColor = 'success';
    }
    else
    {
       $status = 'Inactive';
       $statusColor = 'danger';
    }
    $post_data = array(
    'parent_id' => $this->input->post('category'),
    'category' => $this->input->post('subcategory'),
    'status' => $status,
    'status_color' => $statusColor
    ); 
    $updated = $this->Commanmodel->update_query('category',$post_data,array('id' => $categoryID)); 
    if($updated)
    {
    $this->session->set_flashdata('created', 'This Child Category has been updated.');
    redirect(base_url('admin/subcategory'));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This Child Category has not been saved. Please try again?');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-subcategory',$data);
            $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-subcategory',$data);
            $this->load->view('admin/footer');
        }
             

        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function property_count()
    {
        if($this->session->userdata('admin_id'))
        {
        $UnderApprovel = $this->Commanmodel->get_single_query_count('property',array('status' => '2'));
        $Pending = $this->Commanmodel->get_single_query_count('property',array('status' => '4'));
        $Approved = $this->Commanmodel->get_single_query_count('property',array('status' => '3'));
        $dataAll = array(
         'UnderApprovel' =>  $UnderApprovel,
         'Pending' =>  $Pending,
         'Approved' =>  $Approved
        );
         echo json_encode($dataAll);
        }
        else
        {
            redirect(base_url('admin/'));
        } 
    }



        public function enquiry(){
        if($this->session->userdata('admin_id'))
        {    
        $data = array('status' => '1','message' => 'New'); 
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/enquiry',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    //  enquiry list page Load After Login Account
  public function list_enquiry_ajax()
  {
        if($this->session->userdata('admin_id'))
        {
        $allEnquiry=$this->Enquirymodel->get_datatables();
        $data = array();
        $no = $_POST['start'];
        $ia=1;
        foreach ($allEnquiry as $allEnquiryview) {


           $propertyDetail = $this->Commanmodel->get_single_query('property',array('id' => $allEnquiryview->property_id));
           if($allEnquiryview->enquiry_status==1)
           {
           $status = '<a href="javascript:void(0);" class="btn btn-primary btn-xs">New</a>';
           }
           elseif($allEnquiryview->enquiry_status==2)
           {
           $status = '<a href="javascript:void(0);" class="btn btn-primary btn-xs">Saled User</a>';
           }
           else
           {
             $status = '';
           }
            $action = '<br><a href="'.base_url('admin/viewenquiry/'.$allEnquiryview->id.'').'" class="btn btn-info btn-xs">View Info</a>
           ';
            $no++;
            $row = array();
            $row[] = $ia;
            $row[] = '<a href="javascript:void(0);" class="btn btn-primary btn-xs">'.$allEnquiryview->date.'</a>';
            $row[] = $allEnquiryview->name.'<br>'.$allEnquiryview->mobile.'<br>'.$allEnquiryview->email;
            $row[] = $propertyDetail->title;
            $row[] = $propertyDetail->full_address;
            $row[] = $action;
            $data[] = $row;
        $ia++;    
        }
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->Enquirymodel->count_all(),
                        "recordsFiltered" => $this->Enquirymodel->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }
    else
    {
    redirect(base_url('admin/'));
    }
  }





  public function viewenquiry($enquiry_id)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['enquiry'] = $this->Commanmodel->get_single_query('property_enquiry',array('id' => $enquiry_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/single-enquiry',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }



   public function contact_enquiry(){
        if($this->session->userdata('admin_id'))
        {    
        //$data = array('status' => '1','message' => 'New'); 
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/contact-enquiry');
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }



 //  enquiry list page Load After Login Account
  public function list_contact_enquiry_ajax()
  {
        if($this->session->userdata('admin_id'))
        {
        $allEnquiry=$this->Contactenquirymodel->get_datatables();
        $data = array();
        $no = $_POST['start'];
        $ia=1;
        foreach ($allEnquiry as $allEnquiryview) {
            $no++;
            
            if($allEnquiryview->loan_type!='')
            {
                $loanValue = "<h6>$allEnquiryview->loan_type</h6><br>";
            }
            else
            {
               $loanValue = ''; 
            }
            
            
            
            
            $row = array();
            $row[] = $ia;
            $row[] = '<a href="javascript:void(0);" class="btn btn-primary btn-xs">'.date('F d, Y',strtotime($allEnquiryview->created_at)).'</a>';
            $row[] = $allEnquiryview->name.'<br>'.$allEnquiryview->mobile;
            $row[] = $allEnquiryview->email;
            $row[] = $loanValue.$allEnquiryview->message;
            $data[] = $row;
        $ia++;    
        }
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->Contactenquirymodel->count_all(),
                        "recordsFiltered" => $this->Contactenquirymodel->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }
    else
    {
    redirect(base_url('admin/'));
    }
  }




      public function review(){
        if($this->session->userdata('admin_id'))
        {     
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/review');
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    //  enquiry list page Load After Login Account
  public function list_review_ajax()
  {
        if($this->session->userdata('admin_id'))
        {
        $allReview=$this->Reviewmodel->get_datatables();
        $data = array();
        $no = $_POST['start'];
        $ia=1;
        foreach ($allReview as $allReviewView) {
           $propertyDetail = $this->Commanmodel->get_single_query('property',array('id' => $allReviewView->author_property_id));

           $rating = $this->Commanmodel->property_rating($allReviewView->author_property_id,$allReviewView->id);


           $status = '<a href="javascript:void(0);" class="btn btn-'.$allReviewView->status_color.' btn-xs">'.$allReviewView->status.'</a>';
            $action = '<br><a href="'.base_url('admin/viewreview/'.$allReviewView->id.'').'" class="btn btn-info btn-xs">View More</a>';
            $no++;
            $row = array();
            $row[] = $ia;
            $row[] = '<div class="rating-box"><div class="detail-list-rating mr-0">'.$rating.'</div></div><a href="javascript:void(0);" class="btn btn-'.$allReviewView->status_color.' btn-xs">'.$allReviewView->author_date.'</a>';
            $row[] = $allReviewView->author_name.'<br>'.$allReviewView->author_email;
            $row[] = $propertyDetail->title;
            $row[] = $propertyDetail->full_address;
            $row[] = $status.$action;
            $data[] = $row;
        $ia++;    
        }
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->Reviewmodel->count_all(),
                        "recordsFiltered" => $this->Reviewmodel->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }
    else
    {
    redirect(base_url('admin/'));
    }
  }


  public function viewreview($enquiry_id)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['enquiry'] = $this->Commanmodel->get_single_query('property_review',array('id' => $enquiry_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/single-review',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


public function property_review_process($enquiry_id)
    {
        $data['enquiry'] = $this->Commanmodel->get_single_query('property_review',array('id' => $enquiry_id));
        if($this->session->userdata('admin_id'))
        {
        if($this->input->post('SubmitReview'))
        {
        $this->form_validation->set_rules('property_status', 'status', 'required',array('required'  =>  'Please select status'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/single-review',$data);
            $this->load->view('admin/footer');
                }
                else
                {
                  $status = $this->input->post('property_status');
    if($status=='Under Approved')
    {
       $status_color = 'danger'; 
    }
    elseif($status=='Approved')
    {
       $status_color = 'success'; 
    }
    else
    {
      $status_color = 'danger';  
    }
    
                    
                    
    $post_data = array(  
    'status' => $this->input->post('property_status'),
    'status_color' => $status_color,
    'remark' => $this->input->post('contact_client_conversation')
    );
    $updated = $this->Commanmodel->update_query('property_review',$post_data,array('id' => $enquiry_id));  
    if($updated)
    {
    $this->session->set_flashdata('created', 'This property review status has been updated.');
    redirect(base_url('admin/review'));
    }
    else
    {
            $this->session->set_flashdata('failed', 'Sorry, This property review status has not been saved. Please try again?');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/single-review',$data);
            $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/single-review',$data);
            $this->load->view('admin/footer');
        }



        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

      

   public function cms_pages()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['cmsView'] = $this->Commanmodel->get_multiple_query_order_by('cms_pages','cms_id','ASC');    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/cms-pages',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function edit_cms($cms_id)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['cmsView'] = $this->Commanmodel->get_single_query('cms_pages',array('cms_id' => $cms_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-cms',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }




 public function edit_cms_process($cms_id)
    {
        if($this->session->userdata('admin_id'))
        {

        if($this->input->post('pageUpdated'))
        {
            if($_FILES['cms_page_image']['name']!=""){
                $config['upload_path']          = 'assets/upload/';
                $config['allowed_types']        = '*';
                $config['max_size']             = 0;
                $config['remove_spaces'] = TRUE;
                $config['encrypt_name'] = TRUE;
                $this->load->library('upload',$config);
                $this->load->initialize('upload', $config);
                if(!$this->upload->do_upload('cms_page_image')){
                    $error = array('error' => $this->upload->display_errors());
                }
                else{
                    $upload_data=$this->upload->data();
                    $cms_page_image=$upload_data['file_name'];
                }
            }
            else{
              $cms_page_image = $this->input->post('cms_page_image_old');
            }
    $post_data = array(
    'cms_page_heading' => $this->input->post('cms_page_heading'),
    'cms_page_small_description' => $this->input->post('cms_page_small_description'),
    'cms_page_description' => $this->input->post('cms_page_description'),
    'image' => $cms_page_image 
    );
                   $inserted = $this->Commanmodel->update_query('cms_pages',$post_data,array('cms_id' => $cms_id)); 
                   if($inserted)
                   {
                    $this->session->set_flashdata('created', 'This Page contant has been updated.');
                    redirect(base_url('admin/cms_pages'));
                   }
                   else
                   {
            $this->session->set_flashdata('failed', 'Sorry, This Page has not been updated. Please try again?');    
        $data['cmsView'] = $this->Commanmodel->get_single_query('cms_pages',array('cms_id' => $cms_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-cms',$data);
        $this->load->view('admin/footer');
                   }


                
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
        $data['cmsView'] = $this->Commanmodel->get_single_query('cms_pages',array('cms_id' => $cms_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-cms',$data);
        $this->load->view('admin/footer');
        }



        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function our_blogs(){
        if($this->session->userdata('admin_id'))
        {
        $data['blogView'] = $this->Commanmodel->get_multiple_query_order_by('blogs','blog_id','DESC');
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/our-blogs',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function create_blog()
    {
        if($this->session->userdata('admin_id'))
        {    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/create-blog');
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

 public function create_blog_process()
    {
        if($this->session->userdata('admin_id'))
        {

        if($this->input->post('CreateNewBlog'))
        {
        $this->form_validation->set_rules('blog_name', 'Blog name', 'required',
            array('required'  =>  'Please enter blog name'));

        $this->form_validation->set_rules('blog_category', 'Blog Category', 'required',
            array('required'  =>  'Please select category'));

        $this->form_validation->set_rules('blog_status', 'Blog status', 'required',
            array('required'  =>  'Please select status'));

        $this->form_validation->set_rules('blog_small_description', 'Blog small description', 'required',
            array('required'  =>  'Please enter small description'));

        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/create-blog');
            $this->load->view('admin/footer');
                }
                else
                {


    $status = $this->input->post('blog_status');
    if($status=='Active')
    {
      $status_color = 'success';
    }
    if($status=='Inactive')
    {
      $status_color = 'danger';
    }
            if($_FILES['blog_image']['name']!=""){
                $config['upload_path']          = 'assets/upload/blog/';
                $config['allowed_types']        = 'gif|jpg|png|jpeg';
                $config['max_size']             = 0;
                $config['remove_spaces'] = TRUE;
                $config['encrypt_name'] = TRUE;
                $this->load->library('upload',$config);
                $this->load->initialize('upload', $config);
                if(!$this->upload->do_upload('blog_image')){
                    $error = array('error' => $this->upload->display_errors());
                }
                else{
                    $upload_data=$this->upload->data();
                    $blog_image=$upload_data['file_name'];
                }
            }
            else{
              $blog_image = '';
            }

    $title = strip_tags($this->input->post('blog_name'));
    $titleURL = strtolower(url_title($title));
    if(isUrlExists('blogs',$titleURL)){
    $titleURL = $titleURL.'-'.time(); 
    }
    $post_data = array(
    'blog_name' => $this->input->post('blog_name'),
    'url_slug' => $titleURL,
    'blog_category' => $this->input->post('blog_category'),
    'blog_status' => $this->input->post('blog_status'),
    'blog_status_color' => $status_color,
    'blog_image' => $blog_image,
    'blog_small_description' => $this->input->post('blog_small_description'),
    'blog_description' => $this->input->post('blog_description'),
    'meta_title' => $this->input->post('meta_title'),
    'meta_keyword' => $this->input->post('meta_keyword'),
    'meta_description' => $this->input->post('meta_description'),
    'date' => date('Y-m-d')
    );
                   $inserted = $this->Commanmodel->insert_query('blogs',$post_data); 
                   if($inserted)
                   {
                    $this->session->set_flashdata('created', 'This blog has been created.');
                    redirect(base_url('admin/create_blog'));
                   }
                   else
                   {
            $this->session->set_flashdata('failed', 'Sorry, This course has not been created. Please try again?');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/create-blog');
            $this->load->view('admin/footer');
                   }


                }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/create-blog');
            $this->load->view('admin/footer');
        }



        }
        else
        {
            redirect(base_url('admin/'));
        }
    }
    
    public function delete_our_blog($blog_id)
    {
     $deleteBlog = $this->Commanmodel->delete_query('blogs',array('blog_id' =>$blog_id));
     if($deleteBlog)
     {
      $this->session->set_flashdata('created', 'This blog is delete.');
      redirect(base_url('admin/our_blogs'));
     }
     else
     {
      $this->session->set_flashdata('failed', 'This is not delete!');
      redirect(base_url('admin/our_blogs')); 
     }
    
    }


    public function edit_our_blog($blog_id)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['blogView'] = $this->Commanmodel->get_single_query('blogs',array('blog_id' => $blog_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-blog',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


 public function edit_blog_process($blog_id)
    {
        if($this->session->userdata('admin_id'))
        {

        if($this->input->post('CreateEditBlog'))
        {
        $this->form_validation->set_rules('blog_name', 'Blog name', 'required',
            array('required'  =>  'Please enter blog name'));

        $this->form_validation->set_rules('blog_category', 'Blog category', 'required',
            array('required'  =>  'Please select category'));

        $this->form_validation->set_rules('blog_status', 'Blog status', 'required',
            array('required'  =>  'Please select status'));

        $this->form_validation->set_rules('blog_small_description', 'Blog small description', 'required',
            array('required'  =>  'Please enter small description'));

        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {   
        $data['blogView'] = $this->Commanmodel->get_single_query('blogs',array('blog_id' => $blog_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-blog',$data);
        $this->load->view('admin/footer');
                }
                else
                {


    $status = $this->input->post('blog_status');
    if($status=='Active')
    {
      $status_color = 'success';
    }
    if($status=='Inactive')
    {
      $status_color = 'danger';
    }
            if($_FILES['blog_image']['name']!=""){
                $config['upload_path']          = 'assets/upload/blog/';
                $config['allowed_types']        = 'gif|jpg|png|jpeg';
                $config['max_size']             = 0;
                $this->load->library('upload',$config);
                if(!$this->upload->do_upload('blog_image')){
                    $error = array('error' => $this->upload->display_errors());
                }
                else{
                    $upload_data=$this->upload->data();
                    $blog_image=$upload_data['file_name'];
                }
            }
            else{
                  $blog_image= $this->input->post('blog_image_old');
            }


    $title = strip_tags($this->input->post('blog_name'));
    $titleURL = strtolower(url_title($title));
    if(isUrlExistsBlogs('blogs',$titleURL,$blog_id)){
    $titleURL = $titleURL.'-'.time(); 
    }
    $post_data = array(
    'blog_name' => $this->input->post('blog_name'),
    'url_slug' => $titleURL,
    'blog_status' => $this->input->post('blog_status'),
    'blog_status_color' => $status_color,
    'blog_image' => $blog_image,
    'blog_small_description' => $this->input->post('blog_small_description'),
    'blog_description' => $this->input->post('blog_description'),
    'meta_title' => $this->input->post('meta_title'),
    'meta_keyword' => $this->input->post('meta_keyword'),
    'meta_description' => $this->input->post('meta_description')
    );
                   $inserted = $this->Commanmodel->update_query('blogs',$post_data,array('blog_id' => $blog_id)); 
                   if($inserted)
                   {
                    $this->session->set_flashdata('created', 'This blog has been updated.');
                    redirect(base_url('admin/our_blogs'));
                   }
                   else
                   {
            $this->session->set_flashdata('failed', 'Sorry, This blog has not been updated. Please try again?');    
        $data['blogView'] = $this->Commanmodel->get_single_query('blogs',array('blog_id' => $blog_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-blog',$data);
        $this->load->view('admin/footer');
                   }


                }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
        $data['blogView'] = $this->Commanmodel->get_single_query('blogs',array('blog_id' => $blog_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-blog',$data);
        $this->load->view('admin/footer');
        }



        }
        else
        {
            redirect(base_url('admin/'));
        }
    }



    public function facilities()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['facilities'] = $this->Commanmodel->get_multiple_query_order_by('amenities','id','DESC');    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/facilities',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function facilities_process()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['facilities'] = $this->Commanmodel->get_multiple_query_order_by('amenities','id','DESC');  
        if($this->input->post('saveFacility'))
        {
        $this->form_validation->set_rules('category', 'Facility', 'required|trim|is_unique[amenities.name]',
          array(
            'required'  =>  'Please enter facility',
            'is_unique'  =>  'This facility already exists'
          )
        );
        $this->form_validation->set_rules('category_status', 'Status', 'required',
          array(
            'required'  =>  'Please select status'
          )
        );
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/facilities',$data);
            $this->load->view('admin/footer');
                }
                else
                {
          if($_FILES['category_icon']['name']!=""){
          $config['upload_path']          = 'assets/upload/category/';
          $config['allowed_types']        = 'gif|jpg|png|jpeg';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('category_icon')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $category_icon=$upload_data['file_name'];
          }
          }
          else{
          $category_icon = 'empty-icon.jpg';
          }

        
     $status = $this->input->post('category_status');
     if($status=='Active')
     {
       $statusColor = 'success';
     }
     elseif($status=='Inactive')
     {
       $statusColor = 'danger';
     }
     else
     {
       $statusColor = '';
     }
    $token_id = $this->Commanmodel->generate_token_user();        
    $post_data = array(
    'name' => $this->input->post('category'),
    'icon' => $category_icon,
    'status' => $status,
    'status_color' => $statusColor,
    'tokenAmenities' => $token_id
    ); 
    $inserted = $this->Commanmodel->insert_query('amenities',$post_data); 
    if($inserted)
    {
    $this->session->set_flashdata('created', 'This Facility has been saved.');
    redirect(base_url('admin/facilities'));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This Facility has not been saved. Please try again?');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/facilities',$data);
            $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/facilities',$data);
            $this->load->view('admin/footer');
        }
             

        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function edit_facilities($categoryID)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['facilities'] = $this->Commanmodel->get_single_query('amenities',array('id' =>$categoryID));
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-facility',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


        public function edit_facilities_process($categoryID)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['facilities'] = $this->Commanmodel->get_single_query('amenities',array('id' => $categoryID));
        if($this->input->post('editFacility'))
        {
        $this->form_validation->set_rules('category', 'Facility', 'required',
          array(
            'required'  =>  'Please enter facility name'
          )
        );
        $this->form_validation->set_rules('category_status', 'Status', 'required',
          array(
            'required'  =>  'Please select status'
          )
        );
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-facilities',$data);
            $this->load->view('admin/footer');
                }
                else
                {
          if($_FILES['category_icon']['name']!=""){
          $config['upload_path']          = 'assets/upload/category/';
          $config['allowed_types']        = 'gif|jpg|png|jpeg';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('category_icon')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $category_icon=$upload_data['file_name'];
          }
          }
          else{
          $category_icon = $this->input->post('category_icon_old');
          }

          
     $status = $this->input->post('category_status');
     if($status=='Active')
     {
       $statusColor = 'success';
     }
     elseif($status=='Inactive')
     {
       $statusColor = 'danger';
     }
     else
     {
       $statusColor = '';
     }
    $post_data = array(
    'name' => $this->input->post('category'),
    'icon' => $category_icon,
    'status' => $status,
    'status_color' => $statusColor
    ); 
    $updated = $this->Commanmodel->update_query('amenities',$post_data,array('id' => $categoryID)); 
    if($updated)
    {
    $this->session->set_flashdata('created', 'This Facility has been updated.');
    redirect(base_url('admin/facilities'));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This Facility has not been saved. Please try again?');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-facilities',$data);
            $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-facilities',$data);
            $this->load->view('admin/footer');
        }
             

        }
        else
        {
            redirect(base_url('admin/'));
        }
    }



    public function cities()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['cities'] = $this->Commanmodel->all_multiple_query_order_by('city',array('parent_id' => 0),'city_id','DESC');    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/cities',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function cities_process()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['cities'] = $this->Commanmodel->all_multiple_query_order_by('city',array('parent_id' => 0),'city_id','DESC');  
        if($this->input->post('saveCity'))
        {
        $this->form_validation->set_rules('category', 'City', 'required|trim|is_unique[city.city_name]',
          array(
            'required'  =>  'Please enter city',
            'is_unique'  =>  'This category already exists'
          )
        );
        $this->form_validation->set_rules('category_status', 'Status', 'required',
          array(
            'required'  =>  'Please select status'
          )
        );
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/cities',$data);
            $this->load->view('admin/footer');
                }
                else
                {
          
          if($_FILES['category_image']['name']!=""){
          $config['upload_path']          = 'assets/upload/category/';
          $config['allowed_types']        = 'gif|jpg|png|jpeg';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('category_image')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $category_image=$upload_data['file_name'];
          }
          }
          else{
          $category_image = '';
          }

          if($_FILES['page_banner']['name']!=""){
          $config['upload_path']          = 'assets/upload/category/';
          $config['allowed_types']        = 'gif|jpg|png|jpeg';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('page_banner')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $page_banner=$upload_data['file_name'];
          }
          }
          else{
          $page_banner = '';
          }


     $status = $this->input->post('category_status');
     if($status=='Active')
     {
       $statusColor = 'success';
     }
     elseif($status=='Inactive')
     {
       $statusColor = 'danger';
     }
     else
     {
       $statusColor = '';
     }

    $title = strip_tags($this->input->post('category'));
    $titleURL = strtolower(url_title($title));
    if(isUrlExists('city',$titleURL)){
    $titleURL = $titleURL.'-'.time(); 
    }             
    $post_data = array(
    'city_name ' => $this->input->post('category'),
    'url_slug' => $titleURL,
    'city_image' => $category_image,
    'page_banner' => $page_banner,
    'page_content' => $this->input->post('page_content'),
    'meta_title' => $this->input->post('meta_title'),
    'meta_keyword' => $this->input->post('meta_keyword'),
    'meta_description' => $this->input->post('meta_description'),
    'status' => $status,
    'status_color' => $statusColor
    ); 
    $inserted = $this->Commanmodel->insert_query('city',$post_data); 
    if($inserted)
    {
    $this->session->set_flashdata('created', 'This City has been saved.');
    redirect(base_url('admin/cities'));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This City has not been saved. Please try again?');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/cities',$data);
            $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/cities',$data);
            $this->load->view('admin/footer');
        }
             

        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function edit_cities($categoryID)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['cities'] = $this->Commanmodel->get_single_query('city',array('city_id' => $categoryID));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-cities',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function edit_cities_process($categoryID)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['cities'] = $this->Commanmodel->get_single_query('city',array('city_id' => $categoryID));  
        if($this->input->post('EditCity'))
        {
        $this->form_validation->set_rules('category', 'City', 'required',
          array(
            'required'  =>  'Please enter city'
          )
        );
        $this->form_validation->set_rules('category_status', 'Status', 'required',
          array(
            'required'  =>  'Please select status'
          )
        );
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-cities',$data);
            $this->load->view('admin/footer');
                }
                else
                {
          

          if($_FILES['category_image']['name']!=""){
          $config['upload_path']          = 'assets/upload/category/';
          $config['allowed_types']        = 'gif|jpg|png|jpeg';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('category_image')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $category_image=$upload_data['file_name'];
          }
          }
          else{
          $category_image = $this->input->post('category_image_old');
          }

          if($_FILES['page_banner']['name']!=""){
          $config['upload_path']          = 'assets/upload/category/';
          $config['allowed_types']        = '*';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('page_banner')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $page_banner=$upload_data['file_name'];
          }
          }
          else{
          $page_banner = $this->input->post('page_banner_old');
          }

     $status = $this->input->post('category_status');
     if($status=='Active')
     {
       $statusColor = 'success';
     }
     elseif($status=='Inactive')
     {
       $statusColor = 'danger';
     }
     else
     {
       $statusColor = '';
     }

    $title = strip_tags($this->input->post('category'));
    $titleURL = strtolower(url_title($title));
    if(isUrlExistsCity('city',$titleURL,$categoryID)){
    $titleURL = $titleURL.'-'.time(); 
    } 
    $post_data = array(
    'city_name' => $this->input->post('category'),
    'url_slug' => $titleURL,
    'city_image' => $category_image,
    'page_banner' => $page_banner,
    'page_content' => $this->input->post('page_content'),
    'status' => $status,
    'status_color' => $statusColor,
    'meta_title' => $this->input->post('meta_title'),
    'meta_keyword' => $this->input->post('meta_keyword'),
    'meta_description' => $this->input->post('meta_description'),
    ); 
    $updated = $this->Commanmodel->update_query('city',$post_data,array('city_id ' => $categoryID)); 
    if($updated)
    {
    $this->session->set_flashdata('created', 'This City has been updated.');
    redirect(base_url('admin/cities'));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This City has not been saved. Please try again?');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-cities',$data);
            $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-cities',$data);
            $this->load->view('admin/footer');
        }
             

        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function sectors()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['sectors'] = $this->Commanmodel->multiple_query_notvalue('city','city_id','DESC');    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/sectors',$data);
        $this->load->view('admin/footer'); 
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function create_sectors()
    {
        if($this->session->userdata('admin_id'))
        {
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/create-sectors');
        $this->load->view('admin/footer'); 
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function sectors_process()
    {
        if($this->session->userdata('admin_id'))
        {
        if($this->input->post('saveSectors'))
        {
        $this->form_validation->set_rules('category', 'City', 'required',
          array(
            'required'  =>  'Please select city'
          )
        );
        $this->form_validation->set_rules('subcategory', 'Sector/Area', 'required',
          array(
            'required'  =>  'Please enter sector/area'
          )
        );
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/create-sectors');
            $this->load->view('admin/footer');
                }
                else
                {

          if($_FILES['category_image']['name']!=""){
          $config['upload_path']          = 'assets/upload/category/';
          $config['allowed_types']        = '*';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('category_image')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $category_image=$upload_data['file_name'];
          }
          }
          else{
          $category_image = '';
          }
    $tokenValue = $this->Commanmodel->generate_category_token();
    
          $locality_row = !empty($this->input->post('locality'))?count($this->input->post('locality')):0;
          if($locality_row > 0)
          {
             $postLocality = implode(',',$this->input->post('locality')); 
          }
          else
          {
              $postLocality = '';
          }
    $post_data = array(
    'areaToken' => $tokenValue,    
    'parent_id' => $this->input->post('category'),
    'city_name' => $this->input->post('subcategory'),
    'city_image' => $category_image,
    'page_content' => $this->input->post('page_content'),
    'office_price' => $this->input->post('office_price'),
    'shop_price' => $this->input->post('shop_price'),
    'office_rent' => $this->input->post('office_rent'),
    'shop_rent' => $this->input->post('shop_rent'),
    'locality' => $postLocality,
    'meta_title' => $this->input->post('meta_title'),
    'meta_keyword' => $this->input->post('meta_keyword'),
    'meta_description' => $this->input->post('meta_description') 
    ); 
    $inserted = $this->Commanmodel->insert_query('city',$post_data); 
    if($inserted)
    {
        
                  //  Sector/Area Image 
          $plan_image_rows = !empty($_FILES['gallery']['name'])?count($_FILES['gallery']['name']):0;
          if($plan_image_rows > 0)
          {
          for($i=0 ; $i<$plan_image_rows;$i++)
          {
                    $_FILES['file']['name']     = $_FILES['gallery']['name'][$i]; 
                    $_FILES['file']['type']     = $_FILES['gallery']['type'][$i]; 
                    $_FILES['file']['tmp_name'] = $_FILES['gallery']['tmp_name'][$i]; 
                    $_FILES['file']['error']     = $_FILES['gallery']['error'][$i]; 
                    $_FILES['file']['size']     = $_FILES['gallery']['size'][$i]; 

                    // File upload configuration 
                    $uploadPath = 'assets/upload/category/'; 
                    $config['upload_path'] = $uploadPath; 
                    $config['allowed_types'] = '*'; 
                    $config['max_size'] = 0;
                    $config['remove_spaces'] = TRUE;
                    $config['encrypt_name'] = TRUE;
                    // Load and initialize upload library 
                    $this->load->library('upload', $config); 
                    $this->upload->initialize($config); 
                    // Upload file to server 
                    if($this->upload->do_upload('file')){ 
                        // Uploaded file data 
                        $fileData = $this->upload->data(); 
                        $plan_image = $fileData['file_name']; 
                    }
                    if(!empty($plan_image))
                    {
                      $post_data = array(
                      'image_alt' => $this->input->post('galleryalt')[$i],
                      'image' => $plan_image,    
                      'areaToken' => $tokenValue
                      );
                      $inserted = $this->Commanmodel->insert_query('area_image',$post_data);
                    }
          }
          }
          //  Area Image Stop

        
        
        
     // Area Infrasctucture
          $detail_heading_row = !empty($this->input->post('infrascructure'))?count($this->input->post('infrascructure')):0;
          if($detail_heading_row > 0)
          {
          for($i=0 ; $i<$detail_heading_row;$i++)
          {
          $post_data = array(
          'infrascructure' => $this->input->post('infrascructure')[$i],
          'areaToken' => $tokenValue
          );
          $inserted = $this->Commanmodel->insert_query('area_infrascructure',$post_data);
          }
          }
          // Area Infrasctucture Stop
          
         // Area Distance
          $distancefrom_row = !empty($this->input->post('distancefrom'))?count($this->input->post('distancefrom')):0;
          if($distancefrom_row > 0)
          {
          for($i=0 ; $i<$distancefrom_row;$i++)
          {
          $post_data = array(
          'distancefrom' => $this->input->post('distancefrom')[$i],
          'distancekm' => $this->input->post('distancekm')[$i],
          'areaToken' => $tokenValue
          );
          $inserted = $this->Commanmodel->insert_query('area_distancefrom',$post_data);
          }
          }
          // Area Distance Stop          
          
          // Area Faq
          $question_row = !empty($this->input->post('question'))?count($this->input->post('question')):0;
          if($question_row > 0)
          {
          for($i=0 ; $i<$question_row;$i++)
          {
          $post_data = array(
          'question' => $this->input->post('question')[$i],
          'answer' => $this->input->post('answer')[$i],
          'areaToken' => $tokenValue
          );
          $inserted = $this->Commanmodel->insert_query('area_faq',$post_data);
          }
          }
          // Area Faq Stop
          
          
          

    $this->session->set_flashdata('created', 'This Sector/Area has been saved.');
    redirect(base_url('admin/sectors'));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This Sector/Area has not been saved. Please try again?');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/create-sectors');
            $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/create-sectors');
            $this->load->view('admin/footer');
        }
             

        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function edit_sectors($categoryID)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['sectors'] = $this->Commanmodel->get_single_query('city',array('city_id' => $categoryID));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-sectors',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


        public function edit_sectors_process($categoryID)
    {
        if($this->session->userdata('admin_id'))
        {
        $sectors = $this->Commanmodel->get_single_query('city',array('city_id' => $categoryID));
        $data = array('sectors' => $sectors);
        if($this->input->post('EditSectors'))
        {
        $this->form_validation->set_rules('category', 'City', 'required',
          array(
            'required'  =>  'Please select city'
          )
        );
                $this->form_validation->set_rules('subcategory', 'Sector/Locality', 'required',
          array(
            'required'  =>  'Please enter sector/locality'
          )
        );
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-sectors',$data);
            $this->load->view('admin/footer');
                }
                else
                {

    $categoryStatus = $this->input->post('status'); 
    if($categoryStatus=='Active')
    {
       $status = 'Active';
       $statusColor = 'success';
    }
    else
    {
       $status = 'Inactive';
       $statusColor = 'danger';
    }

          if($_FILES['category_image']['name']!=""){
          $config['upload_path']          = 'assets/upload/category/';
          $config['allowed_types']        = '*';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('category_image')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $category_image=$upload_data['file_name'];
          }
          }
          else{
          $category_image = $this->input->post('category_image_old');
          }
          
          $locality_row = !empty($this->input->post('locality'))?count($this->input->post('locality')):0;
          if($locality_row > 0)
          {
             $postLocality = implode(',',$this->input->post('locality')); 
          }
          else
          {
              $postLocality = '';
          }
    $post_data = array(
    'parent_id' => $this->input->post('category'),
    'city_name' => $this->input->post('subcategory'),
    'city_image' => $category_image,
    'page_content' => $this->input->post('page_content'),
    'office_price' => $this->input->post('office_price'),
    'shop_price' => $this->input->post('shop_price'),
    'office_rent' => $this->input->post('office_rent'),
    'shop_rent' => $this->input->post('shop_rent'),
    'locality' => $postLocality,
    'meta_title' => $this->input->post('meta_title'),
    'meta_keyword' => $this->input->post('meta_keyword'),
    'meta_description' => $this->input->post('meta_description'),
    'status' => $status,
    'status_color' => $statusColor
    ); 
    $updated = $this->Commanmodel->update_query('city',$post_data,array('city_id' => $categoryID)); 
    if($updated)
    {
          //  Sector/Area Image 
          $plan_image_rows = !empty($_FILES['gallery']['name'])?count($_FILES['gallery']['name']):0;
          if($plan_image_rows > 0)
          {
          for($i=0 ; $i<$plan_image_rows;$i++)
          {
                    $_FILES['file']['name']     = $_FILES['gallery']['name'][$i]; 
                    $_FILES['file']['type']     = $_FILES['gallery']['type'][$i]; 
                    $_FILES['file']['tmp_name'] = $_FILES['gallery']['tmp_name'][$i]; 
                    $_FILES['file']['error']     = $_FILES['gallery']['error'][$i]; 
                    $_FILES['file']['size']     = $_FILES['gallery']['size'][$i]; 

                    // File upload configuration 
                    $uploadPath = 'assets/upload/category/'; 
                    $config['upload_path'] = $uploadPath; 
                    $config['allowed_types'] = '*'; 
                    $config['max_size'] = 0;
                    $config['remove_spaces'] = TRUE;
                    $config['encrypt_name'] = TRUE;
                    // Load and initialize upload library 
                    $this->load->library('upload', $config); 
                    $this->upload->initialize($config); 
                    // Upload file to server 
                    if($this->upload->do_upload('file')){ 
                        // Uploaded file data 
                        $fileData = $this->upload->data(); 
                        $plan_image = $fileData['file_name']; 
                    }
                    if(!empty($plan_image))
                    {
                      $post_data = array(
                      'image_alt' => $this->input->post('galleryalt')[$i],
                      'image' => $plan_image,    
                      'areaToken' => $sectors->areaToken
                      );
                      $inserted = $this->Commanmodel->insert_query('area_image',$post_data);
                    }
          }
          }
          //  Area Image Stop

                  
          // Area Infrasctucture
          $detail_heading_row = !empty($this->input->post('infrascructure'))?count($this->input->post('infrascructure')):0;
          if($detail_heading_row > 0)
          {
          for($i=0 ; $i<$detail_heading_row;$i++)
          {
          $post_data = array(
          'infrascructure' => $this->input->post('infrascructure')[$i],
          'areaToken' => $sectors->areaToken
          );
          $inserted = $this->Commanmodel->insert_query('area_infrascructure',$post_data);
          }
          }
          // Area Infrasctucture Stop
          
         // Area Distance
          $distancefrom_row = !empty($this->input->post('distancefrom'))?count($this->input->post('distancefrom')):0;
          if($distancefrom_row > 0)
          {
          for($i=0 ; $i<$distancefrom_row;$i++)
          {
          $post_data = array(
          'distancefrom' => $this->input->post('distancefrom')[$i],
          'distancekm' => $this->input->post('distancekm')[$i],
          'areaToken' => $sectors->areaToken
          );
          $inserted = $this->Commanmodel->insert_query('area_distancefrom',$post_data);
          }
          }
          // Area Distance Stop          
          
          // Area Faq
          $question_row = !empty($this->input->post('question'))?count($this->input->post('question')):0;
          if($question_row > 0)
          {
          for($i=0 ; $i<$question_row;$i++)
          {
          $post_data = array(
          'question' => $this->input->post('question')[$i],
          'answer' => $this->input->post('answer')[$i],
          'areaToken' => $sectors->areaToken
          );
          $inserted = $this->Commanmodel->insert_query('area_faq',$post_data);
          }
          }
          // Area Faq Stop
          
          
        
    $this->session->set_flashdata('created', 'This Sector/Area has been updated.');
    redirect(base_url('admin/sectors'));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This Sector/Locality has not been saved. Please try again?');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-sectors',$data);
            $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-sectors',$data);
            $this->load->view('admin/footer');
        }
             

        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


        public function developers(){
        if($this->session->userdata('admin_id'))
        {     
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/developers');
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
        }


    public function create_developer()
    {
        if($this->session->userdata('admin_id'))
        {    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/create-developer');
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function create_developer_process()
    {
        if($this->session->userdata('admin_id'))
        {
        if($this->input->post('CreateDeveloper'))
        {
        $this->form_validation->set_rules('title', 'Title', 'required|is_unique[developer.title]',array(
          'required'  =>  'Please enter title',
          'is_unique'  =>  'This Title id is already exists!'
        ));
        $this->form_validation->set_rules('url', 'URL', 'required|is_unique[developer.url_slug]',array(
          'required'  =>  'Please enter url',
          'is_unique'  =>  'This URL is already exists!'
        ));
        $this->form_validation->set_rules('status', 'Status', 'required',array('required'  =>  'Please select status'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/create-developer');
            $this->load->view('admin/footer');
                }
                else
                {
    $status = $this->input->post('status');
    if($status=='Active')
    {
      $status_color = 'success';
    }
    if($status=='Inactive')
    {
      $status_color = 'danger';
    }
          if($_FILES['logo']['name']!=""){
          $config['upload_path']          = 'assets/upload/category/';
          $config['allowed_types']        = 'gif|jpg|png|jpeg';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('logo')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $logo=$upload_data['file_name'];
          }
          }
          else{
          $logo = '';
          }
    $post_data = array(
    'title' => $this->input->post('title'),
    'url_slug' => $this->input->post('url'),    
    'ongoing_project' => $this->input->post('ongoing_project'),
    'active_project' => $this->input->post('active_project'),
    'year_experience' => $this->input->post('year_experience'),
    'logo' => $logo,
    'status' => $this->input->post('status'),
    'status_color' => $status_color,
    'description' => $this->input->post('description'),
    'meta_title' => $this->input->post('meta_title'),
    'meta_keyword' => $this->input->post('meta_keyword'),
    'meta_description' => $this->input->post('meta_description')
    );
    $inserted = $this->Commanmodel->insert_query('developer',$post_data); 
    if($inserted)
    {
        $this->session->set_flashdata('created', 'This Developer has been created.');
        redirect(base_url('admin/create_developer'));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This Developer has not been created. Please try again?');    
    $this->load->view('admin/head');
    $this->load->view('admin/sidebar');
    $this->load->view('admin/create-developer');
    $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/create-developer');
            $this->load->view('admin/footer');
        }



        }
        else
        {
            redirect(base_url('admin/'));
        }
    }
    
    public function edit_developer($developer_id)
    {
        $singleUser = $this->Commanmodel->get_single_query('developer',array('id' =>  $developer_id));
        $data = array('developer' => $singleUser);  
        if($this->session->userdata('admin_id'))
        {    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-developer',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function edit_developer_process($developer_id)
    {
        $singleUser = $this->Commanmodel->get_single_query('developer',array('id' =>  $developer_id));
        $data = array('developer' => $singleUser);
        if($this->session->userdata('admin_id'))
        {
        if($this->input->post('EditDeveloper'))
        {
        $this->form_validation->set_rules('title', 'Title', 'required',array(
          'required'  =>  'Please enter title'
        ));
        $this->form_validation->set_rules('url', 'URL', 'required',array(
          'required'  =>  'Please enter url'
        ));
        $this->form_validation->set_rules('status', 'Status', 'required',array('required'  =>  'Please select status'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-developer',$data);
            $this->load->view('admin/footer');
                }
                else
                {
    $status = $this->input->post('status');
    if($status=='Active')
    {
      $status_color = 'success';
    }
    if($status=='Inactive')
    {
      $status_color = 'danger';
    }
          if($_FILES['logo']['name']!=""){
          $config['upload_path']          = 'assets/upload/category/';
          $config['allowed_types']        = 'gif|jpg|png|jpeg';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('logo')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $logo=$upload_data['file_name'];
          }
          }
          else{
          $logo = $this->input->post('logo_old');
          }
    $post_data = array(
    'title' => $this->input->post('title'),
    'url_slug' => $this->input->post('url'),    
    'ongoing_project' => $this->input->post('ongoing_project'),
    'active_project' => $this->input->post('active_project'),
    'year_experience' => $this->input->post('year_experience'),
    'logo' => $logo,
    'status' => $this->input->post('status'),
    'status_color' => $status_color,
    'description' => $this->input->post('description'),
    'meta_title' => $this->input->post('meta_title'),
    'meta_keyword' => $this->input->post('meta_keyword'),
    'meta_description' => $this->input->post('meta_description')
    );
    $inserted = $this->Commanmodel->update_query('developer',$post_data,array('id' => $developer_id)); 
    if($inserted)
    {
    $this->session->set_flashdata('created', 'This Developer has been updated.');
    redirect(base_url('admin/developers'));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This Developer has not been updated. Please try again?');    
    $this->load->view('admin/head');
    $this->load->view('admin/sidebar');
    $this->load->view('admin/edit-developer',$data);
    $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-developer',$data);
            $this->load->view('admin/footer');
        }
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }   

    function get_seo_title_resell_lease()
    {
    $table = $this->input->post('table');  
    $title1 = strip_tags($this->input->post('title'));
    $title2 = strip_tags($this->input->post('property_type'));
    $title3 = strip_tags($this->input->post('projectname'));
    $title4 = strip_tags($this->input->post('area'));
    
    $title = $title1.' for '.$title2.' in '.$title3.' '.$title4;
    $titleURL = strtolower(url_title($title));
    if(isUrlExists($table,$titleURL)){
    $titleURL = $titleURL.'-'.time(); 
    }
      echo $titleURL; 
    }


    function get_seo_title()
    {
    $table = $this->input->post('table');  
    $title = strip_tags($this->input->post('title'));
    $titleURL = strtolower(url_title($title));
    if(isUrlExists($table,$titleURL)){
    $titleURL = $titleURL.'-'.time(); 
    }
      echo $titleURL; 
    }


    function remove_floor()
    {
    $propertyToken = $this->input->post('propertyToken');
    $floor_id = $this->input->post('floor_id');  
    $returnData = $this->Commanmodel->delete_query('property_floor',array('propertyToken' => $propertyToken, 'id' => $floor_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }


 function remove_gallery()
    {
    $propertyToken = $this->input->post('propertyToken');
    $gallery_id = $this->input->post('gallery_id');  
    $returnData = $this->Commanmodel->delete_query('property_images',array('propertyToken' => $propertyToken, 'id' => $gallery_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }

function remove_payment()
    {
    $propertyToken = $this->input->post('propertyToken');
    $payment_id = $this->input->post('payment_id');  
    $returnData = $this->Commanmodel->delete_query('property_planname',array('propertyToken' => $propertyToken, 'id' => $payment_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }
    
    function remove_location()
    {
    $propertyToken = $this->input->post('propertyToken');
    $location_id = $this->input->post('location_id');  
    $returnData = $this->Commanmodel->delete_query('property_location',array('propertyToken' => $propertyToken, 'id' => $location_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }

    function remove_area_image()
    {
    $areatoken = $this->input->post('areatoken');
    $image_id = $this->input->post('image_id');  
    $returnData = $this->Commanmodel->delete_query('area_image',array('areaToken' => $areatoken, 'id' => $image_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }

    function remove_area_infrascructure()
    {
    $areatoken = $this->input->post('areatoken');
    $infrascructure_id = $this->input->post('infrascructure_id');  
    $returnData = $this->Commanmodel->delete_query('area_infrascructure',array('areaToken' => $areatoken, 'id' => $infrascructure_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }
    
    function remove_area_distance()
    {
    $areatoken = $this->input->post('areatoken');
    $distance_id = $this->input->post('distance_id');  
    $returnData = $this->Commanmodel->delete_query('area_distancefrom',array('areaToken' => $areatoken, 'id' => $distance_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }
    
    function remove_area_locality()
    {
    $areatoken = $this->input->post('areatoken');
    $locality_id = $this->input->post('locality_id');  
    $returnData = $this->Commanmodel->delete_query('area_locality',array('areaToken' => $areatoken, 'id' => $locality_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }

    function remove_area_faq()
    {
    $areatoken = $this->input->post('areatoken');
    $faq_id = $this->input->post('faq_id');  
    $returnData = $this->Commanmodel->delete_query('area_faq',array('areaToken' => $areatoken, 'id' => $faq_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }
    
    
    

    function remove_payment_detail()
    {
    $propertyToken = $this->input->post('propertyToken');
    $payment_id = $this->input->post('payment_id'); 
    $paymentdetail_id = $this->input->post('paymentdetail_id');  
    $returnData = $this->Commanmodel->delete_query('property_paymentdetail',array('propertyToken' => $propertyToken, 'payment_id' => $payment_id, 'id' => $paymentdetail_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }


    function remove_floor_detail()
    {
    $propertyToken = $this->input->post('propertyToken');
    $floor_id = $this->input->post('floor_id'); 
    $floordetail_id = $this->input->post('floordetail_id');  
    $returnData = $this->Commanmodel->delete_query('property_floordetail',array('propertyToken' => $propertyToken, 'floor_id' => $floor_id, 'id' => $floordetail_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }



  //  enquiry list page Load After Login Account
  public function list_developer_ajax()
  {
        if($this->session->userdata('admin_id'))
        {
        $alldeveloper=$this->Developermodel->get_datatables();
        $data = array();
        $no = $_POST['start'];
        $ia=1;
        foreach ($alldeveloper as $alldeveloperView) {
            $status = '<a href="javascript:void(0);" class="btn btn-'.$alldeveloperView->status_color.' btn-xs">'.$alldeveloperView->status.'</a>';
            $action = '<br><a href="'.base_url('admin/edit_developer/'.$alldeveloperView->id.'').'" class="btn btn-info btn-xs">Edit</a>';
            $no++;
            $row = array();
            $row[] = $ia;
            $row[] = $alldeveloperView->title;
            $row[] = '<img src="'.base_url('assets/upload/category/'.$alldeveloperView->logo.'').'" style="height:100px; width:80px;">';
            $row[] = $status.$action;
            $data[] = $row;
        $ia++;    
        }
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->Developermodel->count_all(),
                        "recordsFiltered" => $this->Developermodel->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }
    else
    {
    redirect(base_url('admin/'));
    }
  }


    public function get_category()
    {
        if($this->session->userdata('admin_id'))
        {
         if(!empty($this->input->post('category_id')))
         {
         $categoryToken = join("','", $this->input->post('category_id'));
         $getCategory = $this->Commanmodel->all_multiple_childcategory(" category 
         WHERE parent_id IN ('".$categoryToken."') AND status='Active' order by id DESC");
         ?>
        <label for="exampleInputEmail1">Child Category*</label>
        <select class="form-control groups_eg_g" name="childcategory[]" placeholder="Choose" onchange="console.log($(this).children(':selected').length)" multiple="multiple">
        <?php
        foreach ($getCategory as $getCategory) 
         {
           ?>
            <option value="<?php echo $getCategory->categoryToken; ?>"><?php echo $getCategory->category; ?></option>
           <?php
         }
         ?>
        </select>
        <script type="text/javascript">
        $(document).ready(function () {
        window.asd = $('.SlectBox').SumoSelect({ csvDispCount: 6 });
        window.test = $('.testsel').SumoSelect({okCancelInMulti:true });
        window.testSelAll = $('.testSelAll').SumoSelect({okCancelInMulti:true, selectAll:true });
        window.testSelAlld = $('.SlectBox-grp').SumoSelect({okCancelInMulti:true, selectAll:true });
        window.testSelAll2 = $('.testSelAll2').SumoSelect({selectAll:true });
        window.Search = $('.search-box').SumoSelect({ csvDispCount: 3, search: true, searchText:'Enter here.' });
        window.searchSelAll = $('.search-box-sel-all').SumoSelect({ csvDispCount: 3, selectAll:true, search: true, searchText:'Enter here.', okCancelInMulti:true });
        window.searchSelAll = $('.search-box-open-up').SumoSelect({ csvDispCount: 3, selectAll:true, search: true, searchText:'Enter here.', up:true });
        window.groups_eg_g = $('.groups_eg_g').SumoSelect({selectAll:true, search:true });
        });
        </script>
         <?php
         }
         else
         {
             ?>
                    <label for="exampleInputEmail1">Child Category*</label>
                    <select class="form-control groups_eg_g" required name="childcategory[]" placeholder="Choose" onchange="console.log($(this).children(':selected').length)" multiple="multiple">
                    </select>
                    <?php echo form_error('childcategory'); ?>
                            <script type="text/javascript">
        $(document).ready(function () {
        window.asd = $('.SlectBox').SumoSelect({ csvDispCount: 6 });
        window.test = $('.testsel').SumoSelect({okCancelInMulti:true });
        window.testSelAll = $('.testSelAll').SumoSelect({okCancelInMulti:true, selectAll:true });
        window.testSelAlld = $('.SlectBox-grp').SumoSelect({okCancelInMulti:true, selectAll:true });
        window.testSelAll2 = $('.testSelAll2').SumoSelect({selectAll:true });
        window.Search = $('.search-box').SumoSelect({ csvDispCount: 3, search: true, searchText:'Enter here.' });
        window.searchSelAll = $('.search-box-sel-all').SumoSelect({ csvDispCount: 3, selectAll:true, search: true, searchText:'Enter here.', okCancelInMulti:true });
        window.searchSelAll = $('.search-box-open-up').SumoSelect({ csvDispCount: 3, selectAll:true, search: true, searchText:'Enter here.', up:true });
        window.groups_eg_g = $('.groups_eg_g').SumoSelect({selectAll:true, search:true });
        });
        </script>
             <?php
         }
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function get_area()
    {
        if($this->session->userdata('admin_id'))
        {
         $city_id = $this->input->post('city_id');  
         $getArea = $this->Commanmodel->all_multiple_query_order_by('city',array('parent_id' => $city_id, 'status' => 'Active'),'city_name','ASC');
         ?>
          <option value="">Choose</option>
         <?php
         foreach ($getArea as $getArea) 
         {
           ?>
             <option value="<?php echo $getArea->city_id; ?>" data-area="<?php echo $getArea->city_name; ?>"><?php echo $getArea->city_name; ?></option>
           <?php
         }

        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function create_property()
    {
        if($this->session->userdata('admin_id'))
        {    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/create-property');
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function create_property_process()
    {
        if($this->session->userdata('admin_id'))
        {
        if($this->input->post('CreateProperty'))
        {
        $this->form_validation->set_rules('property_title', 'Title', 'required',array(
          'required'  =>  'Please enter title'
        ));
        $this->form_validation->set_rules('property_url', 'URL', 'required|is_unique[property.url_slug]',array(
          'required'  =>  'Please enter url',
          'is_unique'  =>  'This URL is already exists!'
        ));
        if (empty($this->input->post('category'))) {
           $this->form_validation->set_rules('category', 'Category', 'required',array('required' =>'Select at least one Category'));
        }
        if (empty($this->input->post('childcategory'))) {
           $this->form_validation->set_rules('childcategory', 'Child Category', 'required',array('required' =>'Select at least one Child category'));
        }
        $this->form_validation->set_rules('property_status', 'Property Status', 'required',array('required'  =>  'Please select Property Status'));
        $this->form_validation->set_rules('construction_status', 'Construction Status', 'required',array('required'  =>  'Please select Construction Status'));
        $this->form_validation->set_rules('locality', 'Locality', 'required',array('required'  =>  'Please select locality'));
        $this->form_validation->set_rules('area', 'Area', 'required',array('required'  =>  'Please select area'));
        $this->form_validation->set_rules('developer', 'Developer', 'required',array('required'  =>  'Please select developer'));
        $this->form_validation->set_rules('full_address', 'Full address', 'required',array('required'  =>  'Please enter full address'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/create-property');
            $this->load->view('admin/footer');
                }
                else
                {
    $tokenID = $this->Commanmodel->generate_token_property();

          if($_FILES['primary_image']['name']!=""){
          $config['upload_path']          = 'assets/upload/property/';
          $config['allowed_types']        = '*';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('primary_image')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $primary_image=$upload_data['file_name'];
          }
          }
          else{
          $primary_image = '';
          }
          $category_row = !empty($this->input->post('category'))?count($this->input->post('category')):0;
          if($category_row > 0)
          {    
            $category = implode(',',$this->input->post('category'));  
          }
          else
          {
            $category = '';  
          }
          $childcategory_row = !empty($this->input->post('childcategory'))?count($this->input->post('childcategory')):0;
          if($childcategory_row > 0)
          {    
            $childCategory = implode(',',$this->input->post('childcategory'));  
          }
          else
          {
            $childCategory = '';  
          }
          
    $localityName = $this->Commanmodel->get_single_query('city',array('city_id' => $this->input->post('locality')));
    $areaName = $this->Commanmodel->get_single_query('city',array('city_id' => $this->input->post('area')));
    $post_data = array(
    'propertyToken' => $tokenID,
    'title' => $this->input->post('property_title'),
    'primary_image' => $primary_image,
    'primary_image_alt' => $this->input->post('primary_image_alt'),
    'url_slug' => $this->input->post('property_url'),    
    'category' => $category,
    'childcategory' => $childCategory,
    'property_status' => $this->input->post('property_status'),
    'construction_status' => $this->input->post('construction_status'),
    'locality' => $this->input->post('locality'),
    'search_locality' => $localityName->city_name,
    'area' => $this->input->post('area'),
    'search_area' => $areaName->city_name,
    'developer' => $this->input->post('developer'),
    'full_address' => $this->input->post('full_address'),
    'google_map_embaded_code' => $this->input->post('google_map_embaded_code')
    );
    $inserted = $this->Commanmodel->insert_query('property',$post_data); 
    if($inserted)
    {
        //$this->session->set_flashdata('created', 'This Property has been created.');
        redirect(base_url('admin/detail_property/'.$tokenID.''));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This Property has not been created. Please try again?');    
    $this->load->view('admin/head');
    $this->load->view('admin/sidebar');
    $this->load->view('admin/create-property');
    $this->load->view('admin/footer');
    }
    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Save & Continue process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/create-property');
            $this->load->view('admin/footer');
        }
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function edit_property($propertyToken)
    {
    $countCheck = $this->Commanmodel->checkCount('property',array('propertyToken' => $propertyToken)); 
    if($countCheck)
    {
    $data = array(
    'propertyToken' => $propertyToken
    );
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-property',$data);
        $this->load->view('admin/footer');
    }
    else
    {
       redirect(base_url('admin/dashboard'));
    }
    }


    public function edit_property_process($propertyToken)
    {
        if($this->session->userdata('admin_id'))
        {
        $data = array(
        'propertyToken' => $propertyToken
        );
        if($this->input->post('EditProperty'))
        {
        $this->form_validation->set_rules('property_title', 'Title', 'required',array(
          'required'  =>  'Please enter title'
        ));
        $this->form_validation->set_rules('property_url', 'URL', 'required',array(
          'required'  =>  'Please enter url'
        ));
        if (empty($this->input->post('category'))) {
           $this->form_validation->set_rules('category', 'Category', 'required',array('required' =>'Select at least one category'));
        }
       
        if (empty($this->input->post('childcategory'))) {
           $this->form_validation->set_rules('childcategory', 'Child Category', 'required',array('required' =>'Select at least one Child category'));
        }  
        $this->form_validation->set_rules('property_status', 'Property Status', 'required',array('required'  =>  'Please select Property Status'));
        $this->form_validation->set_rules('construction_status', 'Construction Status', 'required',array('required'  =>  'Please select Construction Status'));
        $this->form_validation->set_rules('locality', 'Locality', 'required',array('required'  =>  'Please select locality'));
        $this->form_validation->set_rules('area', 'Area', 'required',array('required'  =>  'Please select area'));
        $this->form_validation->set_rules('developer', 'Developer', 'required',array('required'  =>  'Please select developer'));
        $this->form_validation->set_rules('full_address', 'Full address', 'required',array('required'  =>  'Please enter full address'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-property',$data);
            $this->load->view('admin/footer');
                }
                else
                {  

          if($_FILES['primary_image']['name']!=""){
          $config['upload_path']          = 'assets/upload/property/';
          $config['allowed_types']        = '*';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('primary_image')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $primary_image=$upload_data['file_name'];
          }
          }
          else{
          $primary_image = $this->input->post('primary_image_old');
          }
          $category_row = !empty($this->input->post('category'))?count($this->input->post('category')):0;
          if($category_row > 0)
          {    
            $category = implode(',',$this->input->post('category'));  
          }
          else
          {
            $category = '';  
          }
          $childcategory_row = !empty($this->input->post('childcategory'))?count($this->input->post('childcategory')):0;
          if($childcategory_row > 0)
          {    
            $childCategory = implode(',',$this->input->post('childcategory'));  
          }
          else
          {
            $childCategory = '';  
          }
          
          
          $localityName = $this->Commanmodel->get_single_query('city',array('city_id' => $this->input->post('locality')));
          $areaName = $this->Commanmodel->get_single_query('city',array('city_id' => $this->input->post('area')));
          
          
    $post_data = array(
    'title' => $this->input->post('property_title'),
    'primary_image' => $primary_image,
    'primary_image_alt' => $this->input->post('primary_image_alt'),
    'url_slug' => $this->input->post('property_url'),    
    'category' => $category,
    'childcategory' => $childCategory,
    'property_status' => $this->input->post('property_status'),
    'construction_status' => $this->input->post('construction_status'),
    'locality' => $this->input->post('locality'),
    'search_locality' => $localityName->city_name,
    'area' => $this->input->post('area'),
    'search_area' => $areaName->city_name,
    'zipcode' => $this->input->post('zipcode'),
    'developer' => $this->input->post('developer'),
    'full_address' => $this->input->post('full_address'),
    'google_map_embaded_code' => $this->input->post('google_map_embaded_code')
    );
    $updated = $this->Commanmodel->update_query('property',$post_data,array('propertyToken' => $propertyToken)); 
    if($updated)
    {
        //$this->session->set_flashdata('created', 'This Property has been created.');
        redirect(base_url('admin/detail_property/'.$propertyToken.''));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This Property has not been updated. Please try again?');    
    $this->load->view('admin/head');
    $this->load->view('admin/sidebar');
    $this->load->view('admin/edit-property',$data);
    $this->load->view('admin/footer');
    }
    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Save & Continue process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-property',$data);
            $this->load->view('admin/footer');
        }
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function detail_property($propertyToken)
    {
    $countCheck = $this->Commanmodel->checkCount('property',array('propertyToken' => $propertyToken)); 
    if($countCheck)
    {
    $data = array(
    'propertyToken' => $propertyToken
    );
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/property-detail',$data);
        $this->load->view('admin/footer');
    }
    else
    {
       redirect(base_url('admin/create_property')); 
    }
    }


    public function detail_property_process($propertyToken)
    {
        if($this->session->userdata('admin_id'))
        {
        $data = array(
        'propertyToken' => $propertyToken
        );
        if($this->input->post('DetailSave'))
        {
        $this->form_validation->set_rules('property_token', 'property_token', 'required',array('required'  =>  'Property token invalid'));
        $this->form_validation->set_rules('rera_no', 'Rera no', 'required',array('required'  =>  'Please enter rera no'));
        $this->form_validation->set_rules('possession_date', 'Possession date', 'required',array('required'  =>  'Enter possession date'));
        $this->form_validation->set_rules('super_area', 'Super area min', 'required',array('required'  =>  'Enter super area min'));
        $this->form_validation->set_rules('super_area_max', 'Super area max', 'required',array('required'  =>  'Enter super area max'));
        $this->form_validation->set_rules('min_price', 'Min Price', 'required',array('required'  =>  'Enter min price'));
        $this->form_validation->set_rules('max_price', 'Max Price', 'required',array('required'  =>  'Enter max price'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/property-detail',$data);
            $this->load->view('admin/footer');
                }
    else
    {
    $total_rows = !empty($this->input->post('features'))?count($this->input->post('features')):0;
    if($total_rows > 0)
    {
      $featured = implode(',',$this->input->post('features'));
    }
    else
    {
      $featured = '';
    }
    $youtubeUrl = $this->input->post('youtube_url');
    if($youtubeUrl!='')
    {
    $embadedCode = $this->Commanmodel->GetEmbadedUrl($youtubeUrl);
    }
    else
    {
    $embadedCode = '';
    }
       $post_data = array(
         'rera_no' => $this->input->post('rera_no'),
         'min_price' => $this->input->post('min_price'),
         'max_price' => $this->input->post('max_price'),
         'possession_date' => $this->input->post('possession_date'),
         'super_area' => $this->input->post('super_area'),
         'super_area_max' => $this->input->post('super_area_max'),
         'assured_return' => $this->input->post('assured_return'),
         'description' => $this->input->post('description'),
         'specification' => $this->input->post('specification'),
         'features' => $featured,
         'youtube_url' => $youtubeUrl,
         'embaded_code' => $embadedCode
       );
      $inserted = $this->Commanmodel->update_query('property',$post_data,array('propertyToken' => $propertyToken));
      if($inserted)
      {
         
         
          // Property Detail Section
          $detail_heading_row = !empty($this->input->post('detail_heading'))?count($this->input->post('detail_heading')):0;
          if($detail_heading_row > 0)
          {
          $deleteData = $this->Commanmodel->delete_query('property_detail',array('propertyToken' => $propertyToken));
          for($i=0 ; $i<$detail_heading_row;$i++)
          {
          $post_data = array(
          'heading' => $this->input->post('detail_heading')[$i],
          'value' => $this->input->post('detail_value')[$i],    
          'propertyToken' => $propertyToken
          );
          $inserted = $this->Commanmodel->insert_query('property_detail',$post_data);
          }
          }
          // Property Detail Section Stop


          //  Property Plan Image 
          $plan_image_rows = !empty($_FILES['plan_image']['name'])?count($_FILES['plan_image']['name']):0;
          if($plan_image_rows > 0)
          {
          for($i=0 ; $i<$plan_image_rows;$i++)
          {
                    $_FILES['file']['name']     = $_FILES['plan_image']['name'][$i]; 
                    $_FILES['file']['type']     = $_FILES['plan_image']['type'][$i]; 
                    $_FILES['file']['tmp_name'] = $_FILES['plan_image']['tmp_name'][$i]; 
                    $_FILES['file']['error']     = $_FILES['plan_image']['error'][$i]; 
                    $_FILES['file']['size']     = $_FILES['plan_image']['size'][$i]; 

                    // File upload configuration 
                    $uploadPath = 'assets/upload/property/'; 
                    $config['upload_path'] = $uploadPath; 
                    $config['allowed_types'] = '*'; 
                    $config['max_size'] = 0;
                    $config['remove_spaces'] = TRUE;
                    $config['encrypt_name'] = TRUE;
                    // Load and initialize upload library 
                    $this->load->library('upload', $config); 
                    $this->upload->initialize($config); 
                    // Upload file to server 
                    if($this->upload->do_upload('file')){ 
                        // Uploaded file data 
                        $fileData = $this->upload->data(); 
                        $plan_image = $fileData['file_name']; 
                    }
                    if(!empty($plan_image))
                    {
                      $post_data = array(
                      'plan_image_alt' => $this->input->post('planimagealt')[$i],
                      'plan_image' => $plan_image,    
                      'propertyToken' => $propertyToken
                      );
                      $inserted = $this->Commanmodel->insert_query('property_planimage',$post_data);
                    }
          }
          }
          //  Property Plan Image Stop





          //  Property Floor Plan
          $floorname_rows = !empty($this->input->post('floorname'))?count($this->input->post('floorname')):0;
          if($floorname_rows > 0)
          {
          for($i=0 ; $i<$floorname_rows;$i++)
          {
                    $_FILES['file']['name']     = $_FILES['floorimage']['name'][$i]; 
                    $_FILES['file']['type']     = $_FILES['floorimage']['type'][$i]; 
                    $_FILES['file']['tmp_name'] = $_FILES['floorimage']['tmp_name'][$i]; 
                    $_FILES['file']['error']     = $_FILES['floorimage']['error'][$i]; 
                    $_FILES['file']['size']     = $_FILES['floorimage']['size'][$i]; 

                    // File upload configuration 
                    $uploadPath = 'assets/upload/property/'; 
                    $config['upload_path'] = $uploadPath; 
                    $config['allowed_types'] = '*'; 
                    $config['max_size'] = 0;
                    $config['remove_spaces'] = TRUE;
                    $config['encrypt_name'] = TRUE;
                    // Load and initialize upload library 
                    $this->load->library('upload', $config); 
                    $this->upload->initialize($config); 
                    // Upload file to server 
                    if($this->upload->do_upload('file')){ 
                        // Uploaded file data 
                        $fileData = $this->upload->data(); 
                        $floorimage = $fileData['file_name']; 
                    }
                    if(!empty($floorimage))
                    {
                      $post_data = array(
                      'floorname' => $this->input->post('floorname')[$i],
                      'floorimage' => $floorimage, 
                      'floorimagealt' => $this->input->post('floorimagealt')[$i],
                      'propertyToken' => $propertyToken
                      );
                      $inserted = $this->Commanmodel->insert_query('property_floor',$post_data);
                    }
          }
          }
          //  Property Floor Plan Stop

       redirect(base_url('admin/document_property/'.$propertyToken.''));
      }
      else
      {
        redirect(base_url('admin/detail_property/'.$propertyToken.''));
      }
    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Save & Continue process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/property-detail',$data);
            $this->load->view('admin/footer');
        }
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }



    

    public function document_property($propertyToken)
    {
    $countCheck = $this->Commanmodel->checkCount('property',array('propertyToken' => $propertyToken)); 
    if($countCheck)
    {
    $data = array(
    'propertyToken' => $propertyToken
    );
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/property-document',$data);
        $this->load->view('admin/footer');
    }
    else
    {
       redirect(base_url('admin/create_property')); 
    }
    }

    public function document_property_process($propertyToken)
    {
        if($this->session->userdata('admin_id'))
        {
        $data = array(
        'propertyToken' => $propertyToken
        );
        if($this->input->post('EditDocument'))
        {
        $this->form_validation->set_rules('property_token', 'property_token', 'required',array('required'  =>  'Property token invalid'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
      if ($this->form_validation->run() == FALSE)
      {    
      $this->load->view('admin/head');
      $this->load->view('admin/sidebar');
      $this->load->view('admin/property-document',$data);
      $this->load->view('admin/footer');
      }
    else
    {

          if($_FILES['brochure_pdf']['name']!=""){
          $config['upload_path']          = 'assets/upload/property/';
          $config['allowed_types']        = 'pdf';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('brochure_pdf')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $brochure_pdf=$upload_data['file_name'];
          }
          }
          else{
          $brochure_pdf = $this->input->post('brochure_pdf_old');
          }

          if($_FILES['price_list_pdf']['name']!=""){
          $config['upload_path']          = 'assets/upload/property/';
          $config['allowed_types']        = 'pdf';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('price_list_pdf')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $price_list_pdf=$upload_data['file_name'];
          }
          }
          else{
          $price_list_pdf = $this->input->post('price_list_pdf_old');
          }

          if($_FILES['application_form_pdf']['name']!=""){
          $config['upload_path']          = 'assets/upload/property/';
          $config['allowed_types']        = 'pdf';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('application_form_pdf')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $application_form_pdf=$upload_data['file_name'];
          }
          }
          else{
          $application_form_pdf = $this->input->post('price_list_pdf_old');
          }

          if($_FILES['other_pdf']['name']!=""){
          $config['upload_path']          = 'assets/upload/property/';
          $config['allowed_types']        = 'pdf';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('other_pdf')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $other_pdf=$upload_data['file_name'];
          }
          }
          else{
          $other_pdf = $this->input->post('other_pdf_old');
          }



        $post_data = array(
         'brochure_pdf' => $brochure_pdf,
         'price_list_pdf' => $price_list_pdf,
         'application_form_pdf' => $application_form_pdf,
         'other_pdf' => $other_pdf,
         'other_name' => $this->input->post('other_name')
        );
       $updateddata = $this->Commanmodel->update_query('property',$post_data,array('propertyToken' => $propertyToken));
       if($updateddata)
       {
              if(!empty($_FILES['gallery']['name'])){
                $filesCount = count($_FILES['gallery']['name']); 
                for($i = 0; $i < $filesCount; $i++){ 
                    $_FILES['file']['name']     = $_FILES['gallery']['name'][$i]; 
                    $_FILES['file']['type']     = $_FILES['gallery']['type'][$i]; 
                    $_FILES['file']['tmp_name'] = $_FILES['gallery']['tmp_name'][$i]; 
                    $_FILES['file']['error']     = $_FILES['gallery']['error'][$i]; 
                    $_FILES['file']['size']     = $_FILES['gallery']['size'][$i]; 

                    // File upload configuration 
                    $uploadPath = 'assets/upload/property/'; 
                    $config['upload_path'] = $uploadPath; 
                    $config['allowed_types'] = '*'; 
                    $config['max_size'] = 0;
                    $config['remove_spaces'] = TRUE;
                    $config['encrypt_name'] = TRUE;
                    // Load and initialize upload library 
                    $this->load->library('upload', $config); 
                    $this->upload->initialize($config); 
                    // Upload file to server 
                    if($this->upload->do_upload('file')){ 
                        // Uploaded file data 
                        $fileData = $this->upload->data(); 
                        $uploadGallery = $fileData['file_name']; 
                    }
                    if(!empty($uploadGallery))
                    {
                    $dataGallery = array(
                     'images' => $uploadGallery,
                     'imagealt' => $this->input->post('galleryalt')[$i],
                     'propertyToken' => $propertyToken
                    ); 
                    $insertGallery = $this->Commanmodel->insert_query('property_images',$dataGallery);
                    }
                }
              }


          //  Property Faq Stop
          $paymentplanname_rows = !empty($this->input->post('paymentplanname'))?count($this->input->post('paymentplanname')):0;
          if($paymentplanname_rows > 0)
          {
          for($i=0 ; $i<$paymentplanname_rows;$i++)
          {
                      $post_data = array(
                      'planname' => $this->input->post('paymentplanname')[$i],   
                      'propertyToken' => $propertyToken
                      );
                      $inserted = $this->Commanmodel->insert_query('property_planname',$post_data);
          }
          }
          //  Property Faq Stop



          //  Property Faq Stop
          $faqquestion_rows = !empty($this->input->post('faqquestion'))?count($this->input->post('faqquestion')):0;
          if($faqquestion_rows > 0)
          {
          for($i=0 ; $i<$faqquestion_rows;$i++)
          {
                      $post_data = array(
                      'question' => $this->input->post('faqquestion')[$i],
                      'answer' => $this->input->post('faqanswer')[$i],    
                      'propertyToken' => $propertyToken
                      );
                      $inserted = $this->Commanmodel->insert_query('property_faq',$post_data);
          }
          }
          //  Property Faq Stop
          
                if(!empty($_FILES['construction']['name'])){
                $filesCount = count($_FILES['construction']['name']); 
                for($i = 0; $i < $filesCount; $i++){ 
                    $_FILES['file']['name']     = $_FILES['construction']['name'][$i]; 
                    $_FILES['file']['type']     = $_FILES['construction']['type'][$i]; 
                    $_FILES['file']['tmp_name'] = $_FILES['construction']['tmp_name'][$i]; 
                    $_FILES['file']['error']     = $_FILES['construction']['error'][$i]; 
                    $_FILES['file']['size']     = $_FILES['construction']['size'][$i]; 

                    // File upload configuration 
                    $uploadPath = 'assets/upload/property/'; 
                    $config['upload_path'] = $uploadPath; 
                    $config['allowed_types'] = '*'; 
                    $config['max_size'] = 0;
                    $config['remove_spaces'] = TRUE;
                    $config['encrypt_name'] = TRUE;
                    // Load and initialize upload library 
                    $this->load->library('upload', $config); 
                    $this->upload->initialize($config); 
                    // Upload file to server 
                    if($this->upload->do_upload('file')){ 
                        // Uploaded file data 
                        $fileData = $this->upload->data(); 
                        $uploadConstruction = $fileData['file_name']; 
                    }
                    if(!empty($uploadConstruction))
                    {
                    $dataComstruction = array(
                     'images' => $uploadConstruction,
                     'constructionalt' => $this->input->post('constructionalt')[$i],
                     'propertyToken' => $propertyToken
                    ); 
                    $insertGallery = $this->Commanmodel->insert_query('property_construction',$dataComstruction);
                    }
                }
              }
          
          
          
          
          
          redirect(base_url('admin/apply_property/'.$propertyToken.''));
       }
       else
       {
            $this->session->set_flashdata('failed', 'This is not saved!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/property-document',$data);
            $this->load->view('admin/footer');
       }
    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Save & Continue process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/property-document',$data);
            $this->load->view('admin/footer');
        }
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }



    public function apply_property($propertyToken)
    {
    $countCheck = $this->Commanmodel->checkCount('property',array('propertyToken' => $propertyToken)); 
    if($countCheck)
    {
    $data = array(
    'propertyToken' => $propertyToken
    );
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/property-apply',$data);
        $this->load->view('admin/footer');
    }
    else
    {
       redirect(base_url('admin/create_property')); 
    }
    }



public function apply_property_process($propertyToken)
    {
        if($this->session->userdata('admin_id'))
        {
        $data = array(
        'propertyToken' => $propertyToken
        );
        if($this->input->post('SaveProperty'))
        {
        $this->form_validation->set_rules('property_token', 'property_token', 'required',array('required'  =>  'Property token invalid'));
        $this->form_validation->set_rules('status_post', 'Status', 'required',array('required'  =>  'Please select status'));

        $this->form_validation->set_rules('meta_title', 'Seo Title', 'required',array('required'  =>  'Please enter title'));

        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
      if ($this->form_validation->run() == FALSE)
      {    
      $this->load->view('admin/head');
      $this->load->view('admin/sidebar');
      $this->load->view('admin/property-apply',$data);
      $this->load->view('admin/footer');
      }
    else
    {
        $status = $this->input->post('status_post');
        if($status=='Draft')
        {
          $status_color = 'warning';
          $publishDate = '';
        }
        elseif($status=='Pending')
        {
          $status_color = 'info';
          $publishDate = '';
        }
        elseif($status=='Under Approvel')
        {
          $status_color = 'info';
          $publishDate = '';
        }
        elseif($status=='Approved')
        {
          $status_color = 'success';
          $publishDate = date('Y-m-d');
        }
        elseif($status=='Cancel')
        {
          $status_color = 'danger';
          $publishDate = '';
        }
        else
        {
          $status_color = 'danger';
          $publishDate = '';
        }
        
        if($this->input->post('new_launch')=='Yes')
        {
            $newLaunched = 'Yes';
        }
        else
        {
           $newLaunched = 'No'; 
        }
        
        if($this->input->post('assured_return')=='Yes')
        {
            $assuredReturn = 'Yes';
        }
        else
        {
           $assuredReturn = 'No'; 
        }
        
        if($this->input->post('pre_launched')=='Yes')
        {
            $preLaunched = 'Yes';
        }
        else
        {
           $preLaunched = 'No'; 
        }
        
        $banks_row = !empty($this->input->post('banks'))?count($this->input->post('banks')):0;
        if($banks_row > 0)
        {    
            $banks = implode(',',$this->input->post('banks'));  
        }
        else
        {
            $banks = '';  
        }
        
        $post_data = array(
          'banks' => $banks,
          'status' => $this->input->post('status_post'),
          'status_color' => $status_color,
          'publish_date' => $publishDate,
          'remark' => $this->input->post('remark'),
          'new_launch' => $newLaunched,
          'assured_return' => $assuredReturn,
          'pre_launched' => $preLaunched,
          'meta_title' => $this->input->post('meta_title'),
          'meta_keyword' => $this->input->post('meta_keyword'),
          'meta_description' => $this->input->post('meta_description')
        );
       $updateddata = $this->Commanmodel->update_query('property',$post_data,array('propertyToken' => $propertyToken));
       if($updateddata)
       {
          $this->session->set_flashdata('created', 'Your Propert has been posted successfully!');
          redirect(base_url('admin/property'));
       }
       else
       {
            $this->session->set_flashdata('failed', 'This Property is not saved!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/property-apply',$data);
            $this->load->view('admin/footer');
       }
    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit Property is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/property-apply',$data);
            $this->load->view('admin/footer');
        }
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function floordetail($id,$propertyToken)
    {
    $countCheck = $this->Commanmodel->checkCount('property_floor',array('propertyToken' => $propertyToken, 'id'=> $id)); 
    if($countCheck)
    {
    $data = array(
    'propertyToken' => $propertyToken,
    'id' => $id
    );
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/floor-detail',$data);
        $this->load->view('admin/footer');
    }
    else
    {
       redirect(base_url('admin/property')); 
    }
    }

   
   public function floordetail_process($id,$propertyToken)
    {
        if($this->session->userdata('admin_id'))
        {
        $data = array(
        'propertyToken' => $propertyToken,
        'id' => $id
        );
        if($this->input->post('AddFloorDetail'))
        {
        $this->form_validation->set_rules('property_token', 'property_token', 'required',array('required'  =>  'Property token invalid'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
      if ($this->form_validation->run() == FALSE)
      {    
      $this->load->view('admin/head');
      $this->load->view('admin/sidebar');
      $this->load->view('admin/floor-detail',$data);
      $this->load->view('admin/footer');
      }
    else
    {
          //  Property Faq Stop
          $heading_rows = !empty($this->input->post('heading'))?count($this->input->post('heading')):0;
          if($heading_rows > 0)
          {
          for($i=0 ; $i<$heading_rows;$i++)
          {
                      $post_data = array(
                      'heading' => $this->input->post('heading')[$i],
                      'value' => $this->input->post('value')[$i],    
                      'propertyToken' => $propertyToken,
                      'floor_id' => $id,
                      );
              $inserted = $this->Commanmodel->insert_query('property_floordetail',$post_data);
          }
          }
          //  Property Faq Stop
          
          $property = $this->Commanmodel->get_single_query('property',array('propertyToken' => $propertyToken));
          if($property->property_status=='Resell' OR $property->property_status=='Lease')
          {
             redirect(base_url('admin/apply_listing_property/'.$propertyToken.'')); 
          }
          else
          {
            redirect(base_url('admin/apply_property/'.$propertyToken.''));  
          }
          
          
    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Save & Continue process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/floor-detail',$data);
            $this->load->view('admin/footer');
        }
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


     public function paymentdetail($id,$propertyToken)
    {
    $countCheck = $this->Commanmodel->checkCount('property_planname',array('propertyToken' => $propertyToken, 'id'=> $id)); 
    if($countCheck)
    {
    $data = array(
    'propertyToken' => $propertyToken,
    'id' => $id
    );
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/payment-detail',$data);
        $this->load->view('admin/footer');
    }
    else
    {
       redirect(base_url('admin/create_property')); 
    }
    }

   
   public function paymentdetail_process($id,$propertyToken)
    {
        if($this->session->userdata('admin_id'))
        {
        $data = array(
        'propertyToken' => $propertyToken,
        'id' => $id
        );
        if($this->input->post('AddPaymentDetail'))
        {
        $this->form_validation->set_rules('property_token', 'property_token', 'required',array('required'  =>  'Property token invalid'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
      if ($this->form_validation->run() == FALSE)
      {    
      $this->load->view('admin/head');
      $this->load->view('admin/sidebar');
      $this->load->view('admin/payment-detail',$data);
      $this->load->view('admin/footer');
      }
    else
    {
          //  Property Faq Stop
          $heading_rows = !empty($this->input->post('heading'))?count($this->input->post('heading')):0;
          if($heading_rows > 0)
          {
          for($i=0 ; $i<$heading_rows;$i++)
          {
                      $post_data = array(
                      'heading' => $this->input->post('heading')[$i],
                      'value' => $this->input->post('value')[$i],    
                      'propertyToken' => $propertyToken,
                      'payment_id' => $id,
                      );
              $inserted = $this->Commanmodel->insert_query('property_paymentdetail',$post_data);
          }
          }
          //  Property Faq Stop
          $property = $this->Commanmodel->get_single_query('property',array('propertyToken' => $propertyToken));
          if($property->property_status=='Resell' OR $property->property_status=='Lease')
          {
             redirect(base_url('admin/apply_listing_property/'.$propertyToken.'')); 
          }
          else
          {
            redirect(base_url('admin/apply_property/'.$propertyToken.''));  
          }
    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Save & Continue process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/payment-detail',$data);
            $this->load->view('admin/footer');
        }
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }
  


    public function subscriber()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['subscriber'] = $this->Commanmodel->get_multiple_query_order_by('newsletter_subscription','id','DESC');    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/subscriber',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


        public function delete_subscriber($client_id)
    {
     $deleteClient = $this->Commanmodel->delete_query('newsletter_subscription',array('id' =>$client_id));
     if($deleteClient)
     {
      $this->session->set_flashdata('created', 'This Subscriber is delete.');
      redirect(base_url('admin/subscriber'));
     }
     else
     {
      $this->session->set_flashdata('failed', 'This Subscriber is not delete!');
      redirect(base_url('admin/subscriber')); 
     }
    }



public function our_news(){
        if($this->session->userdata('admin_id'))
        {
        $data['newsView'] = $this->Commanmodel->get_multiple_query_order_by('news','news_id','DESC');
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/our-news',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function create_news()
    {
        if($this->session->userdata('admin_id'))
        {    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/create-news');
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

 public function create_news_process()
    {
        if($this->session->userdata('admin_id'))
        {

        if($this->input->post('CreateNewNews'))
        {
        $this->form_validation->set_rules('news_name', 'News name', 'required',
            array('required'  =>  'Please enter news name'));

        $this->form_validation->set_rules('news_status', 'News status', 'required',
            array('required'  =>  'Please select status'));

        $this->form_validation->set_rules('news_small_description', 'News small description', 'required',
            array('required'  =>  'Please enter small description'));

        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/create-news');
            $this->load->view('admin/footer');
                }
                else
                {


    $status = $this->input->post('news_status');
    if($status=='Active')
    {
      $status_color = 'success';
    }
    if($status=='Inactive')
    {
      $status_color = 'danger';
    }
            if($_FILES['news_image']['name']!=""){
                $config['upload_path']          = 'assets/upload/blog/';
                $config['allowed_types']        = '*';
                $config['max_size']             = 0;
                $config['remove_spaces'] = TRUE;
                $config['encrypt_name'] = TRUE;
                $this->load->library('upload',$config);
                $this->load->initialize('upload', $config);
                if(!$this->upload->do_upload('news_image')){
                    $error = array('error' => $this->upload->display_errors());
                }
                else{
                    $upload_data=$this->upload->data();
                    $blog_image=$upload_data['file_name'];
                }
            }
            else{
              $blog_image = '';
            }

    $title = strip_tags($this->input->post('news_name'));
    $titleURL = strtolower(url_title($title));
    if(isUrlExists('news',$titleURL)){
    $titleURL = $titleURL.'-'.time(); 
    }
    $post_data = array(
    'news_name' => $this->input->post('news_name'),
    'url_slug' => $titleURL,
    'news_status' => $this->input->post('news_status'),
    'news_status_color' => $status_color,
    'news_image' => $blog_image,
    'news_small_description' => $this->input->post('news_small_description'),
    'news_description' => $this->input->post('news_description'),
    'meta_title' => $this->input->post('meta_title'),
    'meta_keyword' => $this->input->post('meta_keyword'),
    'meta_description' => $this->input->post('meta_description'),
    'date' => date('Y-m-d')
    );
                   $inserted = $this->Commanmodel->insert_query('news',$post_data); 
                   if($inserted)
                   {
                    $this->session->set_flashdata('created', 'This news has been created.');
                    redirect(base_url('admin/create_news'));
                   }
                   else
                   {
            $this->session->set_flashdata('failed', 'Sorry, This news has not been created. Please try again?');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/create-news');
            $this->load->view('admin/footer');
                   }


                }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/create-news');
            $this->load->view('admin/footer');
        }



        }
        else
        {
            redirect(base_url('admin/'));
        }
    }
    
    public function delete_our_news($blog_id)
    {
     $deleteBlog = $this->Commanmodel->delete_query('news',array('news_id' =>$blog_id));
     if($deleteBlog)
     {
      $this->session->set_flashdata('created', 'This news is delete.');
      redirect(base_url('admin/our_news'));
     }
     else
     {
      $this->session->set_flashdata('failed', 'This news is not delete!');
      redirect(base_url('admin/our_news')); 
     }
    
    }


    public function edit_our_news($blog_id)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['newsView'] = $this->Commanmodel->get_single_query('news',array('news_id' => $blog_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-news',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


 public function edit_news_process($blog_id)
    {
        if($this->session->userdata('admin_id'))
        {

        if($this->input->post('CreateEditNews'))
        {
        $this->form_validation->set_rules('news_name', 'News name', 'required',
            array('required'  =>  'Please enter news name'));

        $this->form_validation->set_rules('news_status', 'News status', 'required',
            array('required'  =>  'Please select status'));

        $this->form_validation->set_rules('news_small_description', 'News small description', 'required',
            array('required'  =>  'Please enter small description'));

        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {   
        $data['newsView'] = $this->Commanmodel->get_single_query('news',array('news_id' => $blog_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-news',$data);
        $this->load->view('admin/footer');
                }
                else
                {


    $status = $this->input->post('news_status');
    if($status=='Active')
    {
      $status_color = 'success';
    }
    if($status=='Inactive')
    {
      $status_color = 'danger';
    }
            if($_FILES['news_image']['name']!=""){
                $config['upload_path']          = 'assets/upload/blog/';
                $config['allowed_types']        = '*';
                $config['max_size']             = 0;
                $this->load->library('upload',$config);
                if(!$this->upload->do_upload('news_image')){
                    $error = array('error' => $this->upload->display_errors());
                }
                else{
                    $upload_data=$this->upload->data();
                    $news_image=$upload_data['file_name'];
                }
            }
            else{
                  $news_image= $this->input->post('news_image_old');
            }


    $title = strip_tags($this->input->post('news_name'));
    $titleURL = strtolower(url_title($title));
    if(isUrlExistsNews('news',$titleURL,$blog_id)){
    $titleURL = $titleURL.'-'.time(); 
    }
    $post_data = array(
    'news_name' => $this->input->post('news_name'),
    'url_slug' => $titleURL,
    'news_status' => $this->input->post('news_status'),
    'news_status_color' => $status_color,
    'news_image' => $news_image,
    'news_small_description' => $this->input->post('news_small_description'),
    'news_description' => $this->input->post('news_description'),
    'meta_title' => $this->input->post('meta_title'),
    'meta_keyword' => $this->input->post('meta_keyword'),
    'meta_description' => $this->input->post('meta_description')
    );
                   $inserted = $this->Commanmodel->update_query('news',$post_data,array('news_id' => $blog_id)); 
                   if($inserted)
                   {
                    $this->session->set_flashdata('created', 'This news has been updated.');
                    redirect(base_url('admin/our_news'));
                   }
                   else
                   {
            $this->session->set_flashdata('failed', 'Sorry, This news has not been updated. Please try again?');    
        $data['newsView'] = $this->Commanmodel->get_single_query('news',array('news_id' => $blog_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-news',$data);
        $this->load->view('admin/footer');
                   }


                }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
        $data['newsView'] = $this->Commanmodel->get_single_query('news',array('news_id' => $blog_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-news',$data);
        $this->load->view('admin/footer');
        }



        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function create_resell_property()
    {
        if($this->session->userdata('admin_id'))
        {    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/create-resell-property');
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function create_resell_property_process()
    {
        if($this->session->userdata('admin_id'))
        {
        if($this->input->post('CreateProperty'))
        {
        $this->form_validation->set_rules('property_title', 'Title', 'required',array(
          'required'  =>  'Please enter title'
        ));
        $this->form_validation->set_rules('property_url', 'URL', 'required|is_unique[property.url_slug]',array(
          'required'  =>  'Please enter url',
          'is_unique'  =>  'This URL is already exists!'
        ));
        if (empty($this->input->post('category'))) {
           $this->form_validation->set_rules('category', 'Category', 'required',array('required' =>'Select at least one Category'));
        }
        if (empty($this->input->post('childcategory'))) {
           $this->form_validation->set_rules('childcategory', 'Child Category', 'required',array('required' =>'Select at least one Child category'));
        }
        $this->form_validation->set_rules('property_status', 'Property Status', 'required',array('required'  =>  'Please select Property Status'));
        $this->form_validation->set_rules('construction_status', 'Construction Status', 'required',array('required'  =>  'Please select Construction Status'));
        $this->form_validation->set_rules('locality', 'Locality', 'required',array('required'  =>  'Please select locality'));
        $this->form_validation->set_rules('area', 'Area', 'required',array('required'  =>  'Please select area'));
        $this->form_validation->set_rules('full_address', 'Full address', 'required',array('required'  =>  'Please enter full address'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/create-resell-property');
            $this->load->view('admin/footer');
                }
                else
                {
    $tokenID = $this->Commanmodel->generate_token_property();

          if($_FILES['primary_image']['name']!=""){
          $config['upload_path']          = 'assets/upload/property/';
          $config['allowed_types']        = '*';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('primary_image')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $primary_image=$upload_data['file_name'];
          }
          }
          else{
          $primary_image = '';
          }
    
    
          $category_row = !empty($this->input->post('category'))?count($this->input->post('category')):0;
          if($category_row > 0)
          {    
            $category = implode(',',$this->input->post('category'));  
          }
          else
          {
            $category = '';  
          }
          $childcategory_row = !empty($this->input->post('childcategory'))?count($this->input->post('childcategory')):0;
          if($childcategory_row > 0)
          {    
            $childCategory = implode(',',$this->input->post('childcategory'));  
          }
          else
          {
            $childCategory = '';  
          }
    
    $localityName = $this->Commanmodel->get_single_query('city',array('city_id' => $this->input->post('locality')));
    $areaName = $this->Commanmodel->get_single_query('city',array('city_id' => $this->input->post('area')));
   
    
    $post_data = array(
    'post_type' => 'Listing',
    'propertyToken' => $tokenID,
    'title' => $this->input->post('property_title'),
    'primary_image' => $primary_image,
    'primary_image_alt' => $this->input->post('primary_image_alt'),
    'url_slug' => $this->input->post('property_url'),    
    'category' => $category,
    'childcategory' => $childCategory,
    'property_status' => $this->input->post('property_status'),
    'construction_status' => $this->input->post('construction_status'),
    'locality' => $this->input->post('locality'),
    'search_locality' => $localityName->city_name,
    'area' => $this->input->post('area'),
    'search_area' => $areaName->city_name,
    'full_address' => $this->input->post('full_address'),
    'google_map_embaded_code' => $this->input->post('google_map_embaded_code')
    );
    $inserted = $this->Commanmodel->insert_query('property',$post_data); 
    if($inserted)
    {
        redirect(base_url('admin/detail_resell_property/'.$tokenID.''));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This Property has not been created. Please try again?');    
    $this->load->view('admin/head');
    $this->load->view('admin/sidebar');
    $this->load->view('admin/create-resell-property');
    $this->load->view('admin/footer');
    }
    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Save & Continue process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/create-resell-property');
            $this->load->view('admin/footer');
        }
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function edit_resell_property($propertyToken)
    {
    $countCheck = $this->Commanmodel->checkCount('property',array('propertyToken' => $propertyToken)); 
    if($countCheck)
    {
    $data = array(
    'propertyToken' => $propertyToken
    );
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-resell-property',$data);
        $this->load->view('admin/footer');
    }
    else
    {
       redirect(base_url('admin/dashboard'));
    }
    }


    public function edit_resell_property_process($propertyToken)
    {
        if($this->session->userdata('admin_id'))
        {
        $data = array(
        'propertyToken' => $propertyToken
        );
        if($this->input->post('EditProperty'))
        {
        $this->form_validation->set_rules('property_title', 'Title', 'required',array(
          'required'  =>  'Please enter title'
        ));
        $this->form_validation->set_rules('property_url', 'URL', 'required',array(
          'required'  =>  'Please enter url'
        ));
        if (empty($this->input->post('category'))) {
           $this->form_validation->set_rules('category', 'Category', 'required',array('required' =>'Select at least one category'));
        }
       
        if (empty($this->input->post('childcategory'))) {
           $this->form_validation->set_rules('childcategory', 'Child Category', 'required',array('required' =>'Select at least one Child category'));
        }  
        $this->form_validation->set_rules('property_status', 'Property Status', 'required',array('required'  =>  'Please select Property Status'));
        $this->form_validation->set_rules('construction_status', 'Construction Status', 'required',array('required'  =>  'Please select Construction Status'));
        $this->form_validation->set_rules('locality', 'Locality', 'required',array('required'  =>  'Please select locality'));
        $this->form_validation->set_rules('area', 'Area', 'required',array('required'  =>  'Please select area'));
        $this->form_validation->set_rules('full_address', 'Full address', 'required',array('required'  =>  'Please enter full address'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-resell-property',$data);
            $this->load->view('admin/footer');
                }
                else
                {  

          if($_FILES['primary_image']['name']!=""){
          $config['upload_path']          = 'assets/upload/property/';
          $config['allowed_types']        = '*';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('primary_image')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $primary_image=$upload_data['file_name'];
          }
          }
          else{
          $primary_image = $this->input->post('primary_image_old');
          }
          $category_row = !empty($this->input->post('category'))?count($this->input->post('category')):0;
          if($category_row > 0)
          {    
            $category = implode(',',$this->input->post('category'));  
          }
          else
          {
            $category = '';  
          }
          $childcategory_row = !empty($this->input->post('childcategory'))?count($this->input->post('childcategory')):0;
          if($childcategory_row > 0)
          {    
            $childCategory = implode(',',$this->input->post('childcategory'));  
          }
          else
          {
            $childCategory = '';  
          }
    $localityName = $this->Commanmodel->get_single_query('city',array('city_id' => $this->input->post('locality')));
    $areaName = $this->Commanmodel->get_single_query('city',array('city_id' => $this->input->post('area')));
    $post_data = array(
    'title' => $this->input->post('property_title'),
    'primary_image' => $primary_image,
    'primary_image_alt' => $this->input->post('primary_image_alt'),
    'url_slug' => $this->input->post('property_url'),    
    'category' => $category,
    'childcategory' => $childCategory,
    'property_status' => $this->input->post('property_status'),
    'construction_status' => $this->input->post('construction_status'),
    'locality' => $this->input->post('locality'),
    'search_locality' => $localityName->city_name,
    'area' => $this->input->post('area'),
    'search_area' => $areaName->city_name,
    'zipcode' => $this->input->post('zipcode'),
    'full_address' => $this->input->post('full_address'),
    'google_map_embaded_code' => $this->input->post('google_map_embaded_code')
    );
    $updated = $this->Commanmodel->update_query('property',$post_data,array('propertyToken' => $propertyToken)); 
    if($updated)
    {
        redirect(base_url('admin/detail_resell_property/'.$propertyToken.''));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This Property has not been updated. Please try again?');    
    $this->load->view('admin/head');
    $this->load->view('admin/sidebar');
    $this->load->view('admin/edit-resell-property',$data);
    $this->load->view('admin/footer');
    }
    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Save & Continue process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/edit-resell-property',$data);
            $this->load->view('admin/footer');
        }
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }
    
    
    public function detail_resell_property($propertyToken)
    {
    $countCheck = $this->Commanmodel->checkCount('property',array('propertyToken' => $propertyToken)); 
    if($countCheck)
    {
    $data = array(
    'propertyToken' => $propertyToken
    );
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/property-resell-detail',$data);
        $this->load->view('admin/footer');
    }
    else
    {
       redirect(base_url('admin/create_resell_property')); 
    }
    }
    

    public function detail_resell_property_process($propertyToken)
    {
        if($this->session->userdata('admin_id'))
        {
        $data = array(
        'propertyToken' => $propertyToken
        );
        $propertyDetail = $this->Commanmodel->get_single_query('property',array('propertyToken' => $propertyToken));
        if($this->input->post('DetailSave'))
        {
          $this->form_validation->set_rules('property_token', 'property_token', 'required',array('required'  =>  'Property token invalid'));
          $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
          if ($this->form_validation->run() == FALSE)
          {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/property-resell-detail',$data);
            $this->load->view('admin/footer');
          }
        else
        {
        $furnishing = $this->input->post('furnishing');
        if($furnishing=='Full Furnished')
        {
            $seats_workstation = $this->input->post('seats_workstation');
            $cabins = $this->input->post('cabins');
            $pentry_kitchen = $this->input->post('pentry_kitchen');
            $reception = $this->input->post('reception');
            $server_room = $this->input->post('server_room');
            $conference_room = $this->input->post('conference_room');
            $furnishing_other = $this->input->post('furnishing_other');
        }
        else
        {
            $seats_workstation = '';
            $cabins = '';
            $pentry_kitchen = '';
            $reception = '';
            $server_room = '';
            $conference_room = '';
            $furnishing_other = ''; 
        }
        
        
        
        if($propertyDetail->property_status=='Resell')
        {
        $property_already_lease = $this->input->post('property_already_lease');
        if($property_already_lease=='Yes')
        {
            $rental_value_amount = $this->input->post('rental_value_amount');
            $security_deposit = $this->input->post('security_deposit');
            $lock_in_period = $this->input->post('lock_in_period');
            $rented_to_home = $this->input->post('rented_to_home');
            $lease_tenure = $this->input->post('lease_tenure');
            $lease_escalation = $this->input->post('lease_escalation');
        }
        else
        {
            $rental_value_amount = '';
            $security_deposit = '';
            $lock_in_period = '';
            $rented_to_home = '';
            $lease_tenure = '';
            $lease_escalation = '';
        }
        }
        else
        {
            $security_deposit = $this->input->post('security_deposit');
            $lock_in_period = $this->input->post('lock_in_period');
            $rented_to_home = $this->input->post('rented_to_home');
            $lease_tenure = $this->input->post('lease_tenure');
            $lease_escalation = $this->input->post('lease_escalation');
            $rental_value_amount = '';
        }
        
            
        $post_data = array(
         'rera_no' => $this->input->post('rera_no'),
         'grade_of_buildings' => $this->input->post('grade_of_buildings'),
         'super_area' => $this->input->post('super_area'),
         'carpet_area' => $this->input->post('carpet_area'),
         'loading_in' => $this->input->post('loading_in'),
         'floor_out' => $this->input->post('floor_out'),
         'facing_direction' => $this->input->post('facing_direction'),
         'over_looking' => $this->input->post('over_looking'),
         'property_age' => $this->input->post('property_age'),
         'possession_date' => $this->input->post('possession_date'),
         'furnishing' => $this->input->post('furnishing'),
         'seats_workstation' => $seats_workstation,
         'cabins' => $cabins,
         'pentry_kitchen' => $pentry_kitchen,
         'reception' => $reception,
         'server_room' => $server_room,
         'conference_room' => $conference_room,
         'furnishing_other' => $furnishing_other,
         'property_height' => $this->input->post('property_height'),
         'security' => $this->input->post('security'),
         'water_availability' => $this->input->post('water_availability'),
         'power_backup' => $this->input->post('power_backup'),
         'pantry_cafeteria' => $this->input->post('pantry_cafeteria'),
         'pre_launched' => $this->input->post('property_already_lease'),
         'rental_value_amount' => $rental_value_amount,
         'security_deposit' => $security_deposit,
         'lock_in_period' => $lock_in_period,
         'rented_to_home' => $rented_to_home,
         'lease_escalation' => $lease_escalation,
         'lease_tenure' => $lease_tenure,
         'land_zone' => $this->input->post('land_zone'),
         'ideal_for' => $this->input->post('ideal_for'),
         'min_price' => $this->input->post('min_price')
        );
        $inserted = $this->Commanmodel->update_query('property',$post_data,array('propertyToken' => $propertyToken));
        if($inserted)
        {
            
          //  Property Faq Stop
          $locationnearby_rows = !empty($this->input->post('locationnearby'))?count($this->input->post('locationnearby')):0;
          if($locationnearby_rows > 0)
          {
          for($i=0 ; $i<$locationnearby_rows;$i++)
          {
                      $post_data = array(
                      'location' => $this->input->post('locationnearby')[$i],   
                      'propertyToken' => $propertyToken
                      );
                      $inserted = $this->Commanmodel->insert_query('property_location',$post_data);
          }
          }
          //  Property Faq Stop
            
            
          redirect(base_url('admin/document_listing_property/'.$propertyToken.''));
        }
        else
        {
          redirect(base_url('admin/detail_resell_property/'.$propertyToken.''));
        }
        }
        
        }
        else
        {
            $this->session->set_flashdata('failed', 'Save & Continue process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/property-resell-detail',$data);
            $this->load->view('admin/footer');
        }
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    
    
    
    
    public function document_listing_property($propertyToken)
    {
    $countCheck = $this->Commanmodel->checkCount('property',array('propertyToken' => $propertyToken)); 
    if($countCheck)
    {
    $data = array(
    'propertyToken' => $propertyToken
    );
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/property-listing-document',$data);
        $this->load->view('admin/footer');
    }
    else
    {
       redirect(base_url('admin/create_property')); 
    }
    }

    public function document_listing_property_process($propertyToken)
    {
        if($this->session->userdata('admin_id'))
        {
        $data = array(
        'propertyToken' => $propertyToken
        );
        if($this->input->post('EditDocument'))
        {
        $this->form_validation->set_rules('property_token', 'property_token', 'required',array('required'  =>  'Property token invalid'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
      if ($this->form_validation->run() == FALSE)
      {    
      $this->load->view('admin/head');
      $this->load->view('admin/sidebar');
      $this->load->view('admin/property-listing-document',$data);
      $this->load->view('admin/footer');
      }
    else
    {

    $total_rows = !empty($this->input->post('features'))?count($this->input->post('features')):0;
    if($total_rows > 0)
    {
      $featured = implode(',',$this->input->post('features'));
    }
    else
    {
      $featured = '';
    }
    $youtubeUrl = $this->input->post('youtube_url');
    if($youtubeUrl!='')
    {
    $embadedCode = $this->Commanmodel->GetEmbadedUrl($youtubeUrl);
    }
    else
    {
    $embadedCode = '';
    }
          




          if($_FILES['brochure_pdf']['name']!=""){
          $config['upload_path']          = 'assets/upload/property/';
          $config['allowed_types']        = 'pdf';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('brochure_pdf')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $brochure_pdf=$upload_data['file_name'];
          }
          }
          else{
          $brochure_pdf = $this->input->post('brochure_pdf_old');
          }

          if($_FILES['price_list_pdf']['name']!=""){
          $config['upload_path']          = 'assets/upload/property/';
          $config['allowed_types']        = 'pdf';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('price_list_pdf')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $price_list_pdf=$upload_data['file_name'];
          }
          }
          else{
          $price_list_pdf = $this->input->post('price_list_pdf_old');
          }

          if($_FILES['application_form_pdf']['name']!=""){
          $config['upload_path']          = 'assets/upload/property/';
          $config['allowed_types']        = 'pdf';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('application_form_pdf')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $application_form_pdf=$upload_data['file_name'];
          }
          }
          else{
          $application_form_pdf = $this->input->post('price_list_pdf_old');
          }

          if($_FILES['other_pdf']['name']!=""){
          $config['upload_path']          = 'assets/upload/property/';
          $config['allowed_types']        = 'pdf';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('other_pdf')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $other_pdf=$upload_data['file_name'];
          }
          }
          else{
          $other_pdf = $this->input->post('other_pdf_old');
          }
         $post_data = array(
         'brochure_pdf' => $brochure_pdf,
         'price_list_pdf' => $price_list_pdf,
         'application_form_pdf' => $application_form_pdf,
         'other_pdf' => $other_pdf,
         'other_name' => $this->input->post('other_name'),
         'description' => $this->input->post('description'),
         'features' => $featured,
         'youtube_url' => $youtubeUrl,
         'embaded_code' => $embadedCode
        );
       $updateddata = $this->Commanmodel->update_query('property',$post_data,array('propertyToken' => $propertyToken));
       if($updateddata)
       {
           
           
           //  Property Plan Image 
          $plan_image_rows = !empty($_FILES['plan_image']['name'])?count($_FILES['plan_image']['name']):0;
          if($plan_image_rows > 0)
          {
          for($i=0 ; $i<$plan_image_rows;$i++)
          {
                    $_FILES['file']['name']     = $_FILES['plan_image']['name'][$i]; 
                    $_FILES['file']['type']     = $_FILES['plan_image']['type'][$i]; 
                    $_FILES['file']['tmp_name'] = $_FILES['plan_image']['tmp_name'][$i]; 
                    $_FILES['file']['error']     = $_FILES['plan_image']['error'][$i]; 
                    $_FILES['file']['size']     = $_FILES['plan_image']['size'][$i]; 

                    // File upload configuration 
                    $uploadPath = 'assets/upload/property/'; 
                    $config['upload_path'] = $uploadPath; 
                    $config['allowed_types'] = '*'; 
                    $config['max_size'] = 0;
                    $config['remove_spaces'] = TRUE;
                    $config['encrypt_name'] = TRUE;
                    // Load and initialize upload library 
                    $this->load->library('upload', $config); 
                    $this->upload->initialize($config); 
                    // Upload file to server 
                    if($this->upload->do_upload('file')){ 
                        // Uploaded file data 
                        $fileData = $this->upload->data(); 
                        $plan_image = $fileData['file_name']; 
                    }
                    if(!empty($plan_image))
                    {
                      $post_data = array(
                      'plan_image_alt' => $this->input->post('planimagealt')[$i],
                      'plan_image' => $plan_image,    
                      'propertyToken' => $propertyToken
                      );
                      $inserted = $this->Commanmodel->insert_query('property_planimage',$post_data);
                    }
          }
          }
          //  Property Plan Image Stop





          //  Property Floor Plan
          $floorname_rows = !empty($this->input->post('floorname'))?count($this->input->post('floorname')):0;
          if($floorname_rows > 0)
          {
          for($i=0 ; $i<$floorname_rows;$i++)
          {
                    $_FILES['file']['name']     = $_FILES['floorimage']['name'][$i]; 
                    $_FILES['file']['type']     = $_FILES['floorimage']['type'][$i]; 
                    $_FILES['file']['tmp_name'] = $_FILES['floorimage']['tmp_name'][$i]; 
                    $_FILES['file']['error']     = $_FILES['floorimage']['error'][$i]; 
                    $_FILES['file']['size']     = $_FILES['floorimage']['size'][$i]; 

                    // File upload configuration 
                    $uploadPath = 'assets/upload/property/'; 
                    $config['upload_path'] = $uploadPath; 
                    $config['allowed_types'] = '*'; 
                    $config['max_size'] = 0;
                    $config['remove_spaces'] = TRUE;
                    $config['encrypt_name'] = TRUE;
                    // Load and initialize upload library 
                    $this->load->library('upload', $config); 
                    $this->upload->initialize($config); 
                    // Upload file to server 
                    if($this->upload->do_upload('file')){ 
                        // Uploaded file data 
                        $fileData = $this->upload->data(); 
                        $floorimage = $fileData['file_name']; 
                    }
                    if(!empty($floorimage))
                    {
                      $post_data = array(
                      'floorname' => $this->input->post('floorname')[$i],
                      'floorimage' => $floorimage,    
                      'floorimagealt' => $this->input->post('floorimagealt')[$i],
                      'propertyToken' => $propertyToken
                      );
                      $inserted = $this->Commanmodel->insert_query('property_floor',$post_data);
                    }
          }
          }
          //  Property Floor Plan Stop

           
           
           
           
              if(!empty($_FILES['gallery']['name'])){
                $filesCount = count($_FILES['gallery']['name']); 
                for($i = 0; $i < $filesCount; $i++){ 
                    $_FILES['file']['name']     = $_FILES['gallery']['name'][$i]; 
                    $_FILES['file']['type']     = $_FILES['gallery']['type'][$i]; 
                    $_FILES['file']['tmp_name'] = $_FILES['gallery']['tmp_name'][$i]; 
                    $_FILES['file']['error']     = $_FILES['gallery']['error'][$i]; 
                    $_FILES['file']['size']     = $_FILES['gallery']['size'][$i]; 

                    // File upload configuration 
                    $uploadPath = 'assets/upload/property/'; 
                    $config['upload_path'] = $uploadPath; 
                    $config['allowed_types'] = '*'; 
                    $config['max_size'] = 0;
                    $config['remove_spaces'] = TRUE;
                    $config['encrypt_name'] = TRUE;
                    // Load and initialize upload library 
                    $this->load->library('upload', $config); 
                    $this->upload->initialize($config); 
                    // Upload file to server 
                    if($this->upload->do_upload('file')){ 
                        // Uploaded file data 
                        $fileData = $this->upload->data(); 
                        $uploadGallery = $fileData['file_name']; 
                    }
                    if(!empty($uploadGallery))
                    {
                    $dataGallery = array(
                     'images' => $uploadGallery,
                     'imagealt' => $this->input->post('galleryalt')[$i],
                     'propertyToken' => $propertyToken
                    ); 
                    $insertGallery = $this->Commanmodel->insert_query('property_images',$dataGallery);
                    }
                }
              }


          //  Property Faq Stop
          $paymentplanname_rows = !empty($this->input->post('paymentplanname'))?count($this->input->post('paymentplanname')):0;
          if($paymentplanname_rows > 0)
          {
          for($i=0 ; $i<$paymentplanname_rows;$i++)
          {
                      $post_data = array(
                      'planname' => $this->input->post('paymentplanname')[$i],   
                      'propertyToken' => $propertyToken
                      );
                      $inserted = $this->Commanmodel->insert_query('property_planname',$post_data);
          }
          }
          //  Property Faq Stop



          //  Property Faq Stop
          $faqquestion_rows = !empty($this->input->post('faqquestion'))?count($this->input->post('faqquestion')):0;
          if($faqquestion_rows > 0)
          {
          for($i=0 ; $i<$faqquestion_rows;$i++)
          {
                      $post_data = array(
                      'question' => $this->input->post('faqquestion')[$i],
                      'answer' => $this->input->post('faqanswer')[$i],    
                      'propertyToken' => $propertyToken
                      );
                      $inserted = $this->Commanmodel->insert_query('property_faq',$post_data);
          }
          }
          //  Property Faq Stop
          
                if(!empty($_FILES['construction']['name'])){
                $filesCount = count($_FILES['construction']['name']); 
                for($i = 0; $i < $filesCount; $i++){ 
                    $_FILES['file']['name']     = $_FILES['construction']['name'][$i]; 
                    $_FILES['file']['type']     = $_FILES['construction']['type'][$i]; 
                    $_FILES['file']['tmp_name'] = $_FILES['construction']['tmp_name'][$i]; 
                    $_FILES['file']['error']     = $_FILES['construction']['error'][$i]; 
                    $_FILES['file']['size']     = $_FILES['construction']['size'][$i]; 

                    // File upload configuration 
                    $uploadPath = 'assets/upload/property/'; 
                    $config['upload_path'] = $uploadPath; 
                    $config['allowed_types'] = '*'; 
                    $config['max_size'] = 0;
                    $config['remove_spaces'] = TRUE;
                    $config['encrypt_name'] = TRUE;
                    // Load and initialize upload library 
                    $this->load->library('upload', $config); 
                    $this->upload->initialize($config); 
                    // Upload file to server 
                    if($this->upload->do_upload('file')){ 
                        // Uploaded file data 
                        $fileData = $this->upload->data(); 
                        $uploadConstruction = $fileData['file_name']; 
                    }
                    if(!empty($uploadConstruction))
                    {
                    $dataComstruction = array(
                     'images' => $uploadConstruction,
                     'constructionalt' => $this->input->post('constructionalt')[$i],
                     'propertyToken' => $propertyToken
                    ); 
                    $insertGallery = $this->Commanmodel->insert_query('property_construction',$dataComstruction);
                    }
                }
              }
          
          redirect(base_url('admin/apply_listing_property/'.$propertyToken.''));
       }
       else
       {
            $this->session->set_flashdata('failed', 'This is not saved!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/property-listing-document',$data);
            $this->load->view('admin/footer');
       }
    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Save & Continue process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/property-listing-document',$data);
            $this->load->view('admin/footer');
        }
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


     public function apply_listing_property($propertyToken)
    {
    $countCheck = $this->Commanmodel->checkCount('property',array('propertyToken' => $propertyToken)); 
    if($countCheck)
    {
    $data = array(
    'propertyToken' => $propertyToken
    );
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/property-listing-apply',$data);
        $this->load->view('admin/footer');
    }
    else
    {
       redirect(base_url('admin/')); 
    }
    }



public function apply_listing_property_process($propertyToken)
    {
        if($this->session->userdata('admin_id'))
        {
        $data = array(
        'propertyToken' => $propertyToken
        );
        if($this->input->post('SaveProperty'))
        {
        $this->form_validation->set_rules('property_token', 'property_token', 'required',array('required'  =>  'Property token invalid'));
        $this->form_validation->set_rules('status_post', 'Status', 'required',array('required'  =>  'Please select status'));
        $this->form_validation->set_rules('meta_title', 'Seo Title', 'required',array('required'  =>  'Please enter title'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
      if ($this->form_validation->run() == FALSE)
      {    
      $this->load->view('admin/head');
      $this->load->view('admin/sidebar');
      $this->load->view('admin/property-listing-apply',$data);
      $this->load->view('admin/footer');
      }
    else
    {
        $status = $this->input->post('status_post');
        if($status=='Draft')
        {
          $status_color = 'danger';
          $publishDate = 'NULL';
        }
        elseif($status=='Pending')
        {
          $status_color = 'info';
          $publishDate = 'NULL';
        }
        elseif($status=='Under Approved')
        {
          $status_color = 'warning';
          $publishDate = 'NULL';
        }
        elseif($status=='Approved')
        {
          $status_color = 'success';
          $publishDate = date('Y-m-d');
        }
        elseif($status=='Cancel')
        {
          $status_color = 'danger';
          $publishDate = 'NULL';
        }
        else
        {
          $status_color = 'danger';
          $publishDate = 'NULL';
        }
        
        if($this->input->post('new_launch')=='Yes')
        {
            $newLaunched = 'Yes';
        }
        else
        {
           $newLaunched = 'No'; 
        }
        
        if($this->input->post('assured_return')=='Yes')
        {
            $assuredReturn = 'Yes';
        }
        else
        {
           $assuredReturn = 'No'; 
        }
        
        $post_data = array(
          'status' => $this->input->post('status_post'),
          'status_color' => $status_color,
          'remark' => $this->input->post('remark'),
          'assured_return' => $assuredReturn,
          'new_launch' => $newLaunched,
          'meta_title' => $this->input->post('meta_title'),
          'meta_keyword' => $this->input->post('meta_keyword'),
          'meta_description' => $this->input->post('meta_description'),
          'publish_date' => $publishDate
        );
       $updateddata = $this->Commanmodel->update_query('property',$post_data,array('propertyToken' => $propertyToken));
       if($updateddata)
       {
          $this->session->set_flashdata('created', 'Your Propert has been posted successfully!');
          redirect(base_url('admin/property'));
       }
       else
       {
            $this->session->set_flashdata('failed', 'This Property is not saved!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/property-listing-apply',$data);
            $this->load->view('admin/footer');
       }
    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit Property is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/property-listing-apply',$data);
            $this->load->view('admin/footer');
        }
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function word_value_show()
    {
       if(!empty($this->input->post('value')))
       {
          $value = $this->input->post('value');
          $returnData = $this->Commanmodel->getIndianCurrency($value);
          echo '<p>'.$returnData.'</p>';   
       }
    }


    public function infrastructure_list($areaToken)
    {
    $countCheck = $this->Commanmodel->checkCount('area_infrascructure',array('areaToken' => $areaToken)); 
    if($countCheck)
    {
    $data = array(
    'areaToken' => $areaToken
    );
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/infrastructure-list',$data);
        $this->load->view('admin/footer');
    }
    else
    {
       redirect(base_url('admin/')); 
    }
    }
    
    
    public function infrastructure_process($areaToken)
    {
        if($this->session->userdata('admin_id'))
        {
            
            $countCheck = $this->Commanmodel->checkCount('area_infrascructure',array('areaToken' => $areaToken)); 
    if($countCheck)
    {    
            
            
        $data = array(
        'areaToken' => $areaToken
        );
        if($this->input->post('saveName'))
        {
        $this->form_validation->set_rules('infrastructure_id', 'infrastructure', 'required',array('required'  =>  'Please select value'));
        $this->form_validation->set_rules('name', 'Name', 'required',array('required'  =>  'Please enter name'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
      if ($this->form_validation->run() == FALSE)
      {    
      $this->load->view('admin/head');
      $this->load->view('admin/sidebar');
      $this->load->view('admin/infrastructure-list',$data);
      $this->load->view('admin/footer');
      }
    else
    {
        $post_data = array(
          'areaToken' => $areaToken,
          'infrastructure_id' => $this->input->post('infrastructure_id'),
          'name' => $this->input->post('name')
        );
       $updateddata = $this->Commanmodel->insert_query('area_infrascructure_name',$post_data);
       if($updateddata)
       {
          $this->session->set_flashdata('created', 'Your Name has been saved successfully!');
          redirect(base_url('admin/infrastructure_list/'.$areaToken.''));
       }
       else
       {
            $this->session->set_flashdata('failed', 'This Name is not saved!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/infrastructure-list',$data);
            $this->load->view('admin/footer');
       }
    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit Name is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/infrastructure-list',$data);
            $this->load->view('admin/footer');
        }
        }
        else
        {
            redirect(base_url('sectors'));
        }
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function delete_infrastructure_name($infrastructure_id,$areaToken)
    {
     $deleteClient = $this->Commanmodel->delete_query('area_infrascructure_name',array('id' =>$infrastructure_id,'areaToken' => $areaToken));
     if($deleteClient)
     {
      $this->session->set_flashdata('created', 'This Name is delete.');
      redirect(base_url('admin/infrastructure_list/'.$areaToken.''));
     }
     else
     {
      $this->session->set_flashdata('failed', 'This Name is not delete!');
      redirect(base_url('admin/infrastructure_list/'.$areaToken.'')); 
     }
    }


    public function areareview(){
        if($this->session->userdata('admin_id'))
        {     
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/areareview');
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    //  enquiry list page Load After Login Account
  public function list_areareview_ajax()
  {
        if($this->session->userdata('admin_id'))
        {
        $allReview=$this->Areareviewmodel->get_datatables();
        $data = array();
        $no = $_POST['start'];
        $ia=1;
        foreach ($allReview as $allReviewView) {
           $areaDetail = $this->Commanmodel->get_single_query('city',array('city_id' => $allReviewView->author_property_id));

           $rating = $this->Commanmodel->locality_rating($allReviewView->author_property_id,$allReviewView->id);
           $status = '<a href="javascript:void(0);" class="btn btn-'.$allReviewView->status_color.' btn-xs">'.$allReviewView->status.'</a>';
            $action = '<br><a href="'.base_url('admin/areaviewreview/'.$allReviewView->id.'').'" class="btn btn-info btn-xs">View More</a>';
            $no++;
            $row = array();
            $row[] = $ia;
            $row[] = '<div class="rating-box"><div class="detail-list-rating mr-0">'.$rating.'</div></div><a href="javascript:void(0);" class="btn btn-'.$allReviewView->status_color.' btn-xs">'.$allReviewView->author_date.'</a>';
            $row[] = $allReviewView->author_name.'<br>'.$allReviewView->author_email;
            $row[] = $areaDetail->city_name;
            $row[] = $status.$action;
            $data[] = $row;
        $ia++;    
        }
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->Areareviewmodel->count_all(),
                        "recordsFiltered" => $this->Areareviewmodel->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }
    else
    {
    redirect(base_url('admin/'));
    }
  }


  public function areaviewreview($enquiry_id)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['enquiry'] = $this->Commanmodel->get_single_query('area_review',array('id' => $enquiry_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/single-area-review',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


public function area_review_process($enquiry_id)
    {
        $data['enquiry'] = $this->Commanmodel->get_single_query('area_review',array('id' => $enquiry_id));
        if($this->session->userdata('admin_id'))
        {
        if($this->input->post('SubmitReview'))
        {
        $this->form_validation->set_rules('property_status', 'status', 'required',array('required'  =>  'Please select status'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/single-area-review',$data);
            $this->load->view('admin/footer');
                }
                else
                {
                  $status = $this->input->post('property_status');
    if($status=='Under Approved')
    {
       $status_color = 'danger'; 
    }
    elseif($status=='Approved')
    {
       $status_color = 'success'; 
    }
    else
    {
      $status_color = 'danger';  
    }
    
                    
                    
    $post_data = array(  
    'status' => $this->input->post('property_status'),
    'status_color' => $status_color,
    'remark' => $this->input->post('contact_client_conversation')
    );
    $updated = $this->Commanmodel->update_query('area_review',$post_data,array('id' => $enquiry_id));  
    if($updated)
    {
    $this->session->set_flashdata('created', 'This Area review status has been updated.');
    redirect(base_url('admin/areareview'));
    }
    else
    {
            $this->session->set_flashdata('failed', 'Sorry, This Area review status has not been saved. Please try again?');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/single-area-review',$data);
            $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/single-area-review',$data);
            $this->load->view('admin/footer');
        }



        }
        else
        {
            redirect(base_url('admin/'));
        }
    }





public function areaenquiry(){
        if($this->session->userdata('admin_id'))
        {    
        $data = array('status' => '1','message' => 'Sector/Area'); 
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/area-enquiry',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    //  enquiry list page Load After Login Account
  public function list_areaenquiry_ajax()
  {
        if($this->session->userdata('admin_id'))
        {
        $allEnquiry=$this->Areaenquirymodel->get_datatables();
        $data = array();
        $no = $_POST['start'];
        $ia=1;
        foreach ($allEnquiry as $allEnquiryview) {
           $areaDetail = $this->Commanmodel->get_single_query('city',array('city_id' => $allEnquiryview->property_id));
            $action = '<br><a href="'.base_url('admin/areaviewenquiry/'.$allEnquiryview->id.'').'" class="btn btn-info btn-xs">View Info</a>
           ';
            $no++;
            $row = array();
            $row[] = $ia;
            $row[] = '<a href="javascript:void(0);" class="btn btn-primary btn-xs">'.$allEnquiryview->date.'</a>';
            $row[] = $allEnquiryview->name.'<br>'.$allEnquiryview->mobile.'<br>'.$allEnquiryview->email;
            $row[] = $areaDetail->city_name;
            $row[] = $action;
            $data[] = $row;
        $ia++;    
        }
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->Areaenquirymodel->count_all(),
                        "recordsFiltered" => $this->Areaenquirymodel->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }
    else
    {
    redirect(base_url('admin/'));
    }
  }





  public function areaviewenquiry($enquiry_id)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['enquiry'] = $this->Commanmodel->get_single_query('area_enquiry',array('id' => $enquiry_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/single-area-enquiry',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }



    public function banks()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['banks'] = $this->Commanmodel->get_multiple_query_order_by('banks','id','DESC');    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/banks',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function banks_process()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['banks'] = $this->Commanmodel->get_multiple_query_order_by('banks','id','DESC');
        if($this->input->post('saveCity'))
        {
        $this->form_validation->set_rules('bank', 'Bank', 'required|trim|is_unique[banks.name]',
          array(
            'required'  =>  'Please enter bank name',
            'is_unique'  =>  'This bank already exists'
          )
        );
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/banks',$data);
            $this->load->view('admin/footer');
                }
                else
                {
          
          if($_FILES['bank_image']['name']!=""){
          $config['upload_path']          = 'assets/upload/category/';
          $config['allowed_types']        = 'gif|jpg|png|jpeg';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('bank_image')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $bank_image=$upload_data['file_name'];
          }
          }
          else{
          $bank_image = '';
          }
            
    $post_data = array(
    'name ' => $this->input->post('bank'),
    'image' => $bank_image
    ); 
    $inserted = $this->Commanmodel->insert_query('banks',$post_data); 
    if($inserted)
    {
    $this->session->set_flashdata('created', 'This Banks has been saved.');
    redirect(base_url('admin/banks'));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This Banks has not been saved. Please try again?');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/banks',$data);
            $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/banks',$data);
            $this->load->view('admin/footer');
        }
             

        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function delete_banks($bank_id)
    {
     $deleteClient = $this->Commanmodel->delete_query('banks',array('id' =>$bank_id));
     if($deleteClient)
     {
      $this->session->set_flashdata('created', 'This Banks has been deleted.');
      redirect(base_url('admin/banks'));
     }
     else
     {
      $this->session->set_flashdata('failed', 'This Bank is not delete!');
      redirect(base_url('admin/banks')); 
     }
    }


public function property_linking()
    {
        if($this->session->userdata('admin_id'))
        {
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/property-linking');
        $this->load->view('admin/footer'); 
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function property_linking_process()
    {
        if($this->session->userdata('admin_id'))
        {
        if($this->input->post('savePropertyLinking'))
        {
        $this->form_validation->set_rules('property', 'property', 'required',
          array(
            'required'  =>  'Please select property'
          )
        );
        $this->form_validation->set_rules('heading_text', 'heading text', 'required',
          array(
            'required'  =>  'Please enter heading text'
          )
        );
        $this->form_validation->set_rules('heading_url_link', 'heading url link', 'required',
          array(
            'required'  =>  'Please enter heading url link'
          )
        );
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/property-linking',$data);
            $this->load->view('admin/footer');
                }
                else
                {
    $post_data = array(
    'property' => $this->input->post('property'),
    'heading_text' => $this->input->post('heading_text'),
    'heading_url_link' => $this->input->post('heading_url_link')
    ); 
    $inserted = $this->Commanmodel->insert_query('property_linking',$post_data); 
    if($inserted)
    {
    $this->session->set_flashdata('created', 'This Link has been saved.');
    redirect(base_url('admin/property_linking'));
    }
    else
    {
    $this->session->set_flashdata('failed', 'Sorry, This Link has not been saved. Please try again?');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/property-linking',$data);
            $this->load->view('admin/footer');
    }


    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Submit process is not working!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/property-linking',$data);
            $this->load->view('admin/footer');
        }
             

        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


 public function home_banner()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['bannerView'] = $this->Commanmodel->get_multiple_query_order_by('home_banner','banner_id','DESC');    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/banner',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function home_banner_process()
    {
        if($this->session->userdata('admin_id'))
        {
        $data['bannerView'] = $this->Commanmodel->get_multiple_query_order_by('home_banner','banner_id','DESC');
        if($this->input->post('upload_banner'))
        {
            if($_FILES['home_banner']['name']!=""){
                $config['upload_path']          = 'assets/images/';
                $config['allowed_types']        = 'gif|jpg|png|jpeg';
                $config['max_size']             = 0;
                $new_fileName = time().$_FILES["home_banner"]['name'];
                $config['file_name'] = time().$new_fileName;
                $config['remove_spaces'] = TRUE;
                $config['encrypt_name'] = TRUE;
                $this->load->library('upload',$config);
                $this->load->initialize('upload', $config);
                if(!$this->upload->do_upload('home_banner')){
                    $error = array('error' => $this->upload->display_errors());
                }
                else{
                    $upload_data=$this->upload->data();
                    $home_banner=$upload_data['file_name'];
                }
            }
            else{
            $this->session->set_flashdata('failed', 'Please choose banner image!');    
            $this->load->view('admin/head');
            $this->load->view('admin/sidebar');
            $this->load->view('admin/banner',$data);
            $this->load->view('admin/footer');
            }
        $post_data = array(
        'banner_image' => $home_banner,
        'heading' => $this->input->post('banner_heading'),
        'description' => $this->input->post('description')
        );
        $inserted = $this->Commanmodel->insert_query('home_banner',$post_data); 
                   if($inserted)
                   {
                    $this->session->set_flashdata('created', 'This Home Banner has been uploaded successfully.');
                    redirect(base_url('admin/home_banner'));
                   }
                   else
                   {
            $this->session->set_flashdata('failed', 'Sorry, This Home Banner has not been uploaded.');      
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/banner',$data);
        $this->load->view('admin/footer');
                   }


            }
        else
        {
        $this->session->set_flashdata('failed', 'Submit process is not working!');      
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/banner',$data);
        $this->load->view('admin/footer');
        }  

        }
        else
        {
            redirect(base_url('admin/'));
        }
    }


    public function edit_home_banner($banner_id)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['bannerView'] = $this->Commanmodel->get_single_query('home_banner',array('banner_id' => $banner_id));    
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-home-banner',$data);
        $this->load->view('admin/footer');
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }

    public function edit_home_banner_process($banner_id)
    {
        if($this->session->userdata('admin_id'))
        {
        $data['bannerView'] = $this->Commanmodel->get_single_query('home_banner',array('banner_id' => $banner_id)); 
        if($this->input->post('EditBanner'))
        {
            if($_FILES['banner_image']['name']!=""){
                $config['upload_path']          = 'assets/images/';
                $config['allowed_types']        = 'gif|jpg|png|jpeg';
                $config['max_size']             = 0;
                $new_fileName = time().$_FILES["banner_image"]['name'];
                $config['file_name'] = time().$new_fileName;
                $config['remove_spaces'] = TRUE;
                $config['encrypt_name'] = TRUE;
                $this->load->library('upload',$config);
                $this->load->initialize('upload', $config);
                if(!$this->upload->do_upload('banner_image')){
                    $error = array('error' => $this->upload->display_errors());
                }
                else{
                    $upload_data=$this->upload->data();
                    $home_banner=$upload_data['file_name'];
                }
            }
            else{
              $home_banner = $this->input->post('banner_image_old');
            }
        if($this->input->post('banner_status')=='Active')
        {
          $banner_status_color = 'success';
        }
        if($this->input->post('banner_status')=='Inactive')
        {
          $banner_status_color = 'danger';
        }
        $post_data = array(
        'banner_image' => $home_banner,
        'heading' => $this->input->post('banner_heading'),
        'description' => $this->input->post('description'),
        'banner_status' => $this->input->post('banner_status'),
        'banner_status_color' => $banner_status_color 
        );
        $updated = $this->Commanmodel->update_query('home_banner',$post_data,array('banner_id' => $banner_id)); 
        if($updated)
        {
        $this->session->set_flashdata('created', 'This banner has been updated.');
        redirect(base_url('admin/home_banner'));
        }
        else
        {
        $this->session->set_flashdata('failed', 'Sorry, This banner has not been uploaded.');     
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-home-banner',$data);
        $this->load->view('admin/footer');
        }
            }
        else
        {
        $this->session->set_flashdata('failed', 'Submit process is not working!');  
        $this->load->view('admin/head');
        $this->load->view('admin/sidebar');
        $this->load->view('admin/edit-home-banner',$data);
        $this->load->view('admin/footer');
        }  
        }
        else
        {
            redirect(base_url('admin/'));
        }
    }




    public function delete_home_banner($banner_id)
    {
     $deleteClient = $this->Commanmodel->delete_query('home_banner',array('banner_id' =>$banner_id));
     if($deleteClient)
     {
      $this->session->set_flashdata('created', 'This Home Banner is delete.');
      redirect(base_url('admin/home_banner'));
     }
     else
     {
      $this->session->set_flashdata('failed', 'This Home Banner is not delete!');
      redirect(base_url('admin/home_banner')); 
     }
    
    }






}    


