<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        $this->load->library('form_validation');
        $this->load->model('Commanmodel');
        $this->load->model('Dashboardmodel');
        if($this->session->userdata('logged_in')!=TRUE)
        {
          redirect(base_url());
        }

    }

    public function logout()
    {  
        $this->session->unset_userdata('logged_in');
        $this->session->set_flashdata('flash_message', '<div class="alert alert-danger alert-dismissable">Logged Out Successfully</div>');  
        redirect(base_url('account-logout'));  
    }


    public function index()
    {
    $data = array(
    'title' => "My Account", 
    'keyword' => "",
    'description' => ""
    );
        $this->load->view('user/header',$data);
        $this->load->view('user/dashboard');
        $this->load->view('user/footer');
    }

    public function profile()
    {
    $ProfileShow = $this->Commanmodel->dashboard();    
    $data = array(
    'title' => "Update Account Profile", 
    'keyword' => "",
    'description' => "",
    'ProfileShow' => $ProfileShow 
    );
        $this->load->view('user/header',$data);
        $this->load->view('user/edit-profile',$data);
        $this->load->view('user/footer');
    }

    public function edit_profile_process()
    {
    $ProfileShow = $this->Commanmodel->dashboard();
        if($this->input->post('update_profile'))
        {
        $this->form_validation->set_rules('user_name', 'Full Name', 'required',
            array(
                'required'  =>  'Please enter full name!',
             )
             );
            $this->form_validation->set_rules('user_mobile', 'User Mobile', 'required|callback_mobile_user_match[user_mobile]',
            array(
                'required'  =>  'Please enter mobile number!',
             )
             );         
            $this->form_validation->set_rules('user_email', 'User Email', 'required|valid_email|callback_email_user_match[user_email]',
            array(
                'required'  =>  'Please enter email address!',
                'valid_email' => 'Please enter valid email!',
             )
             ); 
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {
                  $data = array(
                  'title' => "Update Account", 
                  'keyword' => "",
                  'description' => "",
                  'ProfileShow' => $ProfileShow 
                  );
                  $this->load->view('user/header',$data);
                  $this->load->view('user/edit-profile',$data);
                  $this->load->view('user/footer');
                }
                else
                {
                    $post_data = array(
                    'name' => $this->input->post('user_name'),
                    'mobile' => $this->input->post('user_mobile'),
                    'email' => $this->input->post('user_email'),
                    'address' => $this->input->post('user_address'),
                    'about' => $this->input->post('user_about')
                    );
                    $update_by = array(
                    'id' => $ProfileShow->id,
                    );
                   $createdAccount = $this->Commanmodel->update_query('users',$post_data,$update_by); 
                   if($createdAccount)
                   {
                    $this->session->set_flashdata('flash_message_profile', '<div class="alert alert-success" role="alert">Your Profile has been updated successfully.</div>');
                    redirect('dashboard/profile');
                   }
                   else
                   {
                    $this->session->set_flashdata('flash_message_profile', '<div class="alert alert-danger" role="alert">Your Profile has not been updated.</div>');
                    $data = array(
                      'title' => "Update Account Profile", 
                      'keyword' => "Account Profile",
                      'description' => "Account Profile",
                      'ProfileShow' => $ProfileShow 
                      );
                  $this->load->view('user/header',$data);
                  $this->load->view('user/edit-profile',$data);
                  $this->load->view('user/footer');
                   }


                }


        }
        else
        {    
    $data = array(
    'title' => "Update Account Profile", 
    'keyword' => "Account Profile",
    'description' => "Account Profile",
    'ProfileShow' => $ProfileShow 
    );
                  $this->load->view('user/header',$data);
                  $this->load->view('user/edit-profile',$data);
                  $this->load->view('user/footer');
        }
    }




     public function change_password_process()
    {
       $ProfileShow = $this->Commanmodel->dashboard();
       
        if($this->input->post('ChangePassword'))
        {
              
        $this->form_validation->set_rules('current_password', 'current password', 'required',
            array(
                'required'  =>  'Please enter current password!',
             )
             );

        $this->form_validation->set_rules('new_password', 'new password', 'required',
            array(
                'required'  =>  'Please enter new password!',
             )
             );

        $this->form_validation->set_rules('confirm_password', 'confirm password', 'required|matches[new_password]',
            array(
                'required'  =>  'Please enter confirm password!',
                'matches'  =>  'New Password and Confirm password should be same!'
             )
             );

        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {
                  $data = array(
                  'title' => "Change Password", 
                  'keyword' => "Change Password",
                  'description' => "Change Password",
                  'ProfileShow' => $ProfileShow 
                  );
                  $this->load->view('user/header',$data);
                  $this->load->view('user/edit-profile',$data);
                  $this->load->view('user/footer');
                }
                else
                { 
                    $current_password = $this->input->post('current_password');
                    $check_password = $this->Commanmodel->check_password($current_password,$ProfileShow->id); 
                    if($check_password)
                    {
                    $post_data = array(
                    'password' => md5($this->input->post('new_password')),
                    'show_password' => $this->input->post('new_password')
                    );
                    $update_by = array(
                    'id' => $ProfileShow->id,
                    );
                   $createdAccount = $this->Commanmodel->update_query('users',$post_data,$update_by); 
                   if($createdAccount)
                   {
                    $this->session->set_flashdata('flash_message_profile', 'Your password has been changed successfully.');
                    redirect('dashboard/profile');
                   }
                   else
                   {
                    $this->session->set_flashdata('flash_message_profile', 'Sorry, Your password has not been changed. Please try again?');
                      $data = array(
                      'title' => "Change Password", 
                      'keyword' => "Change Password",
                      'description' => "Change Password",
                      'ProfileShow' => $ProfileShow 
                      );
                      $this->load->view('user/header',$data);
                      $this->load->view('user/edit-profile',$data);
                      $this->load->view('user/footer');
                   }


              }
              else
              {
                      $this->session->set_flashdata('flash_message_profile', 'Your current password is not match!');
                      $data = array(
                      'title' => "Change Password", 
                      'keyword' => "Change Password",
                      'description' => "Change Password",
                      'ProfileShow' => $ProfileShow 
                      );
                      $this->load->view('user/header',$data);
                      $this->load->view('user/edit-profile',$data);
                      $this->load->view('user/footer');
              }



                }




        }
        else
        {    
    $data = array(
    'title' => "Change Password Profile", 
    'keyword' => "Change Password Profile",
    'description' => "Change Password Profile",
    'ProfileShow' => $ProfileShow 
    );
        $this->load->view('user/header',$data);
        $this->load->view('user/edit-profile',$data);
        $this->load->view('user/footer');
        }
    }



    
    public function user_upload_image()
    {
         $loginID = $this->session->userdata('user_id');
         if($_FILES['user_image']['name']!="")
         {
                $config['upload_path']          = 'assets/user/';
                $config['allowed_types']        = 'gif|jpg|png|jpeg';
                $config['max_size']             = 0;
                $this->load->library('upload',$config);
                if(!$this->upload->do_upload('user_image')){
                    $error = array('error' => $this->upload->display_errors());
                }
                else{
                    $upload_data=$this->upload->data();
                    $user_image=$upload_data['file_name'];
                }
                $post_data = array(
                'user_photo' => $user_image
                );
                $updateby_data = array(
                'account_id' => $loginID
                );

                   $inserted = $this->Commanmodel->update_query('user_account',$post_data,$updateby_data); 
                   if($inserted)
                   {
                      echo "updated";
                   }
                   else
                   {
                     echo "Failed"; 
                   }
          }
          else
          {
            echo "Failed";
          }
    }


public function word_value_show()
    {
       if(!empty($this->input->post('value')))
       {
          $value = $this->input->post('value');
          $returnData = $this->Commanmodel->getIndianCurrency($value);
          echo '<p>'.$returnData.'</p>';   
       }
    }

        public function mobile_user_match(){
        $loginId = $this->session->userdata('user_id');
        $mobile_number   =   $this->input->post('user_mobile');
        $mobileCondition= $this->Commanmodel->user_mobile_query_count('users',$loginId,$mobile_number);
        if($mobileCondition)
        {
        $this->form_validation->set_message('mobile_user_match', 'Already exists ['.$mobile_number.']');
        return false;
        }
        else
        { 
           return true;
        }
        }
        
        
        public function email_user_match(){
        $loginId = $this->session->userdata('user_id');
        $email   =   $this->input->post('user_email');
        $emailCondition= $this->Commanmodel->user_email_query_count('users',$loginId,$email);
        if($emailCondition)
        {
        $this->form_validation->set_message('email_user_match', 'Already exists ['.$email.']');
        return false;
        }
        else
        { 
           return true;
        }
        }



        public function get_category()
        {
         if(!empty($this->input->post('category_id')))
         {
         //$categoryToken = join("','", $this->input->post('category_id'));
         $categoryToken = $this->input->post('category_id');
         $getCategory = $this->Commanmodel->all_multiple_childcategory(" category 
         WHERE parent_id IN ('".$categoryToken."') AND status='Active' order by id DESC");
         ?>
        <label for="exampleInputEmail1">Child Category*</label>
        <select class="form-control form_control" name="childcategory" placeholder="Choose" onchange="console.log($(this).children(':selected').length)">
        <?php
        foreach ($getCategory as $getCategory) 
         {
           ?>
            <option value="<?php echo $getCategory->categoryToken; ?>"><?php echo $getCategory->category; ?></option>
           <?php
         }
         ?>
        </select>
        <script type="text/javascript">
        $(document).ready(function () {
        window.asd = $('.SlectBox').SumoSelect({ csvDispCount: 6 });
        window.test = $('.testsel').SumoSelect({okCancelInMulti:true });
        window.testSelAll = $('.testSelAll').SumoSelect({okCancelInMulti:true, selectAll:true });
        window.testSelAlld = $('.SlectBox-grp').SumoSelect({okCancelInMulti:true, selectAll:true });
        window.testSelAll2 = $('.testSelAll2').SumoSelect({selectAll:true });
        window.Search = $('.search-box').SumoSelect({ csvDispCount: 3, search: true, searchText:'Enter here.' });
        window.searchSelAll = $('.search-box-sel-all').SumoSelect({ csvDispCount: 3, selectAll:true, search: true, searchText:'Enter here.', okCancelInMulti:true });
        window.searchSelAll = $('.search-box-open-up').SumoSelect({ csvDispCount: 3, selectAll:true, search: true, searchText:'Enter here.', up:true });
        window.groups_eg_g = $('.groups_eg_g').SumoSelect({selectAll:true, search:true });
        });
        </script>
         <?php
         }
         else
         {
             ?>
                    <label for="exampleInputEmail1">Child Category*</label>
                    <select class="form-control" required name="childcategory" placeholder="Choose" onchange="console.log($(this).children(':selected').length)">
                    </select>
                    <?php echo form_error('childcategory'); ?>
                            <script type="text/javascript">
        $(document).ready(function () {
        window.asd = $('.SlectBox').SumoSelect({ csvDispCount: 6 });
        window.test = $('.testsel').SumoSelect({okCancelInMulti:true });
        window.testSelAll = $('.testSelAll').SumoSelect({okCancelInMulti:true, selectAll:true });
        window.testSelAlld = $('.SlectBox-grp').SumoSelect({okCancelInMulti:true, selectAll:true });
        window.testSelAll2 = $('.testSelAll2').SumoSelect({selectAll:true });
        window.Search = $('.search-box').SumoSelect({ csvDispCount: 3, search: true, searchText:'Enter here.' });
        window.searchSelAll = $('.search-box-sel-all').SumoSelect({ csvDispCount: 3, selectAll:true, search: true, searchText:'Enter here.', okCancelInMulti:true });
        window.searchSelAll = $('.search-box-open-up').SumoSelect({ csvDispCount: 3, selectAll:true, search: true, searchText:'Enter here.', up:true });
        window.groups_eg_g = $('.groups_eg_g').SumoSelect({selectAll:true, search:true });
        });
        </script>
             <?php
         }
    }



        public function get_area()
        {
         $city_id = $this->input->post('city_id');  
         $getArea = $this->Commanmodel->all_multiple_query_order_by('city',array('parent_id' => $city_id, 'status' => 'Active'),'city_name','ASC');
         ?>
          <option value="">Choose</option>
         <?php
         foreach ($getArea as $getArea) 
         {
           ?>
             <option value="<?php echo $getArea->city_id; ?>" data-area="<?php echo $getArea->city_name; ?>"><?php echo $getArea->city_name; ?></option>
           <?php
         }
        }
        
        public function get_area_project()
        {
         $area_id = $this->input->post('area_id');  
         $getAreaProject = $this->Commanmodel->all_multiple_query_order_by('property',array('area' => $area_id, 'post_type' => 'Project', 'status' => 'Approved'),'title','ASC');
         ?>
          <option value="">Choose</option>
         <?php
         foreach ($getAreaProject as $getAreaProjectView) 
         {
           ?>
             <option value="<?php echo $getAreaProjectView->propertyToken; ?>"><?php echo $getAreaProjectView->title; ?></option>
           <?php
         }
        }


        public function create_listing()
        {
        $data = array(
        'title' => "New Create Listing", 
        'keyword' => "New Create Listing",
        'description' => "New Create Listing",
        );
        $this->load->view('user/header',$data);
        $this->load->view('user/create-listing');
        $this->load->view('user/footer');
        }


        public function create_listing_process()
        {
        if($this->input->post('CreateProperty'))
        {
        $this->form_validation->set_rules('property_title', 'Title', 'required',array(
          'required'  =>  'Please enter title'
        ));
        if (empty($this->input->post('category'))) {
           $this->form_validation->set_rules('category', 'Category', 'required',array('required' =>'Select at least one Category'));
        }
        if (empty($this->input->post('childcategory'))) {
           $this->form_validation->set_rules('childcategory', 'Child Category', 'required',array('required' =>'Select at least one Child category'));
        }
        $this->form_validation->set_rules('property_status', 'Property Status', 'required',array('required'  =>  'Please select Property Status'));
        $this->form_validation->set_rules('construction_status', 'Construction Status', 'required',array('required'  =>  'Please select Construction Status'));
        $this->form_validation->set_rules('locality', 'Locality', 'required',array('required'  =>  'Please select locality'));
        $this->form_validation->set_rules('area', 'Area', 'required',array('required'  =>  'Please select area'));
        $this->form_validation->set_rules('full_address', 'Full address', 'required',array('required'  =>  'Please enter full address'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
            $this->load->view('user/header');
            $this->load->view('user/create-listing');
            $this->load->view('user/footer');
                }
                else
                {
    $tokenID = $this->Commanmodel->generate_token_property();

          if($_FILES['primary_image']['name']!=""){
          $config['upload_path']          = 'assets/upload/property/';
          $config['allowed_types']        = '*';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('primary_image')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $primary_image=$upload_data['file_name'];
          }
          }
          else{
          $primary_image = '';
          }
    if($this->input->post('project_name')!='') 
    {
    $projectDeveloper = $this->Commanmodel->get_single_query('property',array('propertyToken' => $this->input->post('project_name')));
    $developer = $projectDeveloper->developer;
    }
    else
    {
      $developer ='';  
    }
    
          
    $title1 = strip_tags($this->input->post('property_title'));
    $title2 = strip_tags($this->input->post('property_status'));
    if($this->input->post('project_name')!='')
    {
      $projectName = $this->Commanmodel->get_single_query('property',array('propertyToken' => $this->input->post('project_name')));
      $projectNameShow = $projectName->title; 
    }
    else
    {
       $projectNameShow = ''; 
    }
    if($this->input->post('area')!='')
    {
      $areaName = $this->Commanmodel->get_single_query('city',array('city_id' => $this->input->post('area')));
      $areaNameShow = $areaName->city_name; 
    }
    else
    {
       $areaNameShow = ''; 
    }
    $title3 = strip_tags($projectNameShow);
    $title4 = strip_tags($areaNameShow);
    $title = $title1.' for '.$title2.' in '.$title3.' '.$title4;
    $titleURL = strtolower(url_title($title));      
    $loginId = $this->session->userdata('user_id');
    $post_data = array(
    'post_type' => 'Listing',
    'propertyToken' => $tokenID,
    'title' => $this->input->post('property_title'),
    'primary_image' => $primary_image,
    'primary_image_alt' => $this->input->post('property_title'),
    'url_slug' => $titleURL,    
    'category' => $this->input->post('category'),
    'childcategory' => $this->input->post('childcategory'),
    'property_status' => $this->input->post('property_status'),
    'construction_status' => $this->input->post('construction_status'),
    'locality' => $this->input->post('locality'),
    'area' => $this->input->post('area'),
    'project_name' => $this->input->post('project_name'),
    'developer' => $developer,
    'full_address' => $this->input->post('full_address'),
    'post_by' => $loginId
    );
    $inserted = $this->Commanmodel->insert_query('property',$post_data); 
    if($inserted)
    {
        redirect(base_url('dashboard/detail_property/'.$tokenID.''));
    }
    else
    {
    $this->session->set_flashdata('flash_message_post', 'Sorry, This Property has not been created. Please try again?');    
            $this->load->view('user/header');
            $this->load->view('user/create-listing');
            $this->load->view('user/footer');
    }
    }
        }
        else
        {
            $this->session->set_flashdata('flash_message_post', 'Save & Continue process is not working!');    
            $this->load->view('user/header');
            $this->load->view('user/create-listing');
            $this->load->view('user/footer');
        }
    }

   
   
    public function edit_listing($propertyToken)
    {
    $loginId = $this->session->userdata('user_id');    
    $countCheck = $this->Commanmodel->checkCount('property',array('propertyToken' => $propertyToken, 'post_by' => $loginId)); 
    if($countCheck)
    {
    $data = array(
    'propertyToken' => $propertyToken
    );
        $this->load->view('user/header');
        $this->load->view('user/edit-listing',$data);
        $this->load->view('user/footer');
    }
    else
    {
       redirect(base_url('dashboard/'));
    }
    }


    public function edit_listing_process($propertyToken)
    {
        $loginId = $this->session->userdata('user_id');
        $data = array(
        'propertyToken' => $propertyToken
        );
        if($this->input->post('EditProperty'))
        {
        $this->form_validation->set_rules('property_title', 'Title', 'required',array(
          'required'  =>  'Please enter title'
        ));
        if (empty($this->input->post('category'))) {
           $this->form_validation->set_rules('category', 'Category', 'required',array('required' =>'Select at least one category'));
        }
        if (empty($this->input->post('childcategory'))) {
           $this->form_validation->set_rules('childcategory', 'Child Category', 'required',array('required' =>'Select at least one Child category'));
        }  
        $this->form_validation->set_rules('property_status', 'Property Status', 'required',array('required'  =>  'Please select Property Status'));
        $this->form_validation->set_rules('construction_status', 'Construction Status', 'required',array('required'  =>  'Please select Construction Status'));
        $this->form_validation->set_rules('locality', 'Locality', 'required',array('required'  =>  'Please select locality'));
        $this->form_validation->set_rules('area', 'Area', 'required',array('required'  =>  'Please select area'));
        $this->form_validation->set_rules('full_address', 'Full address', 'required',array('required'  =>  'Please enter full address'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {    
        $this->load->view('user/header');
        $this->load->view('user/edit-listing',$data);
        $this->load->view('user/footer');
                }
                else
                {  

          if($_FILES['primary_image']['name']!=""){
          $config['upload_path']          = 'assets/upload/property/';
          $config['allowed_types']        = '*';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('primary_image')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $primary_image=$upload_data['file_name'];
          }
          }
          else{
          $primary_image = $this->input->post('primary_image_old');
          }
    if($this->input->post('project_name')!='') 
    {
    $projectDeveloper = $this->Commanmodel->get_single_query('property',array('propertyToken' => $this->input->post('project_name')));
    $developer = $projectDeveloper->developer;
    }
    else
    {
      $developer ='';  
    }
    $post_data = array(
    'title' => $this->input->post('property_title'),
    'primary_image' => $primary_image,
    'category' => $this->input->post('category'),
    'childcategory' => $this->input->post('childcategory'),
    'property_status' => $this->input->post('property_status'),
    'construction_status' => $this->input->post('construction_status'),
    'locality' => $this->input->post('locality'),
    'area' => $this->input->post('area'),
    'project_name' => $this->input->post('project_name'),
    'developer' => $developer,
    'full_address' => $this->input->post('full_address'),
    'status' => 'Draft',
    'status_color' => 'warning'
    );
    $updated = $this->Commanmodel->update_query('property',$post_data,array('propertyToken' => $propertyToken,'post_by' => $loginId)); 
    if($updated)
    {
        redirect(base_url('dashboard/detail_property/'.$propertyToken.''));
    }
    else
    {
        $this->session->set_flashdata('failed', 'Sorry, This Property has not been updated. Please try again?');    
        $this->load->view('user/header');
        $this->load->view('user/edit-listing',$data);
        $this->load->view('user/footer');
    }
    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Save & Continue process is not working!');    
            $this->load->view('user/header');
            $this->load->view('user/edit-listing',$data);
            $this->load->view('user/footer');
        }
    } 
   
   
   
    public function detail_property($propertyToken)
    {
    $loginId = $this->session->userdata('user_id');    
    $countCheck = $this->Commanmodel->checkCount('property',array('propertyToken' => $propertyToken,'post_by' => $loginId)); 
    if($countCheck)
    {
    $data = array(
    'propertyToken' => $propertyToken
    );
        $this->load->view('user/header');
        $this->load->view('user/property-detail',$data);
        $this->load->view('user/footer');
    }
    else
    {
       redirect(base_url('dashboard/')); 
    }
    }
    

    public function detail_property_process($propertyToken)
    {
        $loginId = $this->session->userdata('user_id');     
        $data = array(
        'propertyToken' => $propertyToken
        );
        $propertyDetail = $this->Commanmodel->get_single_query('property',array('propertyToken' => $propertyToken));
        if($this->input->post('DetailSave'))
        {
          $this->form_validation->set_rules('property_token', 'property_token', 'required',array('required'  =>  'Property token invalid'));
          $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
          if ($this->form_validation->run() == FALSE)
          {    
            $this->load->view('user/header');
            $this->load->view('user/property-detail',$data);
            $this->load->view('user/footer');
          }
        else
        {
        $furnishing = $this->input->post('furnishing');
        if($furnishing=='Full Furnished')
        {
            $seats_workstation = $this->input->post('seats_workstation');
            $cabins = $this->input->post('cabins');
            $pentry_kitchen = $this->input->post('pentry_kitchen');
            $reception = $this->input->post('reception');
            $server_room = $this->input->post('server_room');
            $conference_room = $this->input->post('conference_room');
            $furnishing_other = $this->input->post('furnishing_other');
        }
        else
        {
            $seats_workstation = '';
            $cabins = '';
            $pentry_kitchen = '';
            $reception = '';
            $server_room = '';
            $conference_room = '';
            $furnishing_other = ''; 
        }
        
        
        if($propertyDetail->property_status=='Resell')
        {
        $property_already_lease = $this->input->post('property_already_lease');
        if($property_already_lease=='Yes')
        {
            $rental_value_amount = $this->input->post('rental_value_amount');
            $security_deposit = $this->input->post('security_deposit');
            $lock_in_period = $this->input->post('lock_in_period');
            $rented_to_home = $this->input->post('rented_to_home');
            $lease_tenure = $this->input->post('lease_tenure');
            $lease_escalation = $this->input->post('lease_escalation');
        }
        else
        {
            $rental_value_amount = '';
            $security_deposit = '';
            $lock_in_period = '';
            $rented_to_home = '';
            $lease_tenure = '';
            $lease_escalation = '';
        }
        }
        else
        {
            $rental_value_amount = '';
            $security_deposit = $this->input->post('security_deposit');
            $lock_in_period = $this->input->post('lock_in_period');
            $rented_to_home = $this->input->post('rented_to_home');
            $lease_tenure = $this->input->post('lease_tenure'); 
            $lease_escalation = $this->input->post('lease_escalation');
        }
            
        $post_data = array(
         'rera_no' => $this->input->post('rera_no'),
         'grade_of_buildings' => $this->input->post('grade_of_buildings'),
         'super_area' => $this->input->post('super_area'),
         'carpet_area' => $this->input->post('carpet_area'),
         'loading_in' => $this->input->post('loading_in'),
         'floor_out' => $this->input->post('floor_out'),
         'facing_direction' => $this->input->post('facing_direction'),
         'over_looking' => $this->input->post('over_looking'),
         'property_age' => $this->input->post('property_age'),
         'possession_date' => $this->input->post('possession_date'),
         'furnishing' => $this->input->post('furnishing'),
         'seats_workstation' => $seats_workstation,
         'cabins' => $cabins,
         'pentry_kitchen' => $pentry_kitchen,
         'reception' => $reception,
         'server_room' => $server_room,
         'conference_room' => $conference_room,
         'furnishing_other' => $furnishing_other,
         'property_height' => $this->input->post('property_height'),
         'security' => $this->input->post('security'),
         'water_availability' => $this->input->post('water_availability'),
         'power_backup' => $this->input->post('power_backup'),
         'pantry_cafeteria' => $this->input->post('pantry_cafeteria'),
         'pre_launched' => $this->input->post('property_already_lease'),
         'rental_value_amount' => $rental_value_amount,
         'security_deposit' => $security_deposit,
         'lock_in_period' => $lock_in_period,
         'rented_to_home' => $rented_to_home,
         'lease_tenure' => $lease_tenure,
         'lease_escalation' => $lease_escalation,
         'land_zone' => $this->input->post('land_zone'),
         'ideal_for' => $this->input->post('ideal_for'),
         'min_price' => $this->input->post('min_price'),
         'max_price' => $this->input->post('max_price'),
         'status' => 'Draft',
         'status_color' => 'warning'
        );
        $inserted = $this->Commanmodel->update_query('property',$post_data,array('propertyToken' => $propertyToken));
        if($inserted)
        {
            
          //  Property Faq Stop
          $locationnearby_rows = !empty($this->input->post('locationnearby'))?count($this->input->post('locationnearby')):0;
          if($locationnearby_rows > 0)
          {
          for($i=0 ; $i<$locationnearby_rows;$i++)
          {
                      $post_data = array(
                      'location' => $this->input->post('locationnearby')[$i],   
                      'propertyToken' => $propertyToken
                      );
                      $inserted = $this->Commanmodel->insert_query('property_location',$post_data);
          }
          }
          //  Property Faq Stop
            
            
          redirect(base_url('dashboard/document_property/'.$propertyToken.''));
        }
        else
        {
          redirect(base_url('dashboard/detail_property/'.$propertyToken.''));
        }
        }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Save & Continue process is not working!');    
            $this->load->view('user/header');
            $this->load->view('user/property-detail',$data);
            $this->load->view('user/footer');
        }
    }

    
    public function document_property($propertyToken)
    {
    $loginId = $this->session->userdata('user_id');    
    $countCheck = $this->Commanmodel->checkCount('property',array('propertyToken' => $propertyToken, 'post_by' => $loginId)); 
    if($countCheck)
    {
    $data = array(
    'propertyToken' => $propertyToken
    );
        $this->load->view('user/header');
        $this->load->view('user/property-document',$data);
        $this->load->view('user/footer');
    }
    else
    {
       redirect(base_url('dashboard')); 
    }
    }

    public function document_property_process($propertyToken)
    {
        $loginId = $this->session->userdata('user_id');
        $data = array(
        'propertyToken' => $propertyToken
        );
        if($this->input->post('EditDocument'))
        {
        $this->form_validation->set_rules('property_token', 'property_token', 'required',array('required'  =>  'Property token invalid'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
      if ($this->form_validation->run() == FALSE)
      {    
      $this->load->view('user/header');
      $this->load->view('user/property-document',$data);
      $this->load->view('user/footer');
      }
    else
    {

    $total_rows = !empty($this->input->post('features'))?count($this->input->post('features')):0;
    if($total_rows > 0)
    {
      $featured = implode(',',$this->input->post('features'));
    }
    else
    {
      $featured = '';
    }
    
    
    // $youtubeUrl = $this->input->post('youtube_url');
    // if($youtubeUrl!='')
    // {
    // $embadedCode = $this->Commanmodel->GetEmbadedUrl($youtubeUrl);
    // }
    // else
    // {
    // $embadedCode = '';
    // }
          




          if($_FILES['brochure_pdf']['name']!=""){
          $config['upload_path']          = 'assets/upload/property/';
          $config['allowed_types']        = 'pdf';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('brochure_pdf')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $brochure_pdf=$upload_data['file_name'];
          }
          }
          else{
          $brochure_pdf = $this->input->post('brochure_pdf_old');
          }

          

          if($_FILES['other_pdf']['name']!=""){
          $config['upload_path']          = 'assets/upload/property/';
          $config['allowed_types']        = 'pdf';
          $config['max_size']             = 0;
          $config['remove_spaces'] = TRUE;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload',$config);
          $this->load->initialize('upload', $config);
          if(!$this->upload->do_upload('other_pdf')){
          $error = array('error' => $this->upload->display_errors());
          }
          else{
          $upload_data=$this->upload->data();
          $other_pdf=$upload_data['file_name'];
          }
          }
          else{
          $other_pdf = $this->input->post('other_pdf_old');
          }
         $post_data = array(
         'brochure_pdf' => $brochure_pdf,
         'other_pdf' => $other_pdf,
         'other_name' => $this->input->post('other_name'),
         'description' => $this->input->post('description'),
         'features' => $featured,
        //  'youtube_url' => $youtubeUrl,
        //  'embaded_code' => $embadedCode,
         'status' => 'Draft',
         'status_color' => 'warning'
        );
       $updateddata = $this->Commanmodel->update_query('property',$post_data,array('propertyToken' => $propertyToken));
       if($updateddata)
       {
           
           
           //  Property Plan Image 
          $plan_image_rows = !empty($_FILES['plan_image']['name'])?count($_FILES['plan_image']['name']):0;
          if($plan_image_rows > 0)
          {
          for($i=0 ; $i<$plan_image_rows;$i++)
          {
                    $_FILES['file']['name']     = $_FILES['plan_image']['name'][$i]; 
                    $_FILES['file']['type']     = $_FILES['plan_image']['type'][$i]; 
                    $_FILES['file']['tmp_name'] = $_FILES['plan_image']['tmp_name'][$i]; 
                    $_FILES['file']['error']     = $_FILES['plan_image']['error'][$i]; 
                    $_FILES['file']['size']     = $_FILES['plan_image']['size'][$i]; 

                    // File upload configuration 
                    $uploadPath = 'assets/upload/property/'; 
                    $config['upload_path'] = $uploadPath; 
                    $config['allowed_types'] = '*'; 
                    $config['max_size'] = 0;
                    $config['remove_spaces'] = TRUE;
                    $config['encrypt_name'] = TRUE;
                    // Load and initialize upload library 
                    $this->load->library('upload', $config); 
                    $this->upload->initialize($config); 
                    // Upload file to server 
                    if($this->upload->do_upload('file')){ 
                        // Uploaded file data 
                        $fileData = $this->upload->data(); 
                        $plan_image = $fileData['file_name']; 
                    }
                    if(!empty($plan_image))
                    {
                      $post_data = array(
                      'plan_image_alt' => $this->input->post('planimagealt')[$i],
                      'plan_image' => $plan_image,    
                      'propertyToken' => $propertyToken
                      );
                      $inserted = $this->Commanmodel->insert_query('property_planimage',$post_data);
                    }
          }
          }
          //  Property Plan Image Stop





          //  Property Floor Plan
          $floorname_rows = !empty($this->input->post('floorname'))?count($this->input->post('floorname')):0;
          if($floorname_rows > 0)
          {
          for($i=0 ; $i<$floorname_rows;$i++)
          {
                    $_FILES['file']['name']     = $_FILES['floorimage']['name'][$i]; 
                    $_FILES['file']['type']     = $_FILES['floorimage']['type'][$i]; 
                    $_FILES['file']['tmp_name'] = $_FILES['floorimage']['tmp_name'][$i]; 
                    $_FILES['file']['error']     = $_FILES['floorimage']['error'][$i]; 
                    $_FILES['file']['size']     = $_FILES['floorimage']['size'][$i]; 

                    // File upload configuration 
                    $uploadPath = 'assets/upload/property/'; 
                    $config['upload_path'] = $uploadPath; 
                    $config['allowed_types'] = '*'; 
                    $config['max_size'] = 0;
                    $config['remove_spaces'] = TRUE;
                    $config['encrypt_name'] = TRUE;
                    // Load and initialize upload library 
                    $this->load->library('upload', $config); 
                    $this->upload->initialize($config); 
                    // Upload file to server 
                    if($this->upload->do_upload('file')){ 
                        // Uploaded file data 
                        $fileData = $this->upload->data(); 
                        $floorimage = $fileData['file_name']; 
                    }
                    if(!empty($floorimage))
                    {
                      $post_data = array(
                      'floorname' => $this->input->post('floorname')[$i],
                      'floorimage' => $floorimage,    
                      'floorimagealt' => $this->input->post('floorimagealt')[$i],
                      'propertyToken' => $propertyToken
                      );
                      $inserted = $this->Commanmodel->insert_query('property_floor',$post_data);
                    }
          }
          }
          //  Property Floor Plan Stop

           
           
           
           
              if(!empty($_FILES['gallery']['name'])){
                $filesCount = count($_FILES['gallery']['name']); 
                for($i = 0; $i < $filesCount; $i++){ 
                    $_FILES['file']['name']     = $_FILES['gallery']['name'][$i]; 
                    $_FILES['file']['type']     = $_FILES['gallery']['type'][$i]; 
                    $_FILES['file']['tmp_name'] = $_FILES['gallery']['tmp_name'][$i]; 
                    $_FILES['file']['error']     = $_FILES['gallery']['error'][$i]; 
                    $_FILES['file']['size']     = $_FILES['gallery']['size'][$i]; 

                    // File upload configuration 
                    $uploadPath = 'assets/upload/property/'; 
                    $config['upload_path'] = $uploadPath; 
                    $config['allowed_types'] = '*'; 
                    $config['max_size'] = 0;
                    $config['remove_spaces'] = TRUE;
                    $config['encrypt_name'] = TRUE;
                    // Load and initialize upload library 
                    $this->load->library('upload', $config); 
                    $this->upload->initialize($config); 
                    // Upload file to server 
                    if($this->upload->do_upload('file')){ 
                        // Uploaded file data 
                        $fileData = $this->upload->data(); 
                        $uploadGallery = $fileData['file_name']; 
                    }
                    if(!empty($uploadGallery))
                    {
                    $dataGallery = array(
                     'images' => $uploadGallery,
                     'imagealt' => $this->input->post('galleryalt')[$i],
                     'propertyToken' => $propertyToken
                    ); 
                    $insertGallery = $this->Commanmodel->insert_query('property_images',$dataGallery);
                    }
                }
              }


          //  Property Faq Stop
          $paymentplanname_rows = !empty($this->input->post('paymentplanname'))?count($this->input->post('paymentplanname')):0;
          if($paymentplanname_rows > 0)
          {
          for($i=0 ; $i<$paymentplanname_rows;$i++)
          {
                      $post_data = array(
                      'planname' => $this->input->post('paymentplanname')[$i],   
                      'propertyToken' => $propertyToken
                      );
                      $inserted = $this->Commanmodel->insert_query('property_planname',$post_data);
          }
          }
          //  Property Faq Stop



          //  Property Faq Stop
        //   $faqquestion_rows = !empty($this->input->post('faqquestion'))?count($this->input->post('faqquestion')):0;
        //   if($faqquestion_rows > 0)
        //   {
        //   for($i=0 ; $i<$faqquestion_rows;$i++)
        //   {
        //               $post_data = array(
        //               'question' => $this->input->post('faqquestion')[$i],
        //               'answer' => $this->input->post('faqanswer')[$i],    
        //               'propertyToken' => $propertyToken
        //               );
        //               $inserted = $this->Commanmodel->insert_query('property_faq',$post_data);
        //   }
        //   }
          //  Property Faq Stop
          
                if(!empty($_FILES['construction']['name'])){
                $filesCount = count($_FILES['construction']['name']); 
                for($i = 0; $i < $filesCount; $i++){ 
                    $_FILES['file']['name']     = $_FILES['construction']['name'][$i]; 
                    $_FILES['file']['type']     = $_FILES['construction']['type'][$i]; 
                    $_FILES['file']['tmp_name'] = $_FILES['construction']['tmp_name'][$i]; 
                    $_FILES['file']['error']     = $_FILES['construction']['error'][$i]; 
                    $_FILES['file']['size']     = $_FILES['construction']['size'][$i]; 

                    // File upload configuration 
                    $uploadPath = 'assets/upload/property/'; 
                    $config['upload_path'] = $uploadPath; 
                    $config['allowed_types'] = '*'; 
                    $config['max_size'] = 0;
                    $config['remove_spaces'] = TRUE;
                    $config['encrypt_name'] = TRUE;
                    // Load and initialize upload library 
                    $this->load->library('upload', $config); 
                    $this->upload->initialize($config); 
                    // Upload file to server 
                    if($this->upload->do_upload('file')){ 
                        // Uploaded file data 
                        $fileData = $this->upload->data(); 
                        $uploadConstruction = $fileData['file_name']; 
                    }
                    if(!empty($uploadConstruction))
                    {
                    $dataComstruction = array(
                     'images' => $uploadConstruction,
                     'constructionalt' => $this->input->post('constructionalt')[$i],
                     'propertyToken' => $propertyToken
                    ); 
                    $insertGallery = $this->Commanmodel->insert_query('property_construction',$dataComstruction);
                    }
                }
              }
          
          redirect(base_url('dashboard/apply_property/'.$propertyToken.''));
       }
       else
       {
            $this->session->set_flashdata('failed', 'This is not saved!');    
            $this->load->view('user/header');
            $this->load->view('user/property-document',$data);
            $this->load->view('user/footer');
       }
    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Save & Continue process is not working!');    
            $this->load->view('user/header');
            $this->load->view('user/property-document',$data);
            $this->load->view('user/footer');
        }
    }


    public function apply_property($propertyToken)
    {
    $loginId = $this->session->userdata('user_id');    
    $countCheck = $this->Commanmodel->checkCount('property',array('propertyToken' => $propertyToken, 'post_by' => $loginId)); 
    if($countCheck)
    {
    $data = array(
    'propertyToken' => $propertyToken
    );
        $this->load->view('user/header');
        $this->load->view('user/property-apply',$data);
        $this->load->view('user/footer');
    }
    else
    {
       redirect(base_url('dashboard/')); 
    }
    }



public function apply_property_process($propertyToken)
    {
        $loginId = $this->session->userdata('user_id');
        $data = array(
        'propertyToken' => $propertyToken
        );
        if($this->input->post('SaveProperty'))
        {
        $this->form_validation->set_rules('property_token', 'property_token', 'required',array('required'  =>  'Property token invalid'));
        $this->form_validation->set_rules('meta_title', 'Seo Title', 'required',array('required'  =>  'Please enter title'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
      if ($this->form_validation->run() == FALSE)
      {    
      $this->load->view('user/header');
      $this->load->view('user/property-apply',$data);
      $this->load->view('user/footer');
      }
    else
    {
        $post_data = array(
          'status' => 'Under Approved',
          'meta_title' => $this->input->post('meta_title'),
          'meta_keyword' => $this->input->post('meta_keyword'),
          'meta_description' => $this->input->post('meta_description'),
          'status_color' => 'warning'
        );
       $updateddata = $this->Commanmodel->update_query('property',$post_data,array('propertyToken' => $propertyToken));
       if($updateddata)
       {
          $this->session->set_flashdata('flash_message_post', '<div class="alert alert-success" role="alert">Your Propert has been posted successfully. It will be approved after 2 working days.</div>');
          redirect(base_url('dashboard/properties'));
       }
       else
       {
            $this->session->set_flashdata('flash_message_post', 'This Property is not saved!');    
      $this->load->view('user/header');
      $this->load->view('user/property-apply',$data);
      $this->load->view('user/footer');
       }
    }
        }
        else
        {
            $this->session->set_flashdata('flash_message_post', 'Submit Property is not working!');    
      $this->load->view('user/header');
      $this->load->view('user/property-apply',$data);
      $this->load->view('user/footer');
        }
    }
    
    
    function remove_floor()
    {
    $propertyToken = $this->input->post('propertyToken');
    $floor_id = $this->input->post('floor_id');  
    $returnData = $this->Commanmodel->delete_query('property_floor',array('propertyToken' => $propertyToken, 'id' => $floor_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }


 function remove_gallery()
    {
    $propertyToken = $this->input->post('propertyToken');
    $gallery_id = $this->input->post('gallery_id');  
    $returnData = $this->Commanmodel->delete_query('property_images',array('propertyToken' => $propertyToken, 'id' => $gallery_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }

function remove_payment()
    {
    $propertyToken = $this->input->post('propertyToken');
    $payment_id = $this->input->post('payment_id');  
    $returnData = $this->Commanmodel->delete_query('property_planname',array('propertyToken' => $propertyToken, 'id' => $payment_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }
    
    function remove_location()
    {
    $propertyToken = $this->input->post('propertyToken');
    $location_id = $this->input->post('location_id');  
    $returnData = $this->Commanmodel->delete_query('property_location',array('propertyToken' => $propertyToken, 'id' => $location_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }

    function remove_area_image()
    {
    $areatoken = $this->input->post('areatoken');
    $image_id = $this->input->post('image_id');  
    $returnData = $this->Commanmodel->delete_query('area_image',array('areaToken' => $areatoken, 'id' => $image_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }

    function remove_area_infrascructure()
    {
    $areatoken = $this->input->post('areatoken');
    $infrascructure_id = $this->input->post('infrascructure_id');  
    $returnData = $this->Commanmodel->delete_query('area_infrascructure',array('areaToken' => $areatoken, 'id' => $infrascructure_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }
    
    function remove_area_distance()
    {
    $areatoken = $this->input->post('areatoken');
    $distance_id = $this->input->post('distance_id');  
    $returnData = $this->Commanmodel->delete_query('area_distancefrom',array('areaToken' => $areatoken, 'id' => $distance_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }
    
    function remove_area_locality()
    {
    $areatoken = $this->input->post('areatoken');
    $locality_id = $this->input->post('locality_id');  
    $returnData = $this->Commanmodel->delete_query('area_locality',array('areaToken' => $areatoken, 'id' => $locality_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }

    function remove_area_faq()
    {
    $areatoken = $this->input->post('areatoken');
    $faq_id = $this->input->post('faq_id');  
    $returnData = $this->Commanmodel->delete_query('area_faq',array('areaToken' => $areatoken, 'id' => $faq_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }
    
    
    

    function remove_payment_detail()
    {
    $propertyToken = $this->input->post('propertyToken');
    $payment_id = $this->input->post('payment_id'); 
    $paymentdetail_id = $this->input->post('paymentdetail_id');  
    $returnData = $this->Commanmodel->delete_query('property_paymentdetail',array('propertyToken' => $propertyToken, 'payment_id' => $payment_id, 'id' => $paymentdetail_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }


    function remove_floor_detail()
    {
    $propertyToken = $this->input->post('propertyToken');
    $floor_id = $this->input->post('floor_id'); 
    $floordetail_id = $this->input->post('floordetail_id');  
    $returnData = $this->Commanmodel->delete_query('property_floordetail',array('propertyToken' => $propertyToken, 'floor_id' => $floor_id, 'id' => $floordetail_id));
    if($returnData)
    {
        echo "success";
    }
    else
    {
        echo "failed";
    }
    }

    
    
    public function floordetail($id,$propertyToken)
    {
    $countCheck = $this->Commanmodel->checkCount('property_floor',array('propertyToken' => $propertyToken, 'id'=> $id)); 
    if($countCheck)
    {
    $data = array(
    'propertyToken' => $propertyToken,
    'id' => $id
    );
        $this->load->view('user/header');
        $this->load->view('user/floor-detail',$data);
        $this->load->view('user/footer');
    }
    else
    {
       redirect(base_url('dashboard/properties')); 
    }
    }

   
   public function floordetail_process($id,$propertyToken)
    {
        $data = array(
        'propertyToken' => $propertyToken,
        'id' => $id
        );
        if($this->input->post('AddFloorDetail'))
        {
        $this->form_validation->set_rules('property_token', 'property_token', 'required',array('required'  =>  'Property token invalid'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
      if ($this->form_validation->run() == FALSE)
      {    
      $this->load->view('user/header');
      $this->load->view('user/floor-detail',$data);
      $this->load->view('user/footer');
      }
    else
    {
          //  Property Faq Stop
          $heading_rows = !empty($this->input->post('heading'))?count($this->input->post('heading')):0;
          if($heading_rows > 0)
          {
          for($i=0 ; $i<$heading_rows;$i++)
          {
                      $post_data = array(
                      'heading' => $this->input->post('heading')[$i],
                      'value' => $this->input->post('value')[$i],    
                      'propertyToken' => $propertyToken,
                      'floor_id' => $id,
                      );
              $inserted = $this->Commanmodel->insert_query('property_floordetail',$post_data);
          }
          }
          //  Property Faq Stop
          
          $property = $this->Commanmodel->get_single_query('property',array('propertyToken' => $propertyToken));
          if($property->property_status=='Resell' OR $property->property_status=='Lease')
          {
             redirect(base_url('dashboard/apply_property/'.$propertyToken.'')); 
          }
          else
          {
            redirect(base_url('dashboard/apply_property/'.$propertyToken.''));  
          }
          
          
    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Save & Continue process is not working!');    
            $this->load->view('user/header');
            $this->load->view('user/floor-detail',$data);
            $this->load->view('user/footer');
        }
    }

    
    
    public function paymentdetail($id,$propertyToken)
    {
    $countCheck = $this->Commanmodel->checkCount('property_planname',array('propertyToken' => $propertyToken, 'id'=> $id)); 
    if($countCheck)
    {
    $data = array(
    'propertyToken' => $propertyToken,
    'id' => $id
    );
            $this->load->view('user/header');
            $this->load->view('user/payment-detail',$data);
            $this->load->view('user/footer');
    }
    else
    {
       redirect(base_url('dashboard/properties')); 
    }
    }

   
   public function paymentdetail_process($id,$propertyToken)
    {
        $data = array(
        'propertyToken' => $propertyToken,
        'id' => $id
        );
        if($this->input->post('AddPaymentDetail'))
        {
        $this->form_validation->set_rules('property_token', 'property_token', 'required',array('required'  =>  'Property token invalid'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;">', '</div>');
      if ($this->form_validation->run() == FALSE)
      {    
            $this->load->view('user/header');
            $this->load->view('user/payment-detail',$data);
            $this->load->view('user/footer');
      }
    else
    {
          //  Property Faq Stop
          $heading_rows = !empty($this->input->post('heading'))?count($this->input->post('heading')):0;
          if($heading_rows > 0)
          {
          for($i=0 ; $i<$heading_rows;$i++)
          {
                      $post_data = array(
                      'heading' => $this->input->post('heading')[$i],
                      'value' => $this->input->post('value')[$i],    
                      'propertyToken' => $propertyToken,
                      'payment_id' => $id,
                      );
              $inserted = $this->Commanmodel->insert_query('property_paymentdetail',$post_data);
          }
          }
          //  Property Faq Stop
          $property = $this->Commanmodel->get_single_query('property',array('propertyToken' => $propertyToken));
          if($property->property_status=='Resell' OR $property->property_status=='Lease')
          {
             redirect(base_url('dashboard/apply_property/'.$propertyToken.'')); 
          }
          else
          {
            redirect(base_url('dashboard/apply_property/'.$propertyToken.''));  
          }
    }
        }
        else
        {
            $this->session->set_flashdata('failed', 'Save & Continue process is not working!');    
            $this->load->view('user/header');
            $this->load->view('user/payment-detail',$data);
            $this->load->view('user/footer');
        }
    }

    
    
    
   
   public function properties()
   {
      $this->load->view('user/header');
      $this->load->view('user/property-listing');
      $this->load->view('user/footer'); 
   }


    public function page_missing()
    {
        $this->load->view('app/404');
    }


}
