<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Frontend extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        $this->load->library('form_validation');
        $this->load->model('Commanmodel');
        $this->load->helper('text');

    }


  public function createToken()
  {
    echo $token = $this->Commanmodel->generate_category_token();
  }



   public function subscribe()
   {
       if(!empty($this->input->post('email')))
       {
         $SubscribeEmail = $this->input->post('email'); 
         $emailCount= $this->Commanmodel->get_single_query_count('newsletter_subscription',array('newsletter_email' => $SubscribeEmail));
         if($emailCount)
         {
            echo  "Taken";
         }
         else
         {
           $subscribed = $this->Commanmodel->insert_query('newsletter_subscription',array('newsletter_email' => $SubscribeEmail,'newsletter_date' => date('Y-m-d')));
           if($subscribed)
           {
             echo "Success"; 
           }
           else
           {
             echo "Failed";
           }

         }
      }
      else
      {
        echo "Failed";
      }
   }

	public function index()
	{
        $data = array(
        'title' => "Landmark Realty - Houses, Commercial Land & Residential Land", 
        'keyword' => "",
        'description' => "", 
        );
        $this->load->view('app/header',$data);
		    $this->load->view('app/index');
        $this->load->view('app/footer');
	}


    public function our_people()
    {
        $data = array(
        'title' => "Faq", 
        'keyword' => "",
        'description' => "", 
        );
        $this->load->view('app/header',$data);
        $this->load->view('app/our-people');
        $this->load->view('app/footer');
    }

    public function faq()
    {
        $data = array(
        'title' => "Faq", 
        'keyword' => "",
        'description' => "", 
        );
        $this->load->view('app/header',$data);
        $this->load->view('app/faq');
        $this->load->view('app/footer');
    }

    public function about_us()
    {
        $data = array(
        'title' => "About Us", 
        'keyword' => "",
        'description' => "", 
        );
        $this->load->view('app/header',$data);
        $this->load->view('app/about');
        $this->load->view('app/footer');
    }
    

    public function privacy_policy()
    {
        $data = array(
        'title' => "Privacy Policy", 
        'keyword' => "",
        'description' => "", 
        );
        $this->load->view('app/header',$data);
        $this->load->view('app/privacy-policy');
        $this->load->view('app/footer');
    }


        public function term_conditions()
    {
        $data = array(
        'title' => "Privacy Policy", 
        'keyword' => "",
        'description' => "", 
        );
        $this->load->view('app/header',$data);
        $this->load->view('app/term-conditions');
        $this->load->view('app/footer');
    }


    public function contact_us()
    {
        $data = array(
        'title' => "Contact Us", 
        'keyword' => "",
        'description' => "", 
        );
        $this->load->view('app/header',$data);
        $this->load->view('app/contact');
        $this->load->view('app/footer');
    }

        public function contact_us_process()
    {
        if($this->input->post('EnquiryContact'))
        {
                    $post_data = array(
                    'name' => $this->input->post('name'),
                    'mobile' => $this->input->post('mobile'),
                    'email' => $this->input->post('email'),
                    'address' => $this->input->post('address'),
                    'message' => $this->input->post('message'),
                    'created_at' => date('Y-m-d')
                    );
                   $insertEnquiry = $this->Commanmodel->insert_query('contactus',$post_data); 
                   if($insertEnquiry)
                   {
                    $this->session->set_flashdata('flash_message', '<div style="text-align:center;"><p class="alert alert-success font-weight-bold" role="alert">Your enquiry has been sent successfully!</p></div>');
                    redirect('contact');
                   }
                   else
                   {
                    $this->session->set_flashdata('flash_message', '<div style="text-align:center;"><p class="alert alert-danger font-weight-bold" role="alert">Your enquiry has not been sent!</p></div>');
                      $data = array(
                      'title' => "Contact Now", 
                      'keyword' => "Contact Now",
                      'description' => "Contact Now"
                      );
                      $this->load->view('app/header',$data);
                      $this->load->view('app/contact');
                      $this->load->view('app/footer');
                   }
        }
        else
        {    
          $data = array(
          'title' => "Contact Now", 
          'keyword' => "Contact Now",
          'description' => "Contact Now" 
          );
          $this->load->view('app/header',$data);
          $this->load->view('app/contact');
          $this->load->view('app/footer');
        }
    }
    
    
    public function loan($property_url_slug=NULL)
    {
        
        $propertyCheck = $this->Commanmodel->get_query_count('property',array('url_slug' => $property_url_slug));
        if($propertyCheck)
        {
        $data = array(
        'title' => $propertyCheck->meta_title, 
        'keyword' => $propertyCheck->meta_keyword,
        'description' => $propertyCheck->meta_description,
        'propertyView' => $propertyCheck
        );
        $this->load->view('app/headerinner',$data);
        $this->load->view('app/loan',$data);
        $this->load->view('app/footer');
        }
        else
        {
            redirect(base_url());
        }
    }

    public function loan_process($property_url_slug=NULL)
    {
        
        $propertyCheck = $this->Commanmodel->get_query_count('property',array('url_slug' => $property_url_slug));
        if($propertyCheck)
        {
        $data = array(
        'title' => $propertyCheck->meta_title, 
        'keyword' => $propertyCheck->meta_keyword,
        'description' => $propertyCheck->meta_description,
        'propertyView' => $propertyCheck
        );
        
        if($this->input->post('EnquiryContact'))
        {
                    $post_data = array(
                    'name' => $this->input->post('name'),
                    'mobile' => $this->input->post('mobile'),
                    'email' => $this->input->post('email'),
                    'message' => $this->input->post('message'),
                    'loan_type' => $this->input->post('loan_type'),
                    'created_at' => date('Y-m-d')
                    );
                   $insertEnquiry = $this->Commanmodel->insert_query('contactus',$post_data); 
                   if($insertEnquiry)
                   {
                    $this->session->set_flashdata('flash_message', '<div style="text-align:center;"><p class="alert alert-success font-weight-bold" role="alert">Your enquiry has been sent successfully!</p></div>');
                    redirect('loan/'.$propertyCheck->url_slug.'');
                   }
                   else
                   {
                    $this->session->set_flashdata('flash_message', '<div style="text-align:center;"><p class="alert alert-danger font-weight-bold" role="alert">Your enquiry has not been sent!</p></div>');
                      $this->load->view('app/headerinner',$data);
                      $this->load->view('app/loan',$data);
                      $this->load->view('app/footer');
                   }
        }
        else
        {    
          $this->load->view('app/header',$data);
          $this->load->view('app/loan',$data);
          $this->load->view('app/footer');
        }
        }
        else
        {
            redirect(base_url());
        }
    }
    
    
    
    

     


    public function listing()
    {
        $data = array(
        'title' => "Contact Us House Mitra", 
        'keyword' => "House Mitra",
        'description' => "House Mitra", 
        );
        $this->load->view('front/headerinner',$data);
        $this->load->view('front/listing');
        $this->load->view('front/footerinner');
    }

    public function detail()
    {
        $data = array(
        'title' => "Contact Us House Mitra", 
        'keyword' => "House Mitra",
        'description' => "House Mitra", 
        );
        $this->load->view('front/headerinner',$data);
        $this->load->view('front/detail');
        $this->load->view('front/footerinner');
    }



    function create_new_account_process()
    {
        if($this->input->post('email'))
        {
        $this->form_validation->set_rules('user_name', 'Full Name', 'required',array('required'  =>  'Please enter full name!',));
        $this->form_validation->set_rules('mobile_number', 'Mobile Number', 'required|is_unique[users.mobile]',
            array(
                'required'  =>  'Please enter mobile no!',
                'is_unique'  =>  'This mobile is already taken!'
            ));
        $this->form_validation->set_rules('email', 'Email Address', 'required|valid_email|is_unique[users.email]',
            array(
                'required'  =>  'Please enter email!',
                'valid_email'  =>  'Please enter valid email!',
                'is_unique'  =>  'This email is already taken!'
            ));
        $this->form_validation->set_rules('password', 'Password', 'required|min_length[5]|max_length[15]|callback_valid_password',
            array(
                'required'  =>  'Please enter password!',
                'min_length'  =>  'Password min length 5!',
                'max_length'  =>  'Password max length 15!'
             )
             );
        $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'required|min_length[5]|max_length[15]|matches[password]',
            array(
                'required'  =>  'Please enter confirm password!',
                'min_length'  =>  'Confirm Password min length 5!',
                'max_length'  =>  'Confirm Password max length 15!',
                'matches' => 'Password and Confirm password should be same!'
             )
             );
        if($this->form_validation->run())
        {    
                $userToken = $this->Commanmodel->generate_token_user();
                $post_data = array( 
                'token_id' => $userToken,   
                'name' => $this->input->post('user_name'),
                'mobile' => $this->input->post('mobile_number'),
                'email' => $this->input->post('email'),
                'password' => md5($this->input->post('password')),
                'show_password' => $this->input->post('password'),
                'user_status' => 'Active',
                'user_status_color' => 'success',
                'register_date' => date('Y-m-d')
                );
                $inserted = $this->Commanmodel->insert_query('users',$post_data);    
                if($inserted)
                {
                  $email = $this->input->post('email');
                  $password = md5($this->input->post('password'));
                  $LoginUser = $this->Commanmodel->login_user($email,$password);
                  if($LoginUser->num_rows() > 0)
                  {
                  $data      =   $LoginUser->row_array();
                  $userId    =   $data['id'];
                  $userName    =   $data['name'];
                  $userEmail =   $data['email'];
                  $userStatus     =   $data['user_status'];
                  if($userStatus=='Active')
                  {
                  $Logindata = array(
                  'user_id'    => $userId,
                  'user_name'  => $userName,
                  'user_email' => $userEmail,
                  'user_status'     => $userStatus,
                  'logged_in' => TRUE
                  );
                  $this->session->set_userdata($Logindata);
                  $array = array('success' => 'Logged In Account');
                  }
                  else
                  {
                  $array = array('failed' => '<div class="alert alert-danger">Sorry,Your account is not active.</div>');
                  }
                  }
                   }
                   else
                   {
                    $array = array(
                    'failed' => '<div class="alert alert-danger">Your are not registred with us.Please try again?</div>'
                    );
                   }
        }
        else
        {
        $array = array(
        'error'   => true,
        'user_name_error' => form_error('user_name'),
        'mobile_number_error' => form_error('mobile_number'),
        'email_error' => form_error('email'),
        'password_error' => form_error('password'),
        'confirm_password_error' => form_error('confirm_password')
        );
        }
      }
      else
      {
        $array = array('failed' => '<div class="alert alert-danger">Please fill all mandatory fields!</div>');
      }
  echo json_encode($array);
 }


     function login_process()
    {
        if($this->input->post('email_address')!='' AND $this->input->post('login_password')!='')
        {
        $this->form_validation->set_rules('email_address', 'Email Address', 'required|valid_email',
            array(
                'required'  =>  'Please enter email!',
                'valid_email'  =>  'Please enter valid email!'
            ));
        $this->form_validation->set_rules('login_password', 'Password', 'required|min_length[5]|max_length[15]',
            array(
                'required'  =>  'Please enter password!',
                'min_length'  =>  'Password min length 5!',
                'max_length'  =>  'Password max length 15!'
             )
             );
        if($this->form_validation->run())
        {  
                  $email = $this->input->post('email_address');
                  $password = md5($this->input->post('login_password'));
                  $LoginUser = $this->Commanmodel->login_user($email,$password);
                  if($LoginUser->num_rows() > 0)
                  {
                  $data      =   $LoginUser->row_array();
                  $userId    =   $data['id'];
                  $userName    =   $data['name'];
                  $userEmail =   $data['email'];
                  $userStatus     =   $data['user_status'];
                  if($userStatus=='Active')
                  {
                  $Logindata = array(
                  'user_id'    => $userId,
                  'user_name'  => $userName,
                  'user_email' => $userEmail,
                  'user_status'     => $userStatus,
                  'logged_in' => TRUE
                  );
                  $this->session->set_userdata($Logindata);
                  $array = array('success' => 'Logged In Account');
                  }
                  else
                  {
                  $array = array('failed' => '<div class="alert alert-danger">Sorry,Your account is not active.</div>');
                  }
                  }
                  else
                  {
                   $array = array('failed' => '<div class="alert alert-danger">Sorry, Please enter valid login detail!</div>'); 
                  }
        }
        else
        {
        $array = array(
        'error'   => true,
        'email_address_error' => form_error('email_address'),
        'login_password_error' => form_error('login_password')
        );
        }
      }
      else
      {
        $array = array('failed' => '<div class="alert alert-danger">Please fill email and password!</div>');
      }
  echo json_encode($array);
 }

    public function account_logout()
    {
    $data = array(
    'title' => "Logout Successfully", 
    'keyword' => "",
    'description' => "" 
    );
        $this->load->view('app/headerinner',$data);
        $this->load->view('app/account-logout',$data);
        $this->load->view('app/footer');
    }

    public function forget_password()
    {
    $data = array(
    'title' => "Forget Password", 
    'keyword' => "",
    'description' => ""
    );
        $this->load->view('app/headerinner',$data);
        $this->load->view('app/forget-password');
        $this->load->view('app/footer');
    }

    public function forget_password_process()
    {
    $data = array(
    'title' => "Forget Password", 
    'keyword' => "",
    'description' => ""
    );
        if($this->input->post('ForgetPassword')=='Submit')
        {
                    $post_data = array(
                    'email' => $this->input->post('email')
                    );
                   $checkEmail = $this->Commanmodel->checkCount('users',$post_data); 
                   if($checkEmail)
                   {
                    $userDetail = $this->Commanmodel->get_single_query('users',array('email' => $this->input->post('email')));   
  
$otpCreate = rand(111111,999999);  
$_SESSION['email_setotp'] = array(
          'email_otp' => $otpCreate
          );
$to = $userDetail->email; 
$from = 'info@eventrigo.com'; 
$fromName = 'Commercial Noida'; 
$subject = "Forget Password OTP: $otpCreate"; 
$htmlContent = ' 
    <html> 
    <head> 
        <title>Forget Password</title> 
    </head> 
    <body> 
        <h1>Forget Password?</h1> 
        <table cellspacing="0" style="border: 2px dashed #FB4314; width: 100%;"> 
            <tr> 
                <th>OTP:</th><td>'.$otpCreate.'</td> 
            </tr> 
            <tr style="background-color: #e0e0e0;"> 
                <th>Email:</th><td>'.$to.'</td> 
            </tr> 
            <tr> 
                <th>Reset Password URL:</th><td><a href="'.base_url('reset-password/'.$userDetail->token_id.'').'">'.base_url().'</a></td> 
            </tr> 
        </table> 
    </body> 
    </html>'; 
$headers = "MIME-Version: 1.0" . "\r\n"; 
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n"; 
$headers .= 'From: '.$fromName.'<'.$from.'>' . "\r\n"; 
//$headers .= 'Cc: welcome@example.com' . "\r\n"; 
$headers .= 'Bcc: y.khan@starwebmaker.com' . "\r\n"; 
 
// Send email 
if(mail($to, $subject, $htmlContent, $headers)){ 
                        $this->session->set_flashdata('flash_message', '<div style="text-align:center;"><p class="alert alert-success font-weight-bold" role="alert">Success, Reset password link send on your email address.</p></div>');
                    redirect(base_url('forget-password'));
}else{ 
                       $this->session->set_flashdata('flash_message', '<div style="text-align:center;"><p class="alert alert-success font-weight-bold" role="alert">Success, Reset password link send on your email address.</p></div>');
                    redirect(base_url('forget-password'));
}   
                       
                       

                   }
                   else
                   {
                    $this->session->set_flashdata('flash_message', '<div style="text-align:center;"><p class="alert alert-danger font-weight-bold" role="alert">Sorry, This email address is not register!</p></div>');
                      $this->load->view('app/headerinner',$data);
                      $this->load->view('app/forget-password');
                      $this->load->view('app/footer');
                   }
        }
        else
        {    
          $this->load->view('app/headerinner',$data);
          $this->load->view('app/forget-password');
          $this->load->view('app/footer');
        }
    }
    
    public function reset_password($tokenid)
    {
        $checkCount = $this->Commanmodel->checkCount('users',array('token_id' => $tokenid));
        if($checkCount)
        {
        $userDetail = $this->Commanmodel->get_single_query('users',array('token_id' => $tokenid));   
        $data = array(
        'title' => "Reset Password", 
        'keyword' => "",
        'description' => "",
        'userDetail' => $userDetail
        );
        $this->load->view('app/headerinner',$data);
        $this->load->view('app/reset-password',$data);
        $this->load->view('app/footer');
        }
        else
        {
            redirect(base_url('forget-password'));
        }
    }

public function reset_password_process($tokenid)
    {
    $checkCount = $this->Commanmodel->checkCount('users',array('token_id' => $tokenid));
        if($checkCount)
        { 
        $userDetail = $this->Commanmodel->get_single_query('users',array('token_id' => $tokenid));   
        $data = array(
        'title' => "Reset Password", 
        'keyword' => "",
        'description' => "",
        'userDetail' => $userDetail
        );
        if($this->input->post('ResetPassword')=='Submit')
        {
        $this->form_validation->set_rules('password', 'Password', 'required|min_length[5]|max_length[15]|callback_valid_password',
            array(
                'required'  =>  'Please enter password!',
                'min_length'  =>  'Password min length 5!',
                'max_length'  =>  'Password max length 15!'
             )
             );
        $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'required|min_length[5]|max_length[15]|matches[password]',
            array(
                'required'  =>  'Please enter confirm password!',
                'min_length'  =>  'Confirm Password min length 5!',
                'max_length'  =>  'Confirm Password max length 15!',
                'matches' => 'Password and Confirm password should be same!'
             )
             );
        if($this->form_validation->run())
        {
                    $post_data = array(
                    'password' => md5($this->input->post('password')),
                    'show_password' => $this->input->post('password')
                    );
                    
                    
                   if($_SESSION['email_setotp']['email_otp']==$this->input->post('email_otp'))
                   {
                   $updatePassword = $this->Commanmodel->update_query('users',$post_data,array('token_id' => $tokenid)); 
                   if($updatePassword)
                   {
$to = $userDetail->email; 
$from = 'info@eventrigo.com'; 
$fromName = 'Commercial Noida'; 
$subject = "Password Updated"; 
$htmlContent = ' 
    <html> 
    <head> 
        <title>Updated Password</title> 
    </head> 
    <body> 
        <h1>Successfully password updated.</h1> 
        <table cellspacing="0" style="border: 2px dashed #FB4314; width: 100%;"> 
            <tr style="background-color: #e0e0e0;"> 
                <th>Email:</th><td>'.$to.'</td> 
            </tr> 
        </table> 
    </body> 
    </html>'; 
$headers = "MIME-Version: 1.0" . "\r\n"; 
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n"; 
$headers .= 'From: '.$fromName.'<'.$from.'>' . "\r\n"; 
//$headers .= 'Cc: welcome@example.com' . "\r\n"; 
$headers .= 'Bcc: y.khan@starwebmaker.com' . "\r\n"; 
 
// Send email 
if(mail($to, $subject, $htmlContent, $headers)){ 
    unset($_SESSION['email_setotp']);
                        $this->session->set_flashdata('flash_message', '<div style="text-align:center;"><p class="alert alert-success font-weight-bold" role="alert">Success, This password has been changed successfully.</p></div>');
                    redirect(base_url('forget-password'));
}else{ 
      unset($_SESSION['email_setotp']);
                       $this->session->set_flashdata('flash_message', '<div style="text-align:center;"><p class="alert alert-success font-weight-bold" role="alert">Success, This password has been changed successfully.</p></div>');
                    redirect(base_url('forget-password'));
}   
                       
                       

                   }
                   else
                   {
                    $this->session->set_flashdata('flash_message', '<div style="text-align:center;"><p class="alert alert-danger font-weight-bold" role="alert">Sorry, This email address is not register!</p></div>');
                      $this->load->view('app/headerinner',$data);
                      $this->load->view('app/reset-password',$data);
                      $this->load->view('app/footer');
                   }
        }
        else
        {
                      $this->session->set_flashdata('flash_message', '<div style="text-align:center;"><p class="alert alert-danger font-weight-bold" role="alert">Sorry, This email OTP is not valid!</p></div>');
                      $this->load->view('app/headerinner',$data);
                      $this->load->view('app/reset-password',$data);
                      $this->load->view('app/footer');  
        }
                   
        }
        else
        {
          $this->load->view('app/headerinner',$data);
          $this->load->view('app/reset-password',$data);
          $this->load->view('app/footer');  
        }
        }
        else
        {    
          $this->load->view('app/headerinner',$data);
          $this->load->view('app/reset-password',$data);
          $this->load->view('app/footer');
        }
        }
        else
        {
            redirect(base_url('forget-password'));
        }
    }



//Create strong password 
    public function valid_password($password = '')
    {
        $password = trim($password);

        $regex_lowercase = '/[a-z]/';
        $regex_uppercase = '/[A-Z]/';
        $regex_number = '/[0-9]/';
        $regex_special = '/[!@#$%^&*()\-_=+{};:,<.>ยง~]/';

        if (empty($password))
        {
            $this->form_validation->set_message('valid_password', 'The {field} field is required.');

            return FALSE;
        }

        if (preg_match_all($regex_lowercase, $password) < 1)
        {
            $this->form_validation->set_message('valid_password', 'The {field} field must be at least one lowercase letter.');

            return FALSE;
        }

        if (preg_match_all($regex_uppercase, $password) < 1)
        {
            $this->form_validation->set_message('valid_password', 'The {field} field must be at least one uppercase letter.');

            return FALSE;
        }

        if (preg_match_all($regex_number, $password) < 1)
        {
            $this->form_validation->set_message('valid_password', 'The {field} field must have at least one number.');

            return FALSE;
        }

        if (preg_match_all($regex_special, $password) < 1)
        {
            $this->form_validation->set_message('valid_password', 'The {field} field must have at least one special character.' . ' ' . htmlentities('!@#$%^&*()\-_=+{};:,<.>ยง~'));

            return FALSE;
        }

        if (strlen($password) < 5)
        {
            $this->form_validation->set_message('valid_password', 'The {field} field must be at least 5 characters in length.');

            return FALSE;
        }

        if (strlen($password) > 32)
        {
            $this->form_validation->set_message('valid_password', 'The {field} field cannot exceed 32 characters in length.');

            return FALSE;
        }

        return TRUE;
    }
    //strong password end



  public function single_property($property_url_slug=null)
   {
        $propertyCheck = $this->Commanmodel->get_query_count('property',array('url_slug' => $property_url_slug));
        if($propertyCheck)
        {
        $data = array(
        'title' => $propertyCheck->meta_title, 
        'keyword' => $propertyCheck->meta_keyword,
        'description' => $propertyCheck->meta_description,
        'propertyView' => $propertyCheck
        );
          $this->load->view('app/header',$data);
          if($propertyCheck->property_status=='Resell')
          {
            $this->load->view('app/single-resell',$data);  
          }
          elseif($propertyCheck->property_status=='Lease')
          {
            $this->load->view('app/single-resell',$data);  
          }
          else
          {
              
          }
          $this->load->view('app/footer');
        
        }
        else
        {
          redirect(base_url('404'));
        }   
   }


   public function property_enquiry($property_url_slug=null)
   {
        $propertyCheck = $this->Commanmodel->get_query_count('property',array('url_slug' => $property_url_slug));
        if($propertyCheck)
        {
        $data = array(
        'title' => $propertyCheck->meta_title, 
        'keyword' => $propertyCheck->meta_keyword,
        'description' => $propertyCheck->meta_description,
        'propertyView' => $propertyCheck
        );
        if($this->input->post('sendmessage'))
        {  
          $this->form_validation->set_rules('full_name', 'Name', 'required',
            array('required'  =>  'Name should not be empty!'));

          $this->form_validation->set_rules('phone_number', 'Mobile', 'required',
            array('required'  =>  'Mobile should not be empty!'));

          $this->form_validation->set_rules('email_address', 'Email', 'required',
            array('required'  =>  'Email should not be empty!'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;font-size: 12px;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {
                  $this->load->view('app/header',$data);
                  $this->load->view('app/single-resell',$data);
                  $this->load->view('app/footer');
                }
                else
                { 
                    $seoUrl = $propertyCheck->url_slug;
                    $post_data = array(
                    'property_id' => $propertyCheck->id, 
                    'property_type' => $propertyCheck->property_status,
                    'property_category' => $propertyCheck->category, 
                    'name' => $this->input->post('full_name'),
                    'mobile' => $this->input->post('phone_number'),
                    'email' => $this->input->post('email_address'),
                    'message' => $this->input->post('yourmessage'),
                    'date' => date('Y-m-d')
                    );
                   $insertEnquiry = $this->Commanmodel->insert_query('property_enquiry',$post_data); 
                   if($insertEnquiry)
                   {
                    $this->session->set_flashdata('flash_message', '<div class="alert alert-success" style="text-align: center;">
  <strong>Submitted!</strong> You enquiry has been submitted successfully.</div>');
                    redirect(base_url('property/'.$seoUrl.''));
                   }
                   else
                   {
                    $this->session->set_flashdata('flash_message', '<div class="alert alert-danger">
  <strong>Failed!</strong> You enquiry has not been submitted.</div>');
                    redirect(base_url('property/'.$seoUrl.''));
                   }



                }

        }  
        }
        else{
          redirect(base_url('404'));
        }   
   }


   public function property_submit_review($property_url_slug=null)
   {
        $propertyCheck = $this->Commanmodel->get_query_count('property',array('url_slug' => $property_url_slug));
        if($propertyCheck)
        {
        $data = array(
        'title' => $propertyCheck->meta_title, 
        'keyword' => $propertyCheck->meta_keyword,
        'description' => $propertyCheck->meta_description,
        'propertyView' => $propertyCheck
        );
        if($this->input->post('SubmitReview'))
        {  
          $this->form_validation->set_rules('rating', 'Rating', 'required',
          array('required'  =>  'Please choose rating!'));

          $this->form_validation->set_rules('name', 'Name', 'required',
            array('required'  =>  'Name should not be empty!'));

          $this->form_validation->set_rules('email', 'Email', 'required',
            array('required'  =>  'Email should not be empty!'));

          $this->form_validation->set_rules('review_messsage', 'Message', 'required',
            array('required'  =>  'Message should not be empty!'));

        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;font-size: 12px;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {
                  $this->load->view('app/headerinner',$data);
                  $this->load->view('app/single-property',$data);
                  $this->load->view('app/footer');
                }
                else
                { 
                    $seoUrl = $propertyCheck->url_slug;
                    $post_data = array(
                    'author_property_id' => $propertyCheck->id,  
                    'author_name' => $this->input->post('name'),
                    'author_email' => $this->input->post('email'),
                    'author_comment' => $this->input->post('review_messsage'),
                    'stars' => $this->input->post('rating'),
                    'author_date' => date('Y-m-d')
                    );
                   $insertEnquiry = $this->Commanmodel->insert_query('property_review',$post_data); 
                   if($insertEnquiry)
                   {
                    $this->session->set_flashdata('flash_message', '<div class="alert alert-success" style="text-align: center;">
  <strong>Review Submitted!</strong> You review has been submitted successfully. This review will been approved with in 2 working days.</div>');
                    redirect(base_url('property/'.$seoUrl.''));
                   }
                   else
                   {
                    $this->session->set_flashdata('flash_message', '<div class="alert alert-danger" style="text-align: center;">
  <strong>Failed!</strong> You review has not been submitted.</div>');
                    redirect(base_url('property/'.$seoUrl.''));
                   }



                }

        }  
        }
        else{
          redirect(base_url('404'));
        }   
   }


    public function get_subcategory()
    {
      $categoryID = $this->input->post('category_id');
      $allsubcategory = $this->Commanmodel->all_multiple_query_order_by('category',array('parent_id' => $categoryID),'category','ASC');
      foreach ($allsubcategory as $allsubcategoryView) 
      {
         ?>
         <option value="<?php echo $allsubcategoryView->id; ?>"><?php echo $allsubcategoryView->category; ?></option>
         <?php
      }

    }

    public function category($category_url=null)
    {
        $categoryCheck = $this->Commanmodel->get_query_count('category',array('url_slug' => $category_url, 'parent_id'=> '0'));
        if($categoryCheck)
        {
        $data = array(
        'title' => $categoryCheck->meta_title, 
        'keyword' => $categoryCheck->meta_keyword,
        'description' => $categoryCheck->meta_description,
        'category' => $categoryCheck
        );
        $this->load->view('app/headerinner',$data);
        $this->load->view('app/category-listing',$data);
        $this->load->view('app/footer');
        }
        else
        {
          redirect(base_url(''));
        }
    }


  public function locality($locality_url=null)
   {
        $localityCheck = $this->Commanmodel->get_query_count('city',array('url_slug' => $locality_url, 'parent_id'=> 0));
        if($localityCheck)
        {
        $data = array(
        'title' => $localityCheck->meta_title, 
        'keyword' => $localityCheck->meta_keyword,
        'description' => $localityCheck->meta_description,
        'city' => $localityCheck
        );
        $this->load->view('app/headerinner',$data);
        $this->load->view('app/locality-listing',$data);
        $this->load->view('app/footer');
        }
        else
        {
          redirect(base_url(''));
        }
   }

   public function locality_area($locality_url=null,$area_url=null)
   {
        $localityCheck = $this->Commanmodel->get_query_count('city',array('city_id' => $area_url));
        if($localityCheck)
        {
        $city = $this->Commanmodel->get_single_query('city',array('url_slug' => $locality_url));    
        $data = array(
        'title' => $localityCheck->meta_title, 
        'keyword' => $localityCheck->meta_keyword,
        'description' => $localityCheck->meta_description,
        'area' => $localityCheck,
        'city' => $city
        );
        $this->load->view('app/headerinner',$data);
        $this->load->view('app/locality-area-listing',$data);
        $this->load->view('app/footer');
        }
        else
        {
          redirect(base_url(''));
        }
   }
   
   
   
   public function locality_submit_review($area_id=null)
   {
        $localityCheck = $this->Commanmodel->get_query_count('city',array('city_id' => $area_id));
        if($localityCheck)
        {
        $city = $this->Commanmodel->get_single_query('city',array('city_id' => $localityCheck->parent_id));    
        $data = array(
        'title' => $localityCheck->meta_title, 
        'keyword' => $localityCheck->meta_keyword,
        'description' => $localityCheck->meta_description,
        'area' => $localityCheck,
        'city' => $city
        );
        if($this->input->post('SubmitReview'))
        {  
          $this->form_validation->set_rules('rating', 'Rating', 'required',
          array('required'  =>  'Please choose rating!'));

          $this->form_validation->set_rules('name', 'Name', 'required',
            array('required'  =>  'Name should not be empty!'));

          $this->form_validation->set_rules('email', 'Email', 'required',
            array('required'  =>  'Email should not be empty!'));

          $this->form_validation->set_rules('review_messsage', 'Message', 'required',
            array('required'  =>  'Message should not be empty!'));

        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;font-size: 12px;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {
                  $this->load->view('app/headerinner',$data);
                  $this->load->view('app/locality-area-listing',$data);
                  $this->load->view('app/footer');
                }
                else
                { 
                    $post_data = array(
                    'author_property_id' => $localityCheck->city_id,  
                    'author_name' => $this->input->post('name'),
                    'author_email' => $this->input->post('email'),
                    'author_comment' => $this->input->post('review_messsage'),
                    'stars' => $this->input->post('rating'),
                    'author_date' => date('Y-m-d')
                    );
                   $insertEnquiry = $this->Commanmodel->insert_query('area_review',$post_data); 
                   if($insertEnquiry)
                   {
                    $this->session->set_flashdata('flash_message', '<div class="alert alert-success" style="text-align: center;">
  <strong>Review Submitted!</strong> You review has been submitted successfully. This review will been approved with in 2 working days.</div>');
                    redirect(base_url('locality-area/'.$city->url_slug.'/'.$localityCheck->city_id.''));
                   }
                   else
                   {
                    $this->session->set_flashdata('flash_message', '<div class="alert alert-danger" style="text-align: center;">
  <strong>Failed!</strong> You review has not been submitted.</div>');
                    redirect(base_url('locality-area/'.$city->url_slug.'/'.$localityCheck->city_id.''));
                   }



                }

        }  
        }
        else{
          redirect(base_url('404'));
        }   
   }


   public function locality_enquiry($area_id=null)
   {
        $localityCheck = $this->Commanmodel->get_query_count('city',array('city_id' => $area_id));
        if($localityCheck)
        {
        $city = $this->Commanmodel->get_single_query('city',array('city_id' => $localityCheck->parent_id));    
        $data = array(
        'title' => $localityCheck->meta_title, 
        'keyword' => $localityCheck->meta_keyword,
        'description' => $localityCheck->meta_description,
        'area' => $localityCheck,
        'city' => $city
        );
        if($this->input->post('sendmessage'))
        {  
          $this->form_validation->set_rules('full_name', 'Name', 'required',
            array('required'  =>  'Name should not be empty!'));

          $this->form_validation->set_rules('phone_number', 'Mobile', 'required',
            array('required'  =>  'Mobile should not be empty!'));

          $this->form_validation->set_rules('email_address', 'Email', 'required',
            array('required'  =>  'Email should not be empty!'));
        $this->form_validation->set_error_delimiters('<div class="btn btn-danger" style="width:100%;padding: 0px 0px !important;font-size: 12px;">', '</div>');
                if ($this->form_validation->run() == FALSE)
                {
                  $this->load->view('app/headerinner',$data);
                  $this->load->view('app/locality-area-listing',$data);
                  $this->load->view('app/footer');
                }
                else
                { 
                    $post_data = array(
                    'property_id' => $localityCheck->city_id, 
                    'name' => $this->input->post('full_name'),
                    'mobile' => $this->input->post('phone_number'),
                    'email' => $this->input->post('email_address'),
                    'message' => $this->input->post('message'),
                    'date' => date('Y-m-d')
                    );
                   $insertEnquiry = $this->Commanmodel->insert_query('area_enquiry',$post_data); 
                   if($insertEnquiry)
                   {
                    $this->session->set_flashdata('flash_message', '<div class="alert alert-success" style="text-align: center;">
  <strong>Submitted!</strong> You enquiry has been submitted successfully.</div>');
                    redirect(base_url('locality-area/'.$city->url_slug.'/'.$localityCheck->city_id.''));
                   }
                   else
                   {
                    $this->session->set_flashdata('flash_message', '<div class="alert alert-danger">
  <strong>Failed!</strong> You enquiry has not been submitted.</div>');
                    redirect(base_url('locality-area/'.$city->url_slug.'/'.$localityCheck->city_id.''));
                   }



                }

        }  
        }
        else{
          redirect(base_url('404'));
        }   
   }

   


   public function new_launch()
   {
        $data = array(
        'title' => 'New Launch', 
        'keyword' => 'New Launch',
        'description' => 'New Launch',
        'type' => 'New Launch'
        );
        $this->load->view('app/header',$data);
        $this->load->view('app/new-launch',$data);
        $this->load->view('app/footer');
   }
   
   public function assured_return()
   {
        $data = array(
        'title' => 'Assured Return', 
        'keyword' => 'Assured Return',
        'description' => 'Assured Return',
        'type' => 'Assured Return'
        );
        $this->load->view('app/headerinner',$data);
        $this->load->view('app/assured-return',$data);
        $this->load->view('app/footer');
   }
   public function pre_leased()
   {
        $data = array(
        'title' => 'Pre Leased', 
        'keyword' => 'Pre Leased',
        'description' => 'Pre Leased',
        'type' => 'Pre Leased'
        );
        $this->load->view('app/headerinner',$data);
        $this->load->view('app/pre-leased',$data);
        $this->load->view('app/footer');
   }
   
   

         public function ready_to_move()
   {
        $data = array(
        'title' => 'Ready To Move Property', 
        'keyword' => 'Ready To Move Property',
        'description' => 'Ready To Move Property',
        'type' => 'Ready To Move'
        );
        $this->load->view('app/headerinner',$data);
        $this->load->view('app/ready-to-move',$data);
        $this->load->view('app/footer');
   }


   public function resell()
   {
        $data = array(
        'title' => 'Resell Property', 
        'keyword' => 'Resell Property',
        'description' => 'Resell Property',
        'status_type' => 'Resell'
        );
        $this->load->view('app/headerinner',$data);
        $this->load->view('app/resell',$data);
        $this->load->view('app/footer');
   }

    public function lease()
    {
        $data = array(
        'title' => 'Lease Property', 
        'keyword' => 'Lease Property',
        'description' => 'Lease Property',
        'status_type' => 'Lease'
        );
        $this->load->view('app/headerinner',$data);
        $this->load->view('app/lease',$data);
        $this->load->view('app/footer');
    }     


   public function property()
   {
        $category = $this->input->get('category'); 
        $property_status = $this->input->get('property_status');   
        $locality = $this->input->get('locality');
        $type = $this->input->get('type');
        $sector_area = $this->input->get('sector_area');
        $data = array(
        'title' => "Search Property Here", 
        'keyword' => "Search Property Here",
        'description' => "Search Property Here",
        'category' => $category,
        'property_status' => $property_status,
        'locality' => $locality,
        'type' => $type,
        'sector_area' => $sector_area
        );
        $this->load->view('app/header',$data);
        $this->load->view('app/property',$data);
        $this->load->view('app/footer');
   }



function fetch_data_product()
  {
   $this->load->model('Propertycomman'); 
  sleep(1);
  
  
  $sortBy = $this->input->post('sortBy');
  
  
  
  $newLaunch = $this->input->post('newLaunch');
  $assuredReturn = $this->input->post('assuredReturn');
  $preLeased = $this->input->post('preLeased');
  
  $category = $this->input->post('category');
  $construction_status = $this->input->post('construction_status');
  $property_type = $this->input->post('property_type');
  
  $city = $this->input->post('city');
  $min_budget = $this->input->post('min_budget');
  $max_budget = $this->input->post('max_budget');
  $project_name = $this->input->post('project_name');
  $furnished = $this->input->post('furnished');
  $search = $this->input->post('search');
  
  $this->load->library('pagination');
  $config = array();
  $config['base_url'] = '#';
  $config['total_rows'] = $this->Propertycomman->count_all($sortBy,$newLaunch,$assuredReturn,$preLeased,$category,$construction_status,$property_type,$city,$min_budget,$max_budget,$project_name,$furnished,$search);
  $config['per_page'] = 24;
  $config['uri_segment'] = 3;
  $config['use_page_numbers'] = TRUE;
  $config['full_tag_open'] = '<ul class="page_navigation">';
  $config['full_tag_close'] = '</ul>';
  $config['first_tag_open'] = '<li class="page-item">'; 
  $config['first_tag_close'] = '</li>';
  $config['last_tag_open'] = '<li class="page-item">'; 
  $config['last_tag_close'] = '</li>';
  $config['next_link'] = '<span class="fa fa-arrow-right"></span>';
  $config['next_tag_open'] = '<li class="page-item">';
  $config['next_tag_close'] = '</li>';
  $config['prev_link'] = '<span class="fa fa-arrow-left"></span>';
  $config['prev_tag_open'] = '<li class="page-item">';
  $config['prev_tag_close'] = '</li>';
  $config['cur_tag_open'] = "<li class='page-item active'><a href='#' class='page-link'>";
  $config['cur_tag_close'] = '</a></li>';
  $config['num_tag_open'] = '<li class="page-item">';
  $config['num_tag_close'] = '</li>';
  $config['num_links'] = 3;
  $this->pagination->initialize($config);
  $page = $this->uri->segment(3);
  $start = ($page - 1) * $config['per_page'];
  $output = array(
   'pagination_link'  => $this->pagination->create_links(),
   'property_list'   => $this->Propertycomman->fetch_data($config["per_page"], $start,$sortBy,$newLaunch,$assuredReturn,$preLeased,$category,$construction_status,$property_type,$city,$min_budget,$max_budget,$project_name,$furnished,$search)
  );
  echo json_encode($output);
 }


   

  function fetch_data_locality()
  {
   $this->load->model('Localitymodel'); 
  sleep(1);
  $locality = $this->input->post('locality');
  $localityarea = $this->input->post('localityarea');
  $this->load->library('pagination');
  $config = array();
  $config['base_url'] = '#';
  $config['total_rows'] = $this->Localitymodel->count_all($locality,$localityarea);
  $config['per_page'] = 24;
  $config['uri_segment'] = 3;
  $config['use_page_numbers'] = TRUE;
  $config['full_tag_open'] = '<ul class="page_navigation">';
  $config['full_tag_close'] = '</ul>';
  $config['first_tag_open'] = '<li class="page-item">'; 
  $config['first_tag_close'] = '</li>';
  $config['last_tag_open'] = '<li class="page-item">'; 
  $config['last_tag_close'] = '</li>';
  $config['next_link'] = '<span class="fa fa-arrow-right"></span>';
  $config['next_tag_open'] = '<li class="page-item">';
  $config['next_tag_close'] = '</li>';
  $config['prev_link'] = '<span class="fa fa-arrow-left"></span>';
  $config['prev_tag_open'] = '<li class="page-item">';
  $config['prev_tag_close'] = '</li>';
  $config['cur_tag_open'] = "<li class='page-item active'><a href='#' class='page-link'>";
  $config['cur_tag_close'] = '</a></li>';
  $config['num_tag_open'] = '<li class="page-item">';
  $config['num_tag_close'] = '</li>';
  $config['num_links'] = 3;
  $this->pagination->initialize($config);
  $page = $this->uri->segment(3);
  $start = ($page - 1) * $config['per_page'];
  $output = array(
   'pagination_link'  => $this->pagination->create_links(),
   'property_list'   => $this->Localitymodel->fetch_data($config["per_page"], $start,$locality,$localityarea)
  );
  echo json_encode($output);
 }

   
   
    public function blog_list()
    {
        $blogCheck = $this->Commanmodel->all_multiple_query_order_by('blogs',array('blog_status' => 'Active'),'blog_id','DESC');
        $data = array(
        'title' => 'Our Latest Blogs', 
        'keyword' => 'Our Latest Blogs',
        'description' => 'Our Latest Blogs',
        'blogList' => $blogCheck
        );
        $this->load->view('app/header',$data);
        $this->load->view('app/blog',$data);
        $this->load->view('app/footer');
    }

   
   
   public function blog_view($blog_url_slug=null)
   {
        $blogCheck = $this->Commanmodel->get_query_count('blogs',array('url_slug' => $blog_url_slug, 'blog_status' => 'Active'));
        if($blogCheck)
        {
        $data = array(
        'title' => $blogCheck->meta_title, 
        'keyword' => $blogCheck->meta_keyword,
        'description' => $blogCheck->meta_description,
        'blogView' => $blogCheck
        );
        $this->load->view('app/header',$data);
        $this->load->view('app/blog-details',$data);
        $this->load->view('app/footer');
        }
        else{
          redirect(base_url('404'));
        }   
   }


    public function news_list()
    {
        $newsCheck = $this->Commanmodel->all_multiple_query_order_by('news',array('news_status' => 'Active'),'news_id','DESC');
        $data = array(
        'title' => 'Our Latest News', 
        'keyword' => 'Our Latest News',
        'description' => 'Our Latest News',
        'newsList' => $newsCheck
        );
        $this->load->view('app/headerinner',$data);
        $this->load->view('app/news-list',$data);
        $this->load->view('app/footer');
    }

   public function news_view($blog_url_slug=null)
   {
        $blogCheck = $this->Commanmodel->get_query_count('news',array('url_slug' => $blog_url_slug));
        if($blogCheck)
        {
        $data = array(
        'title' => $blogCheck->meta_title, 
        'keyword' => $blogCheck->meta_keyword,
        'description' => $blogCheck->meta_description,
        'newsView' => $blogCheck
        );
        $this->load->view('app/headerinner',$data);
        $this->load->view('app/news-detail',$data);
        $this->load->view('app/footer');
        }
        else{
          redirect(base_url('404'));
        }   
   }




    public function page_missing()
    {
        $this->load->view('app/header');
        $this->load->view('app/index');
        $this->load->view('app/footer');
    }


}
