<?php
class Praposalmodel extends CI_Model{

//   Product data table
    var $table = 'praposal';
    var $column_order = array(null, 'email_praposal','subject_praposal','send_date'); //set column field database for datatable orderable
    var $column_search = array('email_praposal','subject_praposal','send_date'); //set column field database for datatable searchable 
    var $order = array('id' => 'DESC'); // default order 

        private function _get_datatables_query()
    {
        if($this->input->post('praposal_search'))
        {
        $this->db->like('email_praposal', $this->input->post('praposal_search'));
        }
        if($this->input->post('from_date')!='' && $this->input->post('to_date')!='')
        {
            $date1 = date('Y-m-d',strtotime($this->input->post('from_date')));
            $date2 = date('Y-m-d',strtotime($this->input->post('to_date')));
            $this->db->where('DATE(send_date) >=', $date1);
            $this->db->where('DATE(send_date) <=', $date2);
        }
        if($this->input->post('from_date')=='' && $this->input->post('to_date')!='')
        {
            $date2 = date('Y-m-d',strtotime($this->input->post('to_date')));
            $this->db->where('DATE(send_date)', $date2);
        }
        if($this->input->post('from_date')!='' && $this->input->post('to_date')=='')
        {
            $date1 = date('Y-m-d',strtotime($this->input->post('from_date')));
            $this->db->where('DATE(send_date)', $date1);
        }
        $this->db->from($this->table);
        $i = 0;
        foreach ($this->column_search as $item) // loop column 
        {
            if($_POST['search']['value']) // if datatable send POST for search
            {
                if($i===0) // first loop
                {
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $_POST['search']['value']);
                }
                else
                {
                    $this->db->or_like($item, $_POST['search']['value']);
                }
 
                if(count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } 
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables()
    {
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
 
    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all()
    {
        $this->db->from($this->table);
        return $this->db->count_all_results();
    }


}