<?php
$this->load->model('Commanmodel');
$salesUser = $this->Commanmodel->get_single_query('users',array('id' => $property->salesid));
?>


  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0 text-dark">Property detail</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo base_url('admin/dashboard'); ?>">Home</a></li>
              <li class="breadcrumb-item active">Dashboard</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->







    <!-- Main content -->
    <section class="content">
      <div class="row">

        <div class="col-12">
          <!-- /.card -->
          <div class="card">
            <!-- /.card-header -->
            <div class="card-body">
              <table class="table table-bordered table-striped">
                <thead>
                <tr>
                  <th>Fields</th>
                  <th>Values</th>
                </tr>
                </thead>
                <tbody>
                <tr>
                  <td>Sales User</td>
                  <td><?php echo $salesUser->name.' | '. $salesUser->mobile.' | '. $salesUser->email; ?></td>
                </tr>

                <tr>
                  <td>Property Name</td>
                  <td><?php echo $property->propertyName; ?></td>
                </tr>

                <tr>
                  <td>Category/Subcategory</td>
                  <td><?php
                  if($property->propertyCategory!='')
                  {
                   $category = $this->Commanmodel->get_single_query('category',array('id' => $property->propertyCategory));
                  echo $category->category;
                  }
                  ?> 
                  | <?php
                  if($property->propertySubCategory!='')
                  {
                   $subcategory = $this->Commanmodel->get_single_query('category',array('id' => $property->propertySubCategory));
                  echo $subcategory->category;
                  }
                  ?>

                  </td>
                </tr>

                <tr>
                  <td>Property Status</td>
                  <td><?php echo $property->propertyStatus; ?></td>
                </tr>
             
                <tr>
                  <td>Price</td>
                  <td><?php echo $property->propertyPrice; ?></td>
                </tr>
                
                <tr>
                  <td>Area Size</td>
                  <td><?php echo $property->propertyArea; ?></td>
                </tr>
                
                <tr>
                  <td>Location</td>
                  <td><?php
                  if($property->state!='')
                  {
                   $state = $this->Commanmodel->get_single_query('state',array('state_id' => $property->state));
                  echo $state->state_name;
                  }
                  ?> | <?php
                  if($property->city!='')
                  {
                   $city = $this->Commanmodel->get_single_query('city',array('city_id' => $property->city));
                  echo $city->city_name;
                  }
                  ?> | <?php echo $property->address; ?> | <?php echo $property->zipcode; ?></td>
                </tr>
                
                
                <tr>
                  <td>Property ID</td>
                  <td><?php echo $property->propertyID; ?></td>
                </tr>
                
                <tr>
                  <td>Rooms</td>
                  <td><?php echo $property->rooms; ?></td>
                </tr>
                
                <tr>
                  <td>Bed rooms</td>
                  <td><?php echo $property->bedrooms; ?></td>
                </tr>
                
                <tr>
                  <td>Bath</td>
                  <td><?php echo $property->bath; ?></td>
                </tr>
                
                <tr>
                  <td>Garages</td>
                  <td><?php echo $property->garages; ?></td>
                </tr>
                
                <tr>
                  <td>Year Build</td>
                  <td><?php echo $property->yearBuild; ?></td>
                </tr>

                <tr>
                  <td>Amenities</td>
                  <td><?php 
                  if($property->amenities!='')
                  {
                  $amenitiesValue = explode(',',$property->amenities);
                  foreach($amenitiesValue as $amenitiesValueView)
                  {
                     $getAmenities = $this->Commanmodel->get_single_query('amenities',array('tokenAmenities' => $amenitiesValueView));
                    echo $getAmenities->name.' | ';
                  }
                  }
                    ?></td>
                </tr>

                <tr>
                  <td>Youtube Video</td>
                  <td>
                    <?php
                    if($property->embadedCode!='')
                    {
                    ?>
                    <iframe width="560" height="315" src="https://www.youtube.com/embed/<?php echo $property->embadedCode; ?>?controls=0" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                    <?php
                    }
                    ?>
                  </td>
                </tr>

                <tr>
                  <td>Property Banner</td>
                  <td>
                  <?php 
                  if($property->propertyBanner!='')
                  {
                    ?>
                    <img src="<?php echo base_url('assets/property/'.$property->propertyBanner.''); ?>" style="height:200px; width: 100%;">
                    <?php
                  }
                  ?>
                  </td>
                </tr>


                <tr>
                  <td>Property Gallery</td>
                  <td>
                    
                   
                   <?php
                   $allGalleryCount = $this->Commanmodel->checkCount('property_images',array('propertyToken' => $property->propertyToken)); 
                   if($allGalleryCount)
                   {
                      $allGallery = $this->Commanmodel->all_multiple_query_order_by('property_images',array('propertyToken' => $property->propertyToken),'id','ASC');
                      foreach ($allGallery as $allGalleryView) {
                      ?>
                      <img src="<?php echo base_url('assets/property/'.$allGalleryView->images.''); ?>" style="height:100px; width:100px;">    
                      <?php
                     }
                   } 
                   ?>



                  </td>
                </tr>


                <tr>
                  <td>Flore Plan</td>
                  <td>
                    <?php 
                    if($property->florePlan!='')
                    {
                    ?>
                    <a href="<?php echo base_url('assets/property/'.$property->florePlan.''); ?>" target="_blank">View Flore Plan</a>
                    <?php
                    }
                    ?>  
                  </td>
                </tr>

                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>



<div class="col-12">
          <!-- /.card -->
          <div class="card">
           <?php
            if($this->session->flashdata('failed'))
              { 
               ?>
            <div class="alert alert-danger alert-dismissable">
            <?php echo $this->session->flashdata('failed'); ?>
            </div>
            <?php        
            }
            ?>
           <?php
            if($this->session->flashdata('created'))
              { 
               ?>
            <div class="alert alert-success alert-dismissable">
            <?php echo $this->session->flashdata('created'); ?>
            </div>
            <?php        
            }
            ?>

            <!-- /.card-header -->
                <form role="form" method="POST" onsubmit="return validateForm(this);" action="<?php echo base_url('admin/property_status_process/'.$property->propertyToken.''); ?>" enctype="multipart/form-data">
                <div class="card-body">
                   <div class="row">

                  <div class="col-md-3">
                  <div class="form-group">
                    <label for="exampleInputPassword1">Status</label>
                    <select class="form-control" required name="property_status">
                    <option value="2" <?php if($property->status=="2") { echo "selected"; } ?>>Under Approvel</option>
                    <option value="3" <?php if($property->status=="3") { echo "selected"; } ?>>Approved</option>
                    <option value="4" <?php if($property->status=="4") { echo "selected"; } ?>>Pending</option>
                    </select> 
                  </div>
                  </div>

                  <div class="col-md-12">
                  <div class="form-group">
                    <label for="exampleInputPassword1">Remark</label>
                    <div class="mb-3">
                    <textarea placeholder="" class="form-control" style="width: 50%;" name="contact_client_conversation"></textarea>
                    </div>
                  </div>
                  </div>
                  
                  <div class="col-md-6">
                  <div class="form-group">
                  <input type="submit" style="float:right;" name="SubmitConversationInventory" value="Submit" class="btn btn-primary">
                  </div>
                  </div>


                  </div>
                </div>
                
              </form>




            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>

        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->



